/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.gpl;

import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import uk.ac.starlink.ttools.filter.IntComparator;
import uk.ac.starlink.ttools.gpl.ArraysParallelSortHelpers;
import uk.ac.starlink.ttools.gpl.IntTimSort;

public class SortUtils {
    private static final int MIN_ARRAY_SORT_GRAN = 8192;

    private SortUtils() {
    }

    public static void intSort(int[] array, IntComparator cmp) {
        if (cmp == null) {
            cmp = Integer::compare;
        }
        IntTimSort.sort(array, 0, array.length, cmp, null, 0, 0);
    }

    public static void parallelIntSort(int[] array, IntComparator cmp) {
        IntComparator cmp0 = cmp == null ? Integer::compare : cmp;
        SortUtils.parallelIntSort(array, () -> cmp0);
    }

    public static void parallelIntSort(int[] array, Supplier<? extends IntComparator> cmpSupplier) {
        if (cmpSupplier == null) {
            cmpSupplier = () -> Integer::compare;
        }
        int n = array.length;
        int p = ForkJoinPool.getCommonPoolParallelism();
        if (n <= 8192 || p == 1) {
            IntTimSort.sort(array, 0, n, cmpSupplier.get(), null, 0, 0);
        } else {
            int g = n / (p << 2);
            new ArraysParallelSortHelpers.FJObject.Sorter(null, array, new int[n], 0, n, 0, g <= 8192 ? 8192 : g, cmpSupplier).invoke();
        }
    }
}

