/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry;

import skyview.Component;
import skyview.survey.Image;

public class DepthSampler
implements Component {
    private double zero;
    private double delta;
    private int n;

    public String getName() {
        return "DepthSampler";
    }

    public String getDescription() {
        return "Resample an image in the third (typically energy-like) dimension";
    }

    public DepthSampler(double zero, double delta, int n) {
        this.zero = zero;
        this.delta = delta;
        this.n = n;
    }

    public Image sample(Image in) {
        if (this.n == in.getDepth() && this.zero == 0.0 && this.delta == 1.0) {
            return in;
        }
        int mx = in.getWidth();
        int my = in.getHeight();
        int mz = in.getDepth();
        double[] output = new double[mx * my * this.n];
        for (int tz = 0; tz < this.n; ++tz) {
            double rat;
            double zmin = (double)tz * this.delta + this.zero;
            double zmax = (double)(tz + 1) * this.delta + this.zero;
            if (Math.floor(zmin) == Math.floor(zmax) || Math.floor(zmin) == zmin && this.delta == 1.0) {
                int itz = (int)Math.floor(zmin);
                int inOffset = itz * mx * my;
                int outOffset = tz * mx * my;
                rat = zmax - zmin;
                for (int ty = 0; ty < my; ++ty) {
                    for (int tx = 0; tx < mx; ++tx) {
                        if (itz >= 0 && itz < mz) {
                            output[outOffset] = rat * in.getData(inOffset);
                        }
                        ++outOffset;
                        ++inOffset;
                    }
                }
                continue;
            }
            int itzs = (int)Math.floor(zmin);
            int itze = (int)Math.floor(zmax);
            if (zmax == (double)itze) {
                --itze;
            }
            for (int itz = itzs; itz <= itze; ++itz) {
                if (itz < 0 || itz > mz) continue;
                rat = 1.0;
                if (itz == itzs) {
                    rat = 1.0 - (zmin - Math.floor(zmin));
                } else if (itz == itze) {
                    rat = zmax - Math.floor(zmax);
                }
                int inOffset = itz * mx * my;
                int outOffset = tz * mx * my;
                for (int ty = 0; ty < my; ++ty) {
                    for (int tx = 0; tx < mx; ++tx) {
                        if (itz >= 0 && itz < mz) {
                            int n = outOffset;
                            output[n] = output[n] + rat * in.getData(inOffset);
                        }
                        ++outOffset;
                        ++inOffset;
                    }
                }
            }
        }
        Image out = new Image();
        try {
            out.initialize(output, in.getWCS(), mx, my, this.n);
        }
        catch (Exception e) {
            throw new Error("Unexpected exception in DepthSampler:" + e);
        }
        return out;
    }
}

