/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import uk.ac.starlink.fits.AbstractFitsTableWriter;
import uk.ac.starlink.table.MultiStarTableWriter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.formats.DocumentedIOHandler;
import uk.ac.starlink.util.ConfigMethod;
import uk.ac.starlink.util.DataBufferedOutputStream;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.ResourceType;
import uk.ac.starlink.votable.StringElementSizer;
import uk.ac.starlink.votable.VOSerializer;
import uk.ac.starlink.votable.VOSerializerConfig;
import uk.ac.starlink.votable.VOTableVersion;

public class VOTableWriter
implements StarTableWriter,
MultiStarTableWriter,
DocumentedIOHandler {
    private DataFormat dataFormat_;
    private boolean inline_;
    private VOTableVersion version_;
    private StringElementSizer stringSizer_;
    private Boolean compact_;
    private Charset encoding_;
    private boolean writeSchemaLocation_;
    private boolean writeDate_;
    private ResourceType resourceType_;
    private String xmlDeclaration_ = "<?xml version='1.0'?>";
    public static final String DEFAULT_XML_DECLARATION = "<?xml version='1.0'?>";
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.votable");

    public VOTableWriter() {
        this(DataFormat.TABLEDATA, true);
    }

    public VOTableWriter(DataFormat dataFormat, boolean inline) {
        this(dataFormat, inline, VOTableVersion.getDefaultVersion());
    }

    public VOTableWriter(DataFormat dataFormat, boolean inline, VOTableVersion version) {
        this.dataFormat_ = dataFormat;
        this.inline_ = inline;
        this.version_ = version;
        this.stringSizer_ = StringElementSizer.READ;
        this.encoding_ = StandardCharsets.UTF_8;
        this.writeDate_ = true;
    }

    @Override
    public void writeStarTable(StarTable startab, String location, StarTableOutput sto) throws IOException {
        this.writeStarTables(Tables.singleTableSequence(startab), location, sto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStarTables(TableSequence tableSeq, String location, StarTableOutput sto) throws IOException {
        try (OutputStream out = null;){
            File file;
            out = sto.getOutputStream(location);
            File file2 = file = out instanceof FileOutputStream ? new File(location) : null;
            if (!this.inline_ && file == null) {
                throw new TableFormatException("Can't write non-inline format to a stream");
            }
            this.writeStarTables(tableSeq, out, file);
        }
    }

    @Override
    public void writeStarTable(StarTable startab, OutputStream out) throws IOException {
        this.writeStarTable(startab, out, null);
    }

    @Override
    public void writeStarTables(TableSequence tableSeq, OutputStream out) throws IOException {
        this.writeStarTables(tableSeq, out, null);
    }

    public void writeStarTable(StarTable startab, OutputStream out, File file) throws IOException {
        this.writeStarTables(Tables.singleTableSequence(startab), out, file);
    }

    public void writeStarTables(TableSequence tableSeq, OutputStream out, File file) throws IOException {
        StarTable startab;
        VOSerializerConfig config = new VOSerializerConfig(this.dataFormat_, this.version_, this.stringSizer_);
        Charset encoding = this.encoding_;
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, encoding));
        boolean isUtf8 = StandardCharsets.UTF_8.equals(encoding);
        this.writePreTableXML(writer);
        int itable = 0;
        while ((startab = tableSeq.nextTable()) != null) {
            if (itable > 0) {
                this.writeBetweenTableXML(writer);
            }
            VOSerializer serializer = VOSerializer.makeSerializer(config, startab);
            if (this.compact_ != null) {
                serializer.setCompact(this.compact_);
            }
            serializer.writePreDataXML(writer);
            if (this.inline_ || file == null) {
                if (!this.inline_) {
                    assert (file == null);
                    logger.warning("Writing VOTable inline - can't do href when no filename is supplied");
                }
                writer.flush();
                if (isUtf8) {
                    serializer.writeInlineDataElementUTF8(out);
                } else {
                    serializer.writeInlineDataElement(writer);
                }
            } else {
                assert (file != null);
                String basename = file.getName();
                int dotpos = basename.lastIndexOf(46);
                basename = dotpos > 0 ? basename.substring(0, dotpos) : basename;
                String extension = this.dataFormat_ == DataFormat.FITS ? ".fits" : ".bin";
                String dataname = basename + "-data" + (itable > 0 ? Integer.toString(itable) : "") + extension;
                File datafile = new File(file.getParentFile(), dataname);
                logger.info("Writing VOTable href data at " + datafile);
                DataBufferedOutputStream dataout = new DataBufferedOutputStream(new FileOutputStream(datafile));
                serializer.writeHrefDataElement(writer, dataname, dataout);
                dataout.close();
            }
            serializer.writePostDataXML(writer);
            ++itable;
        }
        this.writePostTableXML(writer);
        writer.flush();
    }

    public void writeInlineStarTable(StarTable startab, BufferedWriter writer) throws IOException {
        this.writeInlineStarTables(new StarTable[]{startab}, writer);
    }

    public void writeInlineStarTables(StarTable[] startabs, BufferedWriter writer) throws IOException {
        VOSerializerConfig config = new VOSerializerConfig(this.dataFormat_, this.version_, this.stringSizer_);
        this.writePreTableXML(writer);
        for (int i = 0; i < startabs.length; ++i) {
            if (i > 0) {
                this.writeBetweenTableXML(writer);
            }
            VOSerializer.makeSerializer(config, startabs[i]).writeInlineTableElement(writer);
        }
        this.writePostTableXML(writer);
        writer.flush();
    }

    public void writePreTableXML(BufferedWriter writer) throws IOException {
        String doctypeDeclaration;
        if (this.xmlDeclaration_ != null && this.xmlDeclaration_.length() > 0) {
            writer.write(this.xmlDeclaration_);
            writer.newLine();
        }
        if ((doctypeDeclaration = this.version_.getDoctypeDeclaration()) != null && doctypeDeclaration.length() > 0) {
            writer.write(doctypeDeclaration);
            writer.newLine();
        }
        writer.write("<VOTABLE");
        String versionNumber = this.version_.getVersionNumber();
        if (versionNumber != null) {
            writer.write(VOSerializer.formatAttribute("version", versionNumber));
        }
        String xmlNamespace = this.version_.getXmlNamespace();
        String schemaLocation = this.version_.getSchemaLocation();
        if (xmlNamespace != null) {
            if (this.writeSchemaLocation_ && schemaLocation != null) {
                writer.newLine();
                writer.write(VOSerializer.formatAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"));
                writer.newLine();
                writer.write(VOSerializer.formatAttribute("xsi:schemaLocation", xmlNamespace + " " + schemaLocation));
            }
            writer.newLine();
            writer.write(VOSerializer.formatAttribute("xmlns", xmlNamespace));
        }
        writer.write(">");
        writer.newLine();
        writer.write("<!--");
        writer.newLine();
        writer.write(" !  VOTable written by STIL version " + IOUtils.getResourceContents(StarTable.class, "stil.version", null) + " (" + VOSerializer.formatText(this.getClass().getName()) + ")");
        writer.newLine();
        if (this.writeDate_) {
            writer.write(" !  at " + AbstractFitsTableWriter.getCurrentDate());
            writer.newLine();
        }
        writer.write(" !-->");
        writer.newLine();
        writer.write(this.createResourceStartTag());
        writer.newLine();
    }

    public void writeBetweenTableXML(BufferedWriter writer) throws IOException {
        writer.write("</RESOURCE>");
        writer.newLine();
        writer.write(this.createResourceStartTag());
        writer.newLine();
    }

    public void writePostTableXML(BufferedWriter writer) throws IOException {
        writer.write("</RESOURCE>");
        writer.newLine();
        writer.write("</VOTABLE>");
        writer.newLine();
    }

    @Override
    public String[] getExtensions() {
        return new String[]{"vot", "votable", "xml"};
    }

    @Override
    public boolean looksLikeFile(String filename) {
        return DocumentedIOHandler.matchesExtension(this, filename);
    }

    @Override
    public boolean docIncludesExample() {
        return false;
    }

    @Override
    public String getXmlDescription() {
        return this.readText("VOTableWriter.xml");
    }

    @Override
    public String getFormatName() {
        StringBuffer fname = new StringBuffer("votable");
        if (this.dataFormat_ == DataFormat.TABLEDATA) {
            return fname.toString();
        }
        if (this.dataFormat_ == DataFormat.FITS) {
            fname.append("-fits");
        } else if (this.dataFormat_ == DataFormat.BINARY) {
            fname.append("-binary");
        } else if (this.dataFormat_ == DataFormat.BINARY2) {
            fname.append("-binary2");
        } else assert (false);
        fname.append(this.inline_ ? "-inline" : "-href");
        return fname.toString();
    }

    @Override
    public String getMimeType() {
        String type = "application/x-votable+xml";
        String serialization = this.dataFormat_ == DataFormat.TABLEDATA ? "TABLEDATA" : (this.dataFormat_ == DataFormat.BINARY ? "BINARY" : (this.dataFormat_ == DataFormat.BINARY2 ? "BINARY2" : (this.dataFormat_ == DataFormat.FITS ? "FITS" : null)));
        StringBuffer sbuf = new StringBuffer(type);
        if (serialization != null) {
            sbuf.append("; serialization=").append(serialization);
        }
        return sbuf.toString();
    }

    @ConfigMethod(property="format", usage="TABLEDATA|BINARY|BINARY2|FITS", doc="<p>Gives the serialization type (DATA element content) of output VOTables.</p>", example="BINARY2", sequence=1)
    public void setDataFormat(DataFormat format) {
        this.dataFormat_ = format;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat_;
    }

    @ConfigMethod(property="inline", doc="If true, STREAM elements are written base64-encoded within the body of the document, and if false they are written to a new external binary file whose name is derived from that of the output VOTable document. This is only applicable to BINARY, BINARY2 and FITS formats where output is not to a stream.", sequence=3)
    public void setInline(boolean inline) {
        this.inline_ = inline;
    }

    public boolean getInline() {
        return this.inline_;
    }

    public void setXMLDeclaration(String xmlDecl) {
        this.xmlDeclaration_ = xmlDecl;
    }

    public String getXMLDeclaration() {
        return this.xmlDeclaration_;
    }

    @ConfigMethod(property="version", usage="V10|V11|V12|V13|V14|V15", example="V13", doc="<p>Gives the version of the VOTable format which will be used when writing the VOTable.\n\"<code>V10</code>\" is version 1.0 etc.</p>", sequence=2)
    public void setVotableVersion(VOTableVersion version) {
        this.version_ = version;
    }

    public VOTableVersion getVotableVersion() {
        return this.version_;
    }

    @ConfigMethod(property="compact", example="true", doc="<p>Controls whitespace formatting for TABLEDATA output,\nignored for other formats.\nBy default a decision will be taken dependent on table width.\n</p>", sequence=4)
    public void setCompact(Boolean compact) {
        this.compact_ = compact;
    }

    public Boolean isCompact() {
        return this.compact_;
    }

    @ConfigMethod(property="encoding", usage="UTF-8|UTF-16|...", example="UTF-16", doc="<p>Specifies the XML encoding used in the output VOTable.\nThe default value is UTF-8.\nNote that certain optimisations are in place for UTF-8 output\nwhich means that other encodings may be significantly slower.\n</p>", sequence=5)
    public void setEncoding(Charset encoding) {
        this.encoding_ = encoding;
    }

    public Charset getEncoding() {
        return this.encoding_;
    }

    @ConfigMethod(property="date", doc="<p>If true, the output file will contain a comment recording the current date; otherwise it is not included.</p>")
    public void setWriteDate(boolean writeDate) {
        this.writeDate_ = writeDate;
    }

    public boolean getWriteDate() {
        return this.writeDate_;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType_ = resourceType;
    }

    public ResourceType getResourceType() {
        return this.resourceType_;
    }

    public void setWriteSchemaLocation(boolean writeSchemaLocation) {
        this.writeSchemaLocation_ = writeSchemaLocation;
    }

    public boolean getWriteSchemaLocation() {
        return this.writeSchemaLocation_;
    }

    public void setStringElementSizer(StringElementSizer stringSizer) {
        this.stringSizer_ = stringSizer;
    }

    public StringElementSizer getStringElementSizer() {
        return this.stringSizer_;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.dataFormat_.toString());
        if (this.dataFormat_ != DataFormat.TABLEDATA) {
            sbuf.append(",").append(this.inline_ ? "inline" : "href");
        }
        sbuf.append(",v").append(this.version_.getVersionNumber());
        return sbuf.toString();
    }

    protected String createResourceStartTag() {
        StringBuffer sbuf = new StringBuffer("<RESOURCE");
        if (this.resourceType_ != null) {
            sbuf.append(VOSerializer.formatAttribute("type", this.resourceType_.toString()));
        }
        sbuf.append(">");
        return sbuf.toString();
    }
}

