/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.feather;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.ac.bristol.star.feather.BufUtils;
import uk.ac.bristol.star.feather.FeatherType;
import uk.ac.starlink.feather.BooleanStarColumnWriter;
import uk.ac.starlink.feather.NumberStarColumnWriter;
import uk.ac.starlink.feather.StarColumnWriter;
import uk.ac.starlink.feather.VariableStarColumnWriter;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;

public class StarColumnWriters {
    public static final VariableStarColumnWriter.PointerSize VAR_POINTER_SIZE;
    private static final byte[] FLOAT_NAN;
    private static final byte[] DOUBLE_NAN;

    private StarColumnWriters() {
    }

    public static StarColumnWriter createColumnWriter(StarTable table, int icol) {
        ColumnInfo info = table.getColumnInfo(icol);
        Class clazz = info.getContentClass();
        if (clazz == Double.class) {
            return new NumberStarColumnWriter(table, icol, FeatherType.DOUBLE, false, DOUBLE_NAN){

                @Override
                public void writeNumber(OutputStream out, Number val) throws IOException {
                    BufUtils.writeLittleEndianDouble(out, val.doubleValue());
                }
            };
        }
        if (clazz == Float.class) {
            return new NumberStarColumnWriter(table, icol, FeatherType.FLOAT, false, FLOAT_NAN){

                @Override
                public void writeNumber(OutputStream out, Number val) throws IOException {
                    BufUtils.writeLittleEndianFloat(out, val.floatValue());
                }
            };
        }
        if (clazz == Long.class) {
            return new NumberStarColumnWriter(table, icol, FeatherType.INT64, true, new byte[8]){

                @Override
                public void writeNumber(OutputStream out, Number val) throws IOException {
                    BufUtils.writeLittleEndianLong(out, val.longValue());
                }
            };
        }
        if (clazz == Integer.class) {
            return new NumberStarColumnWriter(table, icol, FeatherType.INT32, true, new byte[4]){

                @Override
                public void writeNumber(OutputStream out, Number val) throws IOException {
                    BufUtils.writeLittleEndianInt(out, val.intValue());
                }
            };
        }
        if (clazz == Short.class) {
            if (info.getAuxDatumValue(Tables.UBYTE_FLAG_INFO, Boolean.class) == Boolean.TRUE) {
                return new NumberStarColumnWriter(table, icol, FeatherType.UINT8, true, new byte[1]){

                    @Override
                    public void writeNumber(OutputStream out, Number val) throws IOException {
                        out.write(val.shortValue() & 0xFF);
                    }
                };
            }
            return new NumberStarColumnWriter(table, icol, FeatherType.INT16, true, new byte[2]){

                @Override
                public void writeNumber(OutputStream out, Number val) throws IOException {
                    BufUtils.writeLittleEndianShort(out, val.shortValue());
                }
            };
        }
        if (clazz == Byte.class) {
            return new NumberStarColumnWriter(table, icol, FeatherType.INT8, true, new byte[1]){

                @Override
                public void writeNumber(OutputStream out, Number val) throws IOException {
                    out.write(val.byteValue() & 0xFF);
                }
            };
        }
        if (clazz == Boolean.class) {
            return new BooleanStarColumnWriter(table, icol);
        }
        if (clazz == String.class) {
            return VariableStarColumnWriter.createStringWriter(table, icol, false, VAR_POINTER_SIZE);
        }
        if (clazz == byte[].class) {
            return VariableStarColumnWriter.createByteArrayWriter(table, icol, true, VAR_POINTER_SIZE);
        }
        return null;
    }

    static {
        ByteArrayOutputStream fout;
        ByteArrayOutputStream dout;
        block4: {
            VAR_POINTER_SIZE = VariableStarColumnWriter.PointerSize.I64;
            dout = new ByteArrayOutputStream(8);
            fout = new ByteArrayOutputStream(4);
            try {
                BufUtils.writeLittleEndianDouble(dout, Double.NaN);
                BufUtils.writeLittleEndianFloat(fout, Float.NaN);
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        DOUBLE_NAN = dout.toByteArray();
        FLOAT_NAN = fout.toByteArray();
        assert (DOUBLE_NAN.length == 8);
        assert (FLOAT_NAN.length == 4);
    }
}

