/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.registry;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.starlink.registry.SoapRequest;

public class SoapClient {
    private final URL endpoint_;
    private OutputStream echoStream_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");
    private static final String SOAP_ENV_NS = "http://schemas.xmlsoap.org/soap/envelope/";

    public SoapClient(URL endpoint) {
        this.endpoint_ = endpoint;
    }

    public URL getEndpoint() {
        return this.endpoint_;
    }

    public void setEchoStream(OutputStream echoStream) {
        this.echoStream_ = echoStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SoapRequest request, ContentHandler responseBodyHandler) throws IOException, SAXException {
        byte[] requestXml = this.createRequest(request.getBody());
        String soapAction = request.getAction();
        logger_.info("SOAP " + soapAction + " -> " + this.endpoint_);
        URLConnection conn = this.endpoint_.openConnection();
        if (!(conn instanceof HttpURLConnection)) {
            throw new IOException("Not an HTTP connection??");
        }
        HttpURLConnection hconn = (HttpURLConnection)conn;
        hconn.setRequestProperty("Content-Length", Integer.toString(requestXml.length));
        hconn.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
        hconn.setRequestProperty("Accept", "application/soap+xml");
        if (soapAction != null && soapAction.trim().length() > 0) {
            hconn.setRequestProperty("SOAPAction", "\"" + soapAction + "\"");
        }
        hconn.setRequestMethod("POST");
        hconn.setDoOutput(true);
        hconn.setDoInput(true);
        FilterOutputStream out = new BufferedOutputStream(hconn.getOutputStream());
        if (this.echoStream_ != null) {
            out = new EchoOutputStream(out, this.echoStream_);
        }
        ((OutputStream)out).write(requestXml);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        int responseCode = hconn.getResponseCode();
        logger_.info("SOAP response " + responseCode);
        if (responseCode == 200) {
            ResponseHandler handler = new ResponseHandler(responseBodyHandler);
            FilterInputStream in = new BufferedInputStream(hconn.getInputStream());
            if (this.echoStream_ != null) {
                in = new EchoInputStream(in, this.echoStream_);
            }
            try {
                SoapClient.createSaxParser().parse((InputStream)in, (DefaultHandler)handler);
            }
            finally {
                ((InputStream)in).close();
                hconn.disconnect();
            }
        } else {
            if (responseCode == 500) {
                FaultHandler handler = new FaultHandler();
                InputStream err = hconn.getErrorStream();
                if (this.echoStream_ != null) {
                    err = new EchoInputStream(err, this.echoStream_);
                }
                try {
                    try {
                        SoapClient.createSaxParser().parse(err, (DefaultHandler)handler);
                        throw new IOException("SOAP Fault: " + handler.faultCode_ + "; " + handler.faultString_);
                    }
                    catch (SAXException e) {
                        throw (IOException)new IOException("Badly formed SOAP fault?").initCause(e);
                    }
                }
                catch (Throwable throwable) {
                    err.close();
                    hconn.disconnect();
                    throw throwable;
                }
            }
            String msg = "SOAP connection failed: " + responseCode + ": " + hconn.getResponseMessage();
            hconn.disconnect();
            throw new IOException(msg);
        }
    }

    private byte[] createRequest(String bodyContent) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(bout);
        pout.println("<?xml version='1.0' encoding='utf-8'?>");
        pout.println("<soapenv:Envelope");
        pout.println("  xmlns:soapenv='http://schemas.xmlsoap.org/soap/envelope/'");
        pout.println("  xmlns:xsi='http://www.w3.org/1999/XMLSchema-instance'");
        pout.println("  xmlns:xsd='http://www.w3.org/1999/XMLSchema'>");
        pout.println("  <soapenv:Body>");
        pout.flush();
        bout.write(bodyContent.getBytes("utf-8"));
        bout.flush();
        pout.println("  </soapenv:Body>");
        pout.println("</soapenv:Envelope>");
        pout.flush();
        bout.flush();
        return bout.toByteArray();
    }

    private static SAXParser createSaxParser() throws IOException {
        try {
            SAXParserFactory spfact = SAXParserFactory.newInstance();
            spfact.setNamespaceAware(true);
            spfact.setValidating(false);
            return spfact.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException("SAX parse trouble").initCause(e);
        }
        catch (SAXException e) {
            throw (IOException)new IOException("SAX parse trouble").initCause(e);
        }
    }

    private static class EchoInputStream
    extends FilterInputStream {
        private final InputStream in_;
        private final OutputStream echo_;

        EchoInputStream(InputStream in, OutputStream echo) {
            super(in);
            this.in_ = in;
            this.echo_ = echo;
        }

        @Override
        public int read() throws IOException {
            int c = this.in_.read();
            if (c >= 0) {
                this.echo_.write(c);
            }
            return c;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int n = this.in_.read(b);
            if (n > 0) {
                this.echo_.write(b, 0, n);
            }
            return n;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.in_.read(b, off, len);
            if (n > 0) {
                this.echo_.write(b, off, n);
            }
            return n;
        }
    }

    private static class EchoOutputStream
    extends FilterOutputStream {
        private final OutputStream out_;
        private final OutputStream echo_;

        EchoOutputStream(OutputStream out, OutputStream echo) {
            super(out);
            this.out_ = out;
            this.echo_ = echo;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out_.write(b);
            this.echo_.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out_.write(b, off, len);
            this.echo_.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.out_.write(b);
            this.echo_.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.out_.flush();
            this.echo_.flush();
        }
    }

    private static class FaultHandler
    extends DefaultHandler {
        private String faultString_;
        private String faultCode_;
        private StringBuffer charBuf_;

        private FaultHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            if ("faultstring".equals(localName) || "faultcode".equals(localName)) {
                this.charBuf_ = new StringBuffer();
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if ("faultstring".equals(localName)) {
                this.faultString_ = this.charBuf_.toString();
                this.charBuf_ = null;
            } else if ("faultcode".equals(localName)) {
                this.faultCode_ = this.charBuf_.toString();
                this.charBuf_ = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.charBuf_ != null) {
                this.charBuf_.append(ch, start, length);
            }
        }
    }

    private static class ResponseHandler
    extends DefaultHandler {
        private final ContentHandler bodyHandler_;
        private boolean inEnvelope_;
        private boolean inBody_;

        ResponseHandler(ContentHandler bodyHandler) {
            this.bodyHandler_ = bodyHandler;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (!this.inEnvelope_) {
                if (SoapClient.SOAP_ENV_NS.equals(namespaceURI) && "Envelope".equals(localName)) {
                    this.inEnvelope_ = true;
                }
            } else if (!this.inBody_) {
                if (SoapClient.SOAP_ENV_NS.equals(namespaceURI) && "Body".equals(localName)) {
                    this.inBody_ = true;
                }
            } else {
                this.bodyHandler_.startElement(namespaceURI, localName, qName, atts);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.inBody_) {
                if (SoapClient.SOAP_ENV_NS.equals(namespaceURI) && "Body".equals(localName)) {
                    this.inBody_ = false;
                } else {
                    this.bodyHandler_.endElement(namespaceURI, localName, qName);
                }
            } else if (this.inEnvelope_ && SoapClient.SOAP_ENV_NS.equals(namespaceURI) && "Envelope".equals(localName)) {
                this.inEnvelope_ = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inBody_) {
                this.bodyHandler_.characters(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.inBody_) {
                this.bodyHandler_.ignorableWhitespace(ch, start, length);
            }
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            if (this.inBody_) {
                this.bodyHandler_.skippedEntity(name);
            }
        }

        @Override
        public void startDocument() throws SAXException {
            this.bodyHandler_.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.bodyHandler_.endDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.bodyHandler_.startPrefixMapping(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.bodyHandler_.endPrefixMapping(prefix);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.bodyHandler_.processingInstruction(target, data);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.bodyHandler_.setDocumentLocator(locator);
        }
    }
}

