/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.CJKFont;
import com.lowagie.text.pdf.EnumerateTTC;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TrueTypeFont;
import com.lowagie.text.pdf.TrueTypeFontUnicode;
import com.lowagie.text.pdf.Type1Font;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public abstract class BaseFont {
    public static final int[] CHAR_RANGE_LATIN = new int[]{0, 383, 8192, 8303, 8352, 8399, 64256, 64262};
    public static final int[] CHAR_RANGE_ARABIC = new int[]{0, 127, 1536, 1663, 8352, 8399, 64336, 64511, 65136, 65279};
    public static final int[] CHAR_RANGE_HEBREW = new int[]{0, 127, 1424, 1535, 8352, 8399, 64285, 64335};
    public static final int[] CHAR_RANGE_CYRILLIC = new int[]{0, 127, 1024, 1327, 8192, 8303, 8352, 8399};
    protected ArrayList subsetRanges;
    int fontType;
    protected int[] widths = new int[256];
    protected String[] differences = new String[256];
    protected char[] unicodeDifferences = new char[256];
    protected int[][] charBBoxes = new int[256][];
    protected String encoding;
    protected boolean embedded;
    protected int compressionLevel = -1;
    protected boolean fontSpecific = true;
    protected static HashMap fontCache = new HashMap();
    protected static final HashMap BuiltinFonts14 = new HashMap();
    protected boolean forceWidthsOutput = false;
    protected boolean directTextToByte = false;
    protected boolean subset = true;
    protected boolean fastWinansi = false;
    protected IntHashtable specialMap;

    protected BaseFont() {
    }

    public static BaseFont createFont(String string, String string2, boolean bl) throws DocumentException, IOException {
        return BaseFont.createFont(string, string2, bl, true, null, null, false);
    }

    public static BaseFont createFont(String string, String string2, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2) throws DocumentException, IOException {
        return BaseFont.createFont(string, string2, bl, bl2, byArray, byArray2, false);
    }

    public static BaseFont createFont(String string, String string2, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2, boolean bl3) throws DocumentException, IOException {
        return BaseFont.createFont(string, string2, bl, bl2, byArray, byArray2, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseFont createFont(String string, String string2, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2, boolean bl3, boolean bl4) throws DocumentException, IOException {
        HashMap hashMap;
        boolean bl5;
        String string3 = BaseFont.getBaseName(string);
        string2 = BaseFont.normalizeEncoding(string2);
        boolean bl6 = BuiltinFonts14.containsKey(string);
        boolean bl7 = bl5 = bl6 ? false : CJKFont.isCJKFont(string3, string2);
        if (bl6 || bl5) {
            bl = false;
        } else if (string2.equals("Identity-H") || string2.equals("Identity-V")) {
            bl = true;
        }
        BaseFont baseFont = null;
        BaseFont baseFont2 = null;
        String string4 = string + "\n" + string2 + "\n" + bl;
        if (bl2) {
            hashMap = fontCache;
            synchronized (hashMap) {
                baseFont = (BaseFont)fontCache.get(string4);
            }
            if (baseFont != null) {
                return baseFont;
            }
        }
        if (bl6 || string.toLowerCase().endsWith(".afm") || string.toLowerCase().endsWith(".pfm")) {
            baseFont2 = new Type1Font(string, string2, bl, byArray, byArray2, bl4);
            baseFont2.fastWinansi = string2.equals("Cp1252");
        } else if (string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0) {
            if (string2.equals("Identity-H") || string2.equals("Identity-V")) {
                baseFont2 = new TrueTypeFontUnicode(string, string2, bl, byArray, bl4);
            } else {
                baseFont2 = new TrueTypeFont(string, string2, bl, byArray, false, bl4);
                baseFont2.fastWinansi = string2.equals("Cp1252");
            }
        } else if (bl5) {
            baseFont2 = new CJKFont(string, string2, bl);
        } else {
            if (bl3) {
                return null;
            }
            throw new DocumentException("Font '" + string + "' with '" + string2 + "' is not recognized.");
        }
        if (bl2) {
            hashMap = fontCache;
            synchronized (hashMap) {
                baseFont = (BaseFont)fontCache.get(string4);
                if (baseFont != null) {
                    return baseFont;
                }
                fontCache.put(string4, baseFont2);
            }
        }
        return baseFont2;
    }

    protected static String getBaseName(String string) {
        if (string.endsWith(",Bold")) {
            return string.substring(0, string.length() - 5);
        }
        if (string.endsWith(",Italic")) {
            return string.substring(0, string.length() - 7);
        }
        if (string.endsWith(",BoldItalic")) {
            return string.substring(0, string.length() - 11);
        }
        return string;
    }

    protected static String normalizeEncoding(String string) {
        if (string.equals("winansi") || string.equals("")) {
            return "Cp1252";
        }
        if (string.equals("macroman")) {
            return "MacRoman";
        }
        return string;
    }

    protected void createEncoding() {
        if (this.encoding.startsWith("#")) {
            int n;
            String string;
            this.specialMap = new IntHashtable();
            StringTokenizer stringTokenizer = new StringTokenizer(this.encoding.substring(1), " ,\t\n\r\f");
            if (stringTokenizer.nextToken().equals("full")) {
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    string = stringTokenizer.nextToken();
                    n = Integer.parseInt(stringTokenizer.nextToken(), 16);
                    int n2 = string2.startsWith("'") ? (int)string2.charAt(1) : Integer.parseInt(string2);
                    this.specialMap.put(n, n2 %= 256);
                    this.differences[n2] = string;
                    this.unicodeDifferences[n2] = n;
                    this.widths[n2] = this.getRawWidth(n, string);
                    this.charBBoxes[n2] = this.getRawCharBBox(n, string);
                }
            } else {
                int n3 = 0;
                if (stringTokenizer.hasMoreTokens()) {
                    n3 = Integer.parseInt(stringTokenizer.nextToken());
                }
                while (stringTokenizer.hasMoreTokens() && n3 < 256) {
                    string = stringTokenizer.nextToken();
                    n = Integer.parseInt(string, 16) % 65536;
                    String string3 = GlyphList.unicodeToName(n);
                    if (string3 == null) continue;
                    this.specialMap.put(n, n3);
                    this.differences[n3] = string3;
                    this.unicodeDifferences[n3] = (char)n;
                    this.widths[n3] = this.getRawWidth(n, string3);
                    this.charBBoxes[n3] = this.getRawCharBBox(n, string3);
                    ++n3;
                }
            }
            for (int i = 0; i < 256; ++i) {
                if (this.differences[i] != null) continue;
                this.differences[i] = ".notdef";
            }
        } else if (this.fontSpecific) {
            for (int i = 0; i < 256; ++i) {
                this.widths[i] = this.getRawWidth(i, null);
                this.charBBoxes[i] = this.getRawCharBBox(i, null);
            }
        } else {
            byte[] byArray = new byte[1];
            for (int i = 0; i < 256; ++i) {
                byArray[0] = (byte)i;
                String string = PdfEncodings.convertToString(byArray, this.encoding);
                int n = string.length() > 0 ? (int)string.charAt(0) : 63;
                String string4 = GlyphList.unicodeToName(n);
                if (string4 == null) {
                    string4 = ".notdef";
                }
                this.differences[i] = string4;
                this.unicodeDifferences[i] = n;
                this.widths[i] = this.getRawWidth(n, string4);
                this.charBBoxes[i] = this.getRawCharBBox(n, string4);
            }
        }
    }

    abstract int getRawWidth(int var1, String var2);

    public abstract int getKerning(int var1, int var2);

    public int getWidth(int n) {
        if (this.fastWinansi) {
            if (n < 128 || n >= 160 && n <= 255) {
                return this.widths[n];
            }
            return this.widths[PdfEncodings.winansi.get(n)];
        }
        int n2 = 0;
        byte[] byArray = this.convertToBytes((char)n);
        for (int i = 0; i < byArray.length; ++i) {
            n2 += this.widths[0xFF & byArray[i]];
        }
        return n2;
    }

    public int getWidth(String string) {
        int n = 0;
        if (this.fastWinansi) {
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                if (c < '\u0080' || c >= '\u00a0' && c <= '\u00ff') {
                    n += this.widths[c];
                    continue;
                }
                n += this.widths[PdfEncodings.winansi.get(c)];
            }
            return n;
        }
        byte[] byArray = this.convertToBytes(string);
        for (int i = 0; i < byArray.length; ++i) {
            n += this.widths[0xFF & byArray[i]];
        }
        return n;
    }

    public float getWidthPointKerned(String string, float f) {
        float f2 = (float)this.getWidth(string) * 0.001f * f;
        if (!this.hasKernPairs()) {
            return f2;
        }
        int n = string.length() - 1;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < n; ++i) {
            n2 += this.getKerning(cArray[i], cArray[i + 1]);
        }
        return f2 + (float)n2 * 0.001f * f;
    }

    public float getWidthPoint(String string, float f) {
        return (float)this.getWidth(string) * 0.001f * f;
    }

    public float getWidthPoint(int n, float f) {
        return (float)this.getWidth(n) * 0.001f * f;
    }

    byte[] convertToBytes(String string) {
        if (this.directTextToByte) {
            return PdfEncodings.convertToBytes(string, null);
        }
        if (this.specialMap != null) {
            byte[] byArray = new byte[string.length()];
            int n = 0;
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                if (!this.specialMap.containsKey(c)) continue;
                byArray[n++] = (byte)this.specialMap.get(c);
            }
            if (n < n2) {
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                return byArray2;
            }
            return byArray;
        }
        return PdfEncodings.convertToBytes(string, this.encoding);
    }

    byte[] convertToBytes(int n) {
        if (this.directTextToByte) {
            return PdfEncodings.convertToBytes((char)n, null);
        }
        if (this.specialMap != null) {
            if (this.specialMap.containsKey(n)) {
                return new byte[]{(byte)this.specialMap.get(n)};
            }
            return new byte[0];
        }
        return PdfEncodings.convertToBytes((char)n, this.encoding);
    }

    abstract void writeFont(PdfWriter var1, PdfIndirectReference var2, Object[] var3) throws DocumentException, IOException;

    public String getEncoding() {
        return this.encoding;
    }

    public abstract float getFontDescriptor(int var1, float var2);

    public int getFontType() {
        return this.fontType;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean isFontSpecific() {
        return this.fontSpecific;
    }

    public static String createSubsetPrefix() {
        String string = "";
        for (int i = 0; i < 6; ++i) {
            string = string + (char)(Math.random() * 26.0 + 65.0);
        }
        return string + "+";
    }

    char getUnicodeDifferences(int n) {
        return this.unicodeDifferences[n];
    }

    public abstract String getPostscriptFontName();

    public abstract String[][] getFullFontName();

    public static Object[] getAllFontNames(String string, String string2, byte[] byArray) throws DocumentException, IOException {
        String string3 = BaseFont.getBaseName(string);
        BaseFont baseFont = null;
        baseFont = string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0 ? new TrueTypeFont(string, "Cp1252", false, byArray, true, false) : BaseFont.createFont(string, string2, false, false, byArray, null);
        return new Object[]{baseFont.getPostscriptFontName(), baseFont.getFamilyFontName(), baseFont.getFullFontName()};
    }

    public abstract String[][] getFamilyFontName();

    public static String[] enumerateTTCNames(String string) throws DocumentException, IOException {
        return new EnumerateTTC(string).getNames();
    }

    public boolean isSubset() {
        return this.subset;
    }

    public static InputStream getResourceStream(String string) {
        return BaseFont.getResourceStream(string, null);
    }

    public static InputStream getResourceStream(String string, ClassLoader classLoader) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        InputStream inputStream = null;
        if (classLoader != null && (inputStream = classLoader.getResourceAsStream(string)) != null) {
            return inputStream;
        }
        try {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            if (classLoader2 != null) {
                inputStream = classLoader2.getResourceAsStream(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (inputStream == null) {
            inputStream = BaseFont.class.getResourceAsStream("/" + string);
        }
        if (inputStream == null) {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
        }
        return inputStream;
    }

    public int getUnicodeEquivalent(int n) {
        return n;
    }

    public abstract boolean hasKernPairs();

    protected abstract int[] getRawCharBBox(int var1, String var2);

    static {
        BuiltinFonts14.put("Courier", PdfName.COURIER);
        BuiltinFonts14.put("Courier-Bold", PdfName.COURIER_BOLD);
        BuiltinFonts14.put("Courier-BoldOblique", PdfName.COURIER_BOLDOBLIQUE);
        BuiltinFonts14.put("Courier-Oblique", PdfName.COURIER_OBLIQUE);
        BuiltinFonts14.put("Helvetica", PdfName.HELVETICA);
        BuiltinFonts14.put("Helvetica-Bold", PdfName.HELVETICA_BOLD);
        BuiltinFonts14.put("Helvetica-BoldOblique", PdfName.HELVETICA_BOLDOBLIQUE);
        BuiltinFonts14.put("Helvetica-Oblique", PdfName.HELVETICA_OBLIQUE);
        BuiltinFonts14.put("Symbol", PdfName.SYMBOL);
        BuiltinFonts14.put("Times-Roman", PdfName.TIMES_ROMAN);
        BuiltinFonts14.put("Times-Bold", PdfName.TIMES_BOLD);
        BuiltinFonts14.put("Times-BoldItalic", PdfName.TIMES_BOLDITALIC);
        BuiltinFonts14.put("Times-Italic", PdfName.TIMES_ITALIC);
        BuiltinFonts14.put("ZapfDingbats", PdfName.ZAPFDINGBATS);
    }

    static class StreamFont
    extends PdfStream {
        public StreamFont(byte[] byArray, int[] nArray, int n) throws DocumentException {
            try {
                this.bytes = byArray;
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                for (int i = 0; i < nArray.length; ++i) {
                    this.put(new PdfName("Length" + (i + 1)), new PdfNumber(nArray[i]));
                }
                this.flateCompress(n);
            }
            catch (Exception exception) {
                throw new DocumentException(exception);
            }
        }

        public StreamFont(byte[] byArray, String string, int n) throws DocumentException {
            try {
                this.bytes = byArray;
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                if (string != null) {
                    this.put(PdfName.SUBTYPE, new PdfName(string));
                }
                this.flateCompress(n);
            }
            catch (Exception exception) {
                throw new DocumentException(exception);
            }
        }
    }
}

