/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.function.Supplier;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AbstractCartesianMatchEngine;
import uk.ac.starlink.table.join.Coverage;
import uk.ac.starlink.table.join.CuboidCoverage;
import uk.ac.starlink.table.join.MatchKit;

public class AnisotropicCartesianMatchEngine
extends AbstractCartesianMatchEngine {
    private final int ndim_;
    private final double[] err2rs_;
    private final DescribedValue[] matchParams_;
    private static final ValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Normalised distance between matched points (0 is identical, 1 is worst possible match)");

    public AnisotropicCartesianMatchEngine(double[] errs) {
        super(errs.length);
        this.ndim_ = errs.length;
        this.err2rs_ = new double[this.ndim_];
        this.matchParams_ = new DescribedValue[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            this.matchParams_[id] = new ErrorParameter(id);
            this.setScale(id, errs[id]);
        }
    }

    public void setError(int idim, double err) {
        this.setScale(idim, err);
    }

    public double getError(int idim) {
        return this.getScale(idim);
    }

    @Override
    protected void setScale(int idim, double err) {
        super.setScale(idim, err);
        this.err2rs_[idim] = 1.0 / (err * err);
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        ValueInfo[] infos = new ValueInfo[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            infos[id] = this.createCoordinateInfo(id);
        }
        return infos;
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public Supplier<MatchKit> createMatchKitFactory() {
        Supplier<AbstractCartesianMatchEngine.CartesianBinner> binnerFact = this.createBinnerFactory();
        double[] err2rs = (double[])this.err2rs_.clone();
        return () -> new AnisotropicMatchKit(err2rs, (AbstractCartesianMatchEngine.CartesianBinner)binnerFact.get());
    }

    @Override
    public double getScoreScale() {
        return 1.0;
    }

    @Override
    public Supplier<Coverage> createCoverageFactory() {
        double[] errs = new double[this.ndim_];
        for (int idim = 0; idim < this.ndim_; ++idim) {
            errs[idim] = this.getError(idim);
        }
        return () -> CuboidCoverage.createFixedCartesianCoverage(this.ndim_, errs);
    }

    @Override
    public String toString() {
        return this.ndim_ + "-d Cartesian Anisotropic";
    }

    private class ErrorParameter
    extends DescribedValue {
        private final int idim_;

        ErrorParameter(int idim) {
            super(new DefaultValueInfo("Error in " + AnisotropicCartesianMatchEngine.this.getCoordinateName(idim), Number.class, "Axis length of error ellipse in " + AnisotropicCartesianMatchEngine.this.getCoordinateDescription(idim) + " direction"));
            this.idim_ = idim;
        }

        @Override
        public Object getValue() {
            return AnisotropicCartesianMatchEngine.this.getError(this.idim_);
        }

        @Override
        public void setValue(Object value) {
            AnisotropicCartesianMatchEngine.this.setError(this.idim_, AbstractCartesianMatchEngine.getNumberValue(value));
        }
    }

    private static class AnisotropicMatchKit
    implements MatchKit {
        final double[] err2rs_;
        final AbstractCartesianMatchEngine.CartesianBinner binner_;
        final int ndim_;
        final double[] work0_;
        final double[] work1_;
        final double[] work2_;

        AnisotropicMatchKit(double[] err2rs, AbstractCartesianMatchEngine.CartesianBinner binner) {
            this.err2rs_ = err2rs;
            this.binner_ = binner;
            this.ndim_ = this.binner_.getNdim();
            this.work0_ = new double[this.ndim_];
            this.work1_ = new double[this.ndim_];
            this.work2_ = new double[this.ndim_];
        }

        @Override
        public double matchScore(Object[] tuple1, Object[] tuple2) {
            this.binner_.toCoords(tuple1, this.work1_);
            this.binner_.toCoords(tuple2, this.work2_);
            double normDist2 = 0.0;
            for (int id = 0; id < this.ndim_; ++id) {
                double d = this.work2_[id] - this.work1_[id];
                if ((normDist2 += d * d * this.err2rs_[id]) <= 1.0) continue;
                return -1.0;
            }
            assert (normDist2 >= 0.0 && normDist2 <= 1.0);
            return Math.sqrt(normDist2);
        }

        @Override
        public Object[] getBins(Object[] tuple) {
            this.binner_.toCoords(tuple, this.work0_);
            return this.binner_.getScaleBins(this.work0_);
        }
    }
}

