/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.ArrayList;
import java.util.function.Supplier;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AbstractCartesianMatchEngine;
import uk.ac.starlink.table.join.Coverage;
import uk.ac.starlink.table.join.CuboidCoverage;
import uk.ac.starlink.table.join.ErrorSummation;
import uk.ac.starlink.table.join.MatchKit;

public class ErrorCartesianMatchEngine
extends AbstractCartesianMatchEngine {
    private final int ndim_;
    private final ErrorSummation errorSummation_;
    private final DescribedValue[] matchParams_;
    private static final DefaultValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Scaled distance between matched points, 0..1");
    private static final DefaultValueInfo ERROR_INFO = new DefaultValueInfo("Error", Number.class, "Per-object error radius");
    private static final DefaultValueInfo ERRSCALE_INFO = new DefaultValueInfo("Scale", Number.class, "Rough average of per-object error distance; just used for tuning in conjunction with bin factor");

    public ErrorCartesianMatchEngine(int ndim, ErrorSummation errorSummation, double scale) {
        super(ndim);
        this.ndim_ = ndim;
        this.errorSummation_ = errorSummation == null ? ErrorSummation.SIMPLE : errorSummation;
        this.matchParams_ = new DescribedValue[]{new AbstractCartesianMatchEngine.IsotropicScaleParameter(ERRSCALE_INFO)};
        this.setIsotropicScale(scale);
    }

    public void setScale(double scale) {
        super.setIsotropicScale(scale);
    }

    public double getScale() {
        return super.getIsotropicScale();
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        ArrayList<ValueInfo> infoList = new ArrayList<ValueInfo>();
        for (int id = 0; id < this.ndim_; ++id) {
            infoList.add(this.createCoordinateInfo(id));
        }
        infoList.add(ERROR_INFO);
        return infoList.toArray(new ValueInfo[0]);
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public String toString() {
        return new StringBuffer().append(this.ndim_).append("-d Cartesian with Errors").append(this.errorSummation_.getTail()).toString();
    }

    @Override
    public Supplier<MatchKit> createMatchKitFactory() {
        Supplier<AbstractCartesianMatchEngine.CartesianBinner> binnerFact = this.createBinnerFactory();
        return () -> new ErrorCartesianMatchKit(this.errorSummation_, (AbstractCartesianMatchEngine.CartesianBinner)binnerFact.get());
    }

    @Override
    public Supplier<Coverage> createCoverageFactory() {
        CuboidCoverage.PointDecoder pointDecoder = CuboidCoverage.createCartesianPointDecoder(this.ndim_);
        CuboidCoverage.ErrorDecoder errDecoder = this::getTupleError;
        return () -> CuboidCoverage.createVariableErrorCoverage(this.ndim_, pointDecoder, errDecoder);
    }

    @Override
    public double getScoreScale() {
        return 1.0;
    }

    private double[] getTupleCoords(Object[] tuple) {
        double[] coords = new double[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            coords[id] = ErrorCartesianMatchEngine.getNumberValue(tuple[id]);
        }
        return coords;
    }

    private double getTupleError(Object[] tuple) {
        return ErrorCartesianMatchEngine.getNumberValue(tuple[this.ndim_]);
    }

    private static class ErrorCartesianMatchKit
    implements MatchKit {
        final ErrorSummation errorSummation_;
        final AbstractCartesianMatchEngine.CartesianBinner binner_;
        final int ndim_;
        final double[] work0_;
        final double[] work1_;
        final double[] work2_;

        ErrorCartesianMatchKit(ErrorSummation errorSummation, AbstractCartesianMatchEngine.CartesianBinner binner) {
            this.errorSummation_ = errorSummation;
            this.binner_ = binner;
            this.ndim_ = this.binner_.getNdim();
            this.work0_ = new double[this.ndim_];
            this.work1_ = new double[this.ndim_];
            this.work2_ = new double[this.ndim_];
        }

        @Override
        public double matchScore(Object[] tuple1, Object[] tuple2) {
            double score;
            this.binner_.toCoords(tuple1, this.work1_);
            this.binner_.toCoords(tuple2, this.work2_);
            double e1 = this.getTupleError(tuple1);
            double e2 = this.getTupleError(tuple2);
            double err2 = this.errorSummation_.combineSquared(e1, e2);
            double dist2 = 0.0;
            for (int id = 0; id < this.ndim_; ++id) {
                double d = this.work2_[id] - this.work1_[id];
                if ((dist2 += d * d) <= err2) continue;
                return -1.0;
            }
            double d = score = err2 > 0.0 ? Math.sqrt(dist2 / err2) : 0.0;
            assert (score >= 0.0 && score <= 1.0);
            return score;
        }

        @Override
        public Object[] getBins(Object[] tuple) {
            this.binner_.toCoords(tuple, this.work0_);
            return this.binner_.getRadiusBins(this.work0_, this.getTupleError(tuple));
        }

        private double getTupleError(Object[] tuple) {
            return AbstractCartesianMatchEngine.getNumberValue(tuple[this.ndim_]);
        }
    }
}

