/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.function.Supplier;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AbstractSkyMatchEngine;
import uk.ac.starlink.table.join.Coverage;
import uk.ac.starlink.table.join.ErrorSummation;
import uk.ac.starlink.table.join.MatchKit;
import uk.ac.starlink.table.join.SkyCoverage;
import uk.ac.starlink.table.join.SkyPixellator;
import uk.ac.starlink.table.join.VariableRadiusConePixer;

public class ErrorSkyMatchEngine
extends AbstractSkyMatchEngine {
    private final ErrorSummation errorSummation_;
    private final DescribedValue[] matchParams_;
    private static final DefaultValueInfo SCALE_INFO = new DefaultValueInfo("Scale", Number.class, "Rough average of per-object error distance; just used for tuning to set default pixel size");
    private static final DefaultValueInfo ERR_INFO = new DefaultValueInfo("Error", Number.class, "Per-object error radius along a great circle");
    private static final DefaultValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Scaled distance between matched objects along a great circle (0..1)");

    public ErrorSkyMatchEngine(SkyPixellator pixellator, ErrorSummation errorSummation, double scale) {
        super(pixellator, scale);
        this.errorSummation_ = errorSummation == null ? ErrorSummation.SIMPLE : errorSummation;
        this.matchParams_ = new DescribedValue[]{new AbstractSkyMatchEngine.SkyScaleParameter(SCALE_INFO)};
    }

    @Override
    public void setScale(double scale) {
        super.setScale(scale);
    }

    @Override
    public double getScale() {
        return super.getScale();
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        return new ValueInfo[]{Tables.RA_INFO, Tables.DEC_INFO, ERR_INFO};
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public Supplier<MatchKit> createMatchKitFactory() {
        Supplier<VariableRadiusConePixer> pixerFact = this.getPixellator().createVariableRadiusPixerFactory();
        CoordReader coordReader = this.getCoordReader();
        return () -> new ErrorMatchKit(this.errorSummation_, (VariableRadiusConePixer)pixerFact.get(), coordReader);
    }

    @Override
    public Supplier<Coverage> createCoverageFactory() {
        double scale = this.getScale();
        CoordReader coordReader = this.getCoordReader();
        SkyCoverage.TupleDecoder coneDecoder = (tuple, lonLatErr) -> {
            double err;
            double delta;
            double alpha = coordReader.getAlpha(tuple);
            if (ErrorSkyMatchEngine.isSkyPosition(alpha, delta = coordReader.getDelta(tuple)) && (err = coordReader.getError(tuple)) >= 0.0) {
                lonLatErr[0] = alpha;
                lonLatErr[1] = delta;
                lonLatErr[2] = err;
                return true;
            }
            return false;
        };
        return () -> SkyCoverage.createVariableErrorCoverage(scale, coneDecoder);
    }

    @Override
    public double getScoreScale() {
        return 1.0;
    }

    @Override
    public String toString() {
        return new StringBuffer("Sky with Errors").append(this.errorSummation_.getTail()).toString();
    }

    CoordReader getCoordReader() {
        return CoordReader.RADIANS;
    }

    static {
        SCALE_INFO.setUnitString("radians");
        SCALE_INFO.setUCD("pos.angDistance");
        SCALE_INFO.setNullable(false);
        ERR_INFO.setUnitString("radians");
        ERR_INFO.setUCD("pos.angDistance");
        ERR_INFO.setNullable(false);
    }

    public static class InDegrees
    extends ErrorSkyMatchEngine {
        private final ValueInfo[] tupleInfos_;
        private final DescribedValue[] matchParams_;

        public InDegrees(SkyPixellator pixellator, ErrorSummation errorSummation, double scaleRadians) {
            super(pixellator, errorSummation, scaleRadians);
            ValueInfo[] infos0 = super.getTupleInfos();
            this.tupleInfos_ = new ValueInfo[]{InDegrees.inDegreeInfo(infos0[0]), InDegrees.inDegreeInfo(infos0[1]), InDegrees.inArcsecInfo(infos0[2])};
            DescribedValue[] params0 = super.getMatchParameters();
            this.matchParams_ = new DescribedValue[]{InDegrees.radiansToArcsecParam(params0[0])};
            assert (this.tupleInfos_.length == infos0.length);
            assert (this.matchParams_.length == params0.length);
        }

        @Override
        public ValueInfo[] getTupleInfos() {
            return this.tupleInfos_;
        }

        @Override
        public DescribedValue[] getMatchParameters() {
            return this.matchParams_;
        }

        @Override
        CoordReader getCoordReader() {
            return CoordReader.DEGREES;
        }
    }

    private static interface CoordReader {
        public static final CoordReader RADIANS = new CoordReader(){

            @Override
            public double getAlpha(Object[] tuple) {
                return AbstractSkyMatchEngine.getNumberValue(tuple[0]);
            }

            @Override
            public double getDelta(Object[] tuple) {
                return AbstractSkyMatchEngine.getNumberValue(tuple[1]);
            }

            @Override
            public double getError(Object[] tuple) {
                return AbstractSkyMatchEngine.getNumberValue(tuple[2]);
            }
        };
        public static final CoordReader DEGREES = new CoordReader(){

            @Override
            public double getAlpha(Object[] tuple) {
                return RADIANS.getAlpha(tuple) * (Math.PI / 180);
            }

            @Override
            public double getDelta(Object[] tuple) {
                return RADIANS.getDelta(tuple) * (Math.PI / 180);
            }

            @Override
            public double getError(Object[] tuple) {
                return RADIANS.getError(tuple) * 4.84813681109536E-6;
            }
        };

        public double getAlpha(Object[] var1);

        public double getDelta(Object[] var1);

        public double getError(Object[] var1);
    }

    private static class ErrorMatchKit
    implements MatchKit {
        final ErrorSummation errorSummation_;
        final VariableRadiusConePixer conePixer_;
        final CoordReader coordReader_;

        ErrorMatchKit(ErrorSummation errorSummation, VariableRadiusConePixer conePixer, CoordReader coordReader) {
            this.errorSummation_ = errorSummation;
            this.conePixer_ = conePixer;
            this.coordReader_ = coordReader;
        }

        @Override
        public Object[] getBins(Object[] tuple) {
            double alpha = this.coordReader_.getAlpha(tuple);
            double delta = this.coordReader_.getDelta(tuple);
            double error = this.coordReader_.getError(tuple);
            return !Double.isNaN(alpha) && !Double.isNaN(delta) && error >= 0.0 ? this.conePixer_.getPixels(alpha, delta, error) : NO_BINS;
        }

        @Override
        public double matchScore(Object[] tuple1, Object[] tuple2) {
            double alpha2;
            double delta1 = this.coordReader_.getDelta(tuple1);
            double delta2 = this.coordReader_.getDelta(tuple2);
            double err1 = this.coordReader_.getError(tuple1);
            double err2 = this.coordReader_.getError(tuple2);
            double maxerr = this.errorSummation_.combine(err1, err2);
            if (Math.abs(delta1 - delta2) > maxerr) {
                return -1.0;
            }
            double alpha1 = this.coordReader_.getAlpha(tuple1);
            double sep = AbstractSkyMatchEngine.calculateSeparation(alpha1, delta1, alpha2 = this.coordReader_.getAlpha(tuple2), delta2);
            if (sep <= maxerr) {
                return maxerr > 0.0 ? sep / maxerr : 0.0;
            }
            return -1.0;
        }
    }
}

