/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.util.function.Supplier;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.AbstractSkyMatchEngine;
import uk.ac.starlink.table.join.Coverage;
import uk.ac.starlink.table.join.FixedRadiusConePixer;
import uk.ac.starlink.table.join.MatchKit;
import uk.ac.starlink.table.join.SkyCoverage;
import uk.ac.starlink.table.join.SkyPixellator;

public class FixedSkyMatchEngine
extends AbstractSkyMatchEngine {
    private final DescribedValue[] matchParams_ = new DescribedValue[]{new AbstractSkyMatchEngine.SkyScaleParameter(SEP_INFO)};
    private static final DefaultValueInfo SEP_INFO = new DefaultValueInfo("Max Error", Number.class, "Maximum separation along a great circle");
    private static final DefaultValueInfo SCORE_INFO = new DefaultValueInfo("Separation", Double.class, "Distance between matched objects along a great circle");

    public FixedSkyMatchEngine(SkyPixellator pixellator, double separation) {
        super(pixellator, separation);
    }

    public void setSeparation(double separation) {
        this.setScale(separation);
    }

    public double getSeparation() {
        return this.getScale();
    }

    @Override
    public ValueInfo[] getTupleInfos() {
        return new ValueInfo[]{Tables.RA_INFO, Tables.DEC_INFO};
    }

    @Override
    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    @Override
    public ValueInfo getMatchScoreInfo() {
        return SCORE_INFO;
    }

    @Override
    public Supplier<MatchKit> createMatchKitFactory() {
        double separation = this.getSeparation();
        Supplier<FixedRadiusConePixer> pixerFact = this.getPixellator().createFixedRadiusPixerFactory(0.5 * separation);
        CoordReader coordReader = this.getCoordReader();
        return () -> new FixedMatchKit(separation, (FixedRadiusConePixer)pixerFact.get(), coordReader);
    }

    @Override
    public Supplier<Coverage> createCoverageFactory() {
        double sep = this.getSeparation();
        CoordReader coordReader = this.getCoordReader();
        SkyCoverage.TupleDecoder posDecoder = (tuple, lonlat) -> {
            double delta;
            double alpha = coordReader.getAlpha(tuple);
            if (FixedSkyMatchEngine.isSkyPosition(alpha, delta = coordReader.getDelta(tuple))) {
                lonlat[0] = alpha;
                lonlat[1] = delta;
                return true;
            }
            return false;
        };
        return () -> SkyCoverage.createFixedErrorCoverage(sep, posDecoder);
    }

    @Override
    public double getScoreScale() {
        return FixedSkyMatchEngine.maxScore(this.getSeparation());
    }

    @Override
    public String toString() {
        return "Sky";
    }

    CoordReader getCoordReader() {
        return CoordReader.RADIANS;
    }

    static {
        SEP_INFO.setUnitString("radians");
        SEP_INFO.setUCD("pos.angDistance");
        SCORE_INFO.setUnitString("arcsec");
        SCORE_INFO.setUCD("pos.angDistance");
    }

    public static class InDegrees
    extends FixedSkyMatchEngine {
        private final ValueInfo[] tupleInfos_;
        private final DescribedValue[] matchParams_;

        public InDegrees(SkyPixellator pixellator, double sepRadians) {
            super(pixellator, sepRadians);
            ValueInfo[] infos0 = super.getTupleInfos();
            this.tupleInfos_ = new ValueInfo[]{InDegrees.inDegreeInfo(infos0[0]), InDegrees.inDegreeInfo(infos0[1])};
            DescribedValue[] params0 = super.getMatchParameters();
            this.matchParams_ = new DescribedValue[]{InDegrees.radiansToArcsecParam(params0[0])};
            assert (this.tupleInfos_.length == infos0.length);
            assert (this.matchParams_.length == params0.length);
        }

        @Override
        public ValueInfo[] getTupleInfos() {
            return this.tupleInfos_;
        }

        @Override
        public DescribedValue[] getMatchParameters() {
            return this.matchParams_;
        }

        @Override
        CoordReader getCoordReader() {
            return CoordReader.DEGREES;
        }
    }

    private static interface CoordReader {
        public static final CoordReader RADIANS = new CoordReader(){

            @Override
            public double getAlpha(Object[] tuple) {
                return AbstractSkyMatchEngine.getNumberValue(tuple[0]);
            }

            @Override
            public double getDelta(Object[] tuple) {
                return AbstractSkyMatchEngine.getNumberValue(tuple[1]);
            }
        };
        public static final CoordReader DEGREES = new CoordReader(){

            @Override
            public double getAlpha(Object[] tuple) {
                return RADIANS.getAlpha(tuple) * (Math.PI / 180);
            }

            @Override
            public double getDelta(Object[] tuple) {
                return RADIANS.getDelta(tuple) * (Math.PI / 180);
            }
        };

        public double getAlpha(Object[] var1);

        public double getDelta(Object[] var1);
    }

    private static class FixedMatchKit
    implements MatchKit {
        final double separation_;
        final FixedRadiusConePixer conePixer_;
        final CoordReader coordReader_;

        FixedMatchKit(double separation, FixedRadiusConePixer conePixer, CoordReader coordReader) {
            this.separation_ = separation;
            this.conePixer_ = conePixer;
            this.coordReader_ = coordReader;
        }

        @Override
        public Object[] getBins(Object[] tuple) {
            double alpha = this.coordReader_.getAlpha(tuple);
            double delta = this.coordReader_.getDelta(tuple);
            return !Double.isNaN(alpha) && !Double.isNaN(delta) ? this.conePixer_.getPixels(alpha, delta) : NO_BINS;
        }

        @Override
        public double matchScore(Object[] tuple1, Object[] tuple2) {
            return AbstractSkyMatchEngine.matchScore(this.coordReader_.getAlpha(tuple1), this.coordReader_.getDelta(tuple1), this.coordReader_.getAlpha(tuple2), this.coordReader_.getDelta(tuple2), this.separation_);
        }
    }
}

