/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.join.Binners;
import uk.ac.starlink.table.join.Coverage;
import uk.ac.starlink.table.join.HashSetLinkSet;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.LongBinner;
import uk.ac.starlink.table.join.MatchComputer;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.MatchKit;
import uk.ac.starlink.table.join.MultiJoinType;
import uk.ac.starlink.table.join.NullProgressIndicator;
import uk.ac.starlink.table.join.ObjectBinner;
import uk.ac.starlink.table.join.PairMode;
import uk.ac.starlink.table.join.PairsRowLink;
import uk.ac.starlink.table.join.ParallelMatchComputer;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.ProgressTracker;
import uk.ac.starlink.table.join.RowLink;
import uk.ac.starlink.table.join.RowLink1;
import uk.ac.starlink.table.join.RowLink2;
import uk.ac.starlink.table.join.RowLinkN;
import uk.ac.starlink.table.join.RowRef;
import uk.ac.starlink.table.join.SequentialMatchComputer;

public class RowMatcher {
    private final MatchEngine engine_;
    private final StarTable[] tables_;
    private final MatchComputer computer_;
    private final int nTable_;
    private ProgressIndicator indicator_;
    private long startTime_;
    public static final int DFLT_PARALLELISM_LIMIT = 6;
    public static final int DFLT_PARALLELISM = Math.min(6, Runtime.getRuntime().availableProcessors());

    private RowMatcher(MatchEngine engine, StarTable[] tables, MatchComputer computer) {
        this.engine_ = engine;
        this.tables_ = tables;
        this.computer_ = computer;
        this.nTable_ = tables.length;
        this.indicator_ = new NullProgressIndicator();
    }

    public void setIndicator(ProgressIndicator indicator) {
        this.indicator_ = indicator;
    }

    public ProgressIndicator getIndicator() {
        return this.indicator_;
    }

    public LinkSet createLinkSet() {
        return new HashSetLinkSet();
    }

    public LinkSet findPairMatches(PairMode pairMode) throws IOException, InterruptedException {
        if (this.nTable_ != 2) {
            throw new IllegalStateException("findPairMatches only makes sense for 2 tables");
        }
        this.startMatch();
        LinkSet pairs = pairMode.findPairMatches(this);
        this.endMatch();
        return pairs;
    }

    LinkSet findAllPairs(int index1, int index2) throws IOException, InterruptedException {
        Coverage coverage;
        int indexR;
        int indexS;
        if (!this.tables_[index1].isRandom() && !this.tables_[index2].isRandom()) {
            throw new IllegalArgumentException("Neither table random-access");
        }
        if (!this.tables_[index1].isRandom()) {
            assert (this.tables_[index2].isRandom());
            indexS = index1;
            indexR = index2;
            coverage = Coverage.FULL;
        } else if (!this.tables_[index2].isRandom()) {
            assert (this.tables_[index1].isRandom());
            indexS = index2;
            indexR = index1;
            coverage = Coverage.FULL;
        } else {
            Intersection intersect = this.getIntersection(new int[]{index1, index2});
            coverage = intersect.coverage_;
            if (coverage.isEmpty()) {
                return this.createLinkSet();
            }
            long inRangeCount1 = intersect.inRangeCounts_[0];
            long inRangeCount2 = intersect.inRangeCounts_[1];
            if (inRangeCount1 < inRangeCount2) {
                indexR = index1;
                indexS = index2;
            } else {
                indexR = index2;
                indexS = index1;
            }
        }
        return this.scanForPairs(indexR, indexS, coverage.createTestFactory(), false);
    }

    LinkSet scanForPairs(int indexR, int indexS, Supplier<Predicate<Object[]>> rowSelector, boolean bestOnly) throws IOException, InterruptedException {
        MatchComputer.BinnedRows binned = this.computer_.binRowIndices(this.engine_.createMatchKitFactory(), rowSelector, this.tables_[indexR], this.indicator_, "Binning rows for table " + (indexR + 1));
        LongBinner binnerR = binned.getLongBinner();
        long nbin = binnerR.getBinCount();
        long nexclude = binned.getNexclude();
        long nref = binned.getNref();
        long nrow = this.tables_[indexR].getRowCount();
        if (nexclude > 0L) {
            this.indicator_.logMessage(nexclude + "/" + nrow + " rows excluded (out of match region)");
        }
        this.indicator_.logMessage(nref + " row refs for " + nrow + " rows in " + nbin + " bins");
        this.indicator_.logMessage("(average bin occupancy " + (float)nref / (float)nbin + ")");
        return this.computer_.scanBinsForPairs(this.engine_.createMatchKitFactory(), rowSelector, this.tables_[indexR], indexR, this.tables_[indexS], indexS, bestOnly, binnerR, this::createLinkSet, this.indicator_, "Scanning rows for table " + (indexS + 1));
    }

    public LinkSet findMultiPairMatches(int index0, boolean bestOnly, MultiJoinType[] joinTypes) throws IOException, InterruptedException {
        int i;
        this.checkRandom();
        if (joinTypes.length != this.nTable_) {
            throw new IllegalArgumentException("Options length " + joinTypes.length + " differs from table count " + this.nTable_);
        }
        this.startMatch();
        LinkSet possibleLinks = this.getPossibleMultiPairLinks(index0);
        LinkSet multiLinks = this.findMultiPairMatches(possibleLinks, index0, bestOnly);
        LinkSet[] missing = new LinkSet[this.nTable_];
        for (i = 0; i < this.nTable_; ++i) {
            if (joinTypes[i] != MultiJoinType.ALWAYS) continue;
            missing[i] = this.missingSingles(multiLinks, i);
        }
        for (i = 0; i < this.nTable_; ++i) {
            if (missing[i] == null) continue;
            for (RowLink link : missing[i]) {
                multiLinks.addLink(link);
            }
            missing[i] = null;
        }
        Iterator<RowLink> it = multiLinks.iterator();
        while (it.hasNext()) {
            RowLink link = it.next();
            if (this.acceptRow(link, joinTypes)) continue;
            it.remove();
        }
        this.endMatch();
        return multiLinks;
    }

    public LinkSet findGroupMatches(MultiJoinType[] joinTypes) throws IOException, InterruptedException {
        int i;
        this.checkRandom();
        if (this.nTable_ < 2) {
            throw new IllegalStateException("Find matches only makes sense for multiple tables");
        }
        if (joinTypes.length != this.nTable_) {
            throw new IllegalArgumentException("Options length " + joinTypes.length + " differs from table count " + this.nTable_);
        }
        this.startMatch();
        LinkSet pairs = this.findPairs(this.getAllPossibleLinks());
        this.eliminateInternalLinks(pairs);
        LinkSet links = this.agglomerateLinks(pairs);
        pairs = null;
        this.eliminateInternalLinks(links);
        LinkSet[] missing = new LinkSet[this.nTable_];
        for (i = 0; i < this.nTable_; ++i) {
            if (joinTypes[i] != MultiJoinType.ALWAYS) continue;
            missing[i] = this.missingSingles(links, i);
        }
        for (i = 0; i < this.nTable_; ++i) {
            if (missing[i] == null) continue;
            for (RowLink link : missing[i]) {
                links.addLink(link);
            }
            missing[i] = null;
        }
        Iterator<RowLink> it = links.iterator();
        while (it.hasNext()) {
            RowLink link = it.next();
            if (this.acceptRow(link, joinTypes)) continue;
            it.remove();
        }
        this.endMatch();
        return links;
    }

    public LinkSet findInternalMatches(boolean includeSingles) throws IOException, InterruptedException {
        this.checkRandom();
        if (this.nTable_ != 1) {
            throw new IllegalStateException("Internal matches only make sense with a single table");
        }
        this.startMatch();
        LinkSet links = this.findPairs(this.getAllPossibleInternalLinks(0));
        links = this.agglomerateLinks(links);
        if (includeSingles) {
            Iterator<RowLink> it = this.missingSingles(links, 0).iterator();
            while (it.hasNext()) {
                links.addLink(it.next());
                it.remove();
            }
        }
        this.endMatch();
        return links;
    }

    private LinkSet findPairs(LinkSet possibleLinks) throws IOException, InterruptedException {
        LinkSet pairs = this.createLinkSet();
        MatchKit matchKit = this.engine_.createMatchKitFactory().get();
        ProgressTracker tracker = new ProgressTracker(this.indicator_, possibleLinks.size(), "Locating pairs");
        Iterator<RowLink> it = possibleLinks.iterator();
        while (it.hasNext()) {
            RowLink link = it.next();
            it.remove();
            int nref = link.size();
            if (nref > 1) {
                int i;
                Object[][] binnedRows = new Object[nref][];
                for (i = 0; i < nref; ++i) {
                    RowRef ref = link.getRef(i);
                    StarTable table = this.tables_[ref.getTableIndex()];
                    binnedRows[i] = table.getRow(ref.getRowIndex());
                }
                for (i = 0; i < nref; ++i) {
                    for (int j = 0; j < i; ++j) {
                        double score;
                        RowLink2 pair = new RowLink2(link.getRef(i), link.getRef(j));
                        if (pairs.containsLink(pair) || !((score = matchKit.matchScore(binnedRows[i], binnedRows[j])) >= 0.0)) continue;
                        pair.setScore(score);
                        pairs.addLink(pair);
                    }
                }
            }
            tracker.nextProgress();
        }
        tracker.close();
        return pairs;
    }

    private LinkSet getAllPossibleLinks() throws IOException, InterruptedException {
        ObjectBinner<Object, RowRef> binner = Binners.createObjectBinner();
        long totalRows = 0L;
        for (int itab = 0; itab < this.nTable_; ++itab) {
            this.binRowRefs(itab, Coverage.FULL, binner, true);
            totalRows += this.tables_[itab].getRowCount();
        }
        long nBin = binner.getBinCount();
        this.indicator_.logMessage("Average bin count per row: " + (float)((double)nBin / (double)totalRows));
        LinkSet links = this.createLinkSet();
        this.binsToLinks(binner, links);
        return links;
    }

    private LinkSet getAllPossibleInternalLinks(int itable) throws IOException, InterruptedException {
        StarTable table = this.tables_[itable];
        MatchComputer.BinnedRows binned = this.computer_.binRowIndices(this.engine_.createMatchKitFactory(), Coverage.FULL.createTestFactory(), table, this.indicator_, "Binning rows for table " + (itable + 1));
        LongBinner binner = binned.getLongBinner();
        long nRow = table.getRowCount();
        long nBin = binner.getBinCount();
        this.indicator_.logMessage("Average bin count per row: " + (float)((double)nBin / (double)nRow));
        LinkSet links = this.createLinkSet();
        this.binsToInternalLinks(binner, links, itable);
        return links;
    }

    private Intersection getIntersection(int[] iTables) throws IOException, InterruptedException {
        int nt = iTables.length;
        Supplier<Coverage> covFact = this.engine_.createCoverageFactory();
        if (covFact != null && nt > 1) {
            this.indicator_.logMessage("Attempt to locate restricted common region");
            Coverage[] covs = new Coverage[nt];
            for (int iTable = 0; iTable < nt; ++iTable) {
                int index = iTables[iTable];
                covs[iTable] = this.readCoverage(covFact, index);
            }
            Coverage coverage = covs[0];
            for (int iTable = 1; iTable < nt; ++iTable) {
                coverage.intersection(covs[iTable]);
            }
            if (!coverage.isEmpty()) {
                this.indicator_.logMessage("Potential match region: " + coverage.coverageText());
                long[] inRangeCounts = new long[nt];
                for (int iTable = 0; iTable < nt; ++iTable) {
                    long nr;
                    int index = iTables[iTable];
                    String msg = "Counting rows in match region for table " + (index + 1);
                    inRangeCounts[iTable] = nr = this.computer_.countRows(this.tables_[index], coverage.createTestFactory(), this.indicator_, msg);
                    this.indicator_.logMessage(nr + " rows in match region");
                }
                return new Intersection(coverage, inRangeCounts);
            }
            this.indicator_.logMessage("No region overlap - matches not possible");
            return new Intersection(coverage, new long[nt]);
        }
        long[] nrows = new long[nt];
        for (int iTable = 0; iTable < nt; ++iTable) {
            int index = iTables[iTable];
            nrows[iTable] = this.tables_[index].getRowCount();
        }
        return new Intersection(Coverage.FULL, nrows);
    }

    private void eliminateInternalLinks(LinkSet links) throws InterruptedException {
        Object[] refs = new RowRef[this.nTable_];
        LinkSet replacements = this.createLinkSet();
        ProgressTracker tracker = new ProgressTracker(this.indicator_, links.size(), "Eliminating internal links");
        int nReplace = 0;
        int nRemove = 0;
        Iterator<RowLink> it = links.iterator();
        while (it.hasNext()) {
            RowLink link = it.next();
            int nref = link.size();
            if (link.size() > 1) {
                Arrays.fill(refs, null);
                boolean dup = false;
                for (int i = 0; i < nref; ++i) {
                    RowRef ref = link.getRef(i);
                    int iTable = ref.getTableIndex();
                    if (refs[iTable] == null) {
                        refs[iTable] = ref;
                        continue;
                    }
                    dup = true;
                }
                if (dup) {
                    it.remove();
                    ArrayList<RowRef> repRefs = new ArrayList<RowRef>();
                    for (int i = 0; i < this.nTable_; ++i) {
                        if (refs[i] == null) continue;
                        repRefs.add((RowRef)refs[i]);
                    }
                    if (repRefs.size() > 1) {
                        replacements.addLink(RowLink.createLink(repRefs));
                        ++nReplace;
                    } else {
                        ++nRemove;
                    }
                }
            }
            tracker.nextProgress();
        }
        tracker.close();
        if (nReplace > 0) {
            this.indicator_.logMessage("Internal links replaced: " + nReplace);
        }
        if (nRemove > 0) {
            this.indicator_.logMessage("Internal links removed: " + nRemove);
        }
        it = replacements.iterator();
        while (it.hasNext()) {
            RowLink repLink = it.next();
            links.addLink(repLink);
            it.remove();
        }
    }

    private LinkSet missingSingles(LinkSet links, int iTable) {
        BitSet present = new BitSet();
        for (RowLink link : links) {
            int nref = link.size();
            for (int i = 0; i < nref; ++i) {
                RowRef ref = link.getRef(i);
                if (ref.getTableIndex() != iTable) continue;
                present.set(RowMatcher.checkedLongToInt(ref.getRowIndex()));
            }
        }
        int nrow = RowMatcher.checkedLongToInt(this.tables_[iTable].getRowCount());
        LinkSet singles = this.createLinkSet();
        for (int iRow = 0; iRow < nrow; ++iRow) {
            if (present.get(iRow)) continue;
            singles.addLink(new RowLink1(new RowRef(iTable, iRow)));
        }
        return singles;
    }

    private LinkSet getPossibleMultiPairLinks(int index0) throws IOException, InterruptedException {
        Coverage coverage;
        Supplier<Coverage> coverageFact = this.engine_.createCoverageFactory();
        if (coverageFact != null) {
            this.indicator_.logMessage("Attempt to locate restricted common region");
            Coverage cov0 = null;
            LinkedList<Coverage> covOthers = new LinkedList<Coverage>();
            for (int i = 0; i < this.nTable_; ++i) {
                Coverage cov = this.readCoverage(coverageFact, i);
                if (i == index0) {
                    cov0 = cov;
                    continue;
                }
                covOthers.add(cov);
            }
            assert (cov0 != null);
            assert (!covOthers.isEmpty());
            Coverage unionOthers = (Coverage)covOthers.remove(0);
            while (!covOthers.isEmpty()) {
                unionOthers.union((Coverage)covOthers.remove(0));
            }
            cov0.intersection(unionOthers);
            coverage = cov0;
            this.indicator_.logMessage("Potential match region: " + coverage.coverageText());
        } else {
            coverage = Coverage.FULL;
        }
        ObjectBinner<Object, RowRef> binner = Binners.createObjectBinner();
        this.binRowRefs(index0, coverage, binner, true);
        for (int itab = 0; itab < this.nTable_; ++itab) {
            if (itab == index0) continue;
            this.binRowRefs(itab, coverage, binner, false);
        }
        LinkSet linkSet = this.createLinkSet();
        this.binsToLinks(binner, linkSet);
        return linkSet;
    }

    private LinkSet findMultiPairMatches(LinkSet possibleLinks, int index0, boolean bestOnly) throws IOException, InterruptedException {
        LinkSet pairs = this.createLinkSet();
        ProgressTracker tracker = new ProgressTracker(this.indicator_, possibleLinks.size(), "Locating pair matches between " + index0 + " and other tables");
        MatchKit matchKit = this.engine_.createMatchKitFactory().get();
        Iterator<RowLink> it = possibleLinks.iterator();
        while (it.hasNext()) {
            RowLink link = it.next();
            it.remove();
            int nref = link.size();
            boolean hasOthers = false;
            for (int iref = 0; iref < nref && !hasOthers; ++iref) {
                if (link.getRef(iref).getTableIndex() == index0) continue;
                hasOthers = true;
            }
            if (hasOthers) {
                Object[][] binnedRows = new Object[nref][];
                for (int iref = 0; iref < nref; ++iref) {
                    RowRef ref = link.getRef(iref);
                    StarTable table = this.tables_[ref.getTableIndex()];
                    binnedRows[iref] = table.getRow(ref.getRowIndex());
                }
                for (int i0 = 0; i0 < nref; ++i0) {
                    RowRef ref0 = link.getRef(i0);
                    int iTable0 = ref0.getTableIndex();
                    if (iTable0 != index0) continue;
                    long irow0 = ref0.getRowIndex();
                    for (int i1 = 0; i1 < nref; ++i1) {
                        double score;
                        RowLink2 pair;
                        RowRef ref1 = link.getRef(i1);
                        int iTable1 = ref1.getTableIndex();
                        if (iTable1 == index0 || pairs.containsLink(pair = new RowLink2(ref0, ref1)) || !((score = matchKit.matchScore(binnedRows[i0], binnedRows[i1])) >= 0.0)) continue;
                        pair.setScore(score);
                        pairs.addLink(pair);
                    }
                }
            }
            tracker.nextProgress();
        }
        tracker.close();
        ObjectBinner<RowRef, ScoredRef> pairBinner = Binners.createObjectBinner();
        Iterator<RowLink> it2 = pairs.iterator();
        while (it2.hasNext()) {
            RowRef ref1;
            RowRef ref0;
            RowLink2 pair = (RowLink2)it2.next();
            it2.remove();
            RowRef refA = pair.getRef(0);
            RowRef refB = pair.getRef(1);
            if (refA.getTableIndex() == index0) {
                assert (refB.getTableIndex() != index0);
                ref0 = refA;
                ref1 = refB;
            } else if (refB.getTableIndex() == index0) {
                assert (refA.getTableIndex() != index0);
                ref0 = refB;
                ref1 = refA;
            } else {
                throw new IllegalArgumentException("Pair doesn't contain reference table");
            }
            RowRef key = ref0;
            ScoredRef value = new ScoredRef(ref1, pair.getScore());
            pairBinner.addItem(key, value);
        }
        LinkSet multiLinks = this.createLinkSet();
        Iterator it3 = pairBinner.getKeyIterator();
        while (it3.hasNext()) {
            RowRef ref0 = (RowRef)it3.next();
            List sref1s = pairBinner.getList(ref0);
            int nref1 = sref1s.size();
            if (nref1 <= 0) continue;
            RowRef[] ref1s = new RowRef[nref1];
            double[] scores = new double[nref1];
            int ir1 = 0;
            for (ScoredRef sref1 : sref1s) {
                ref1s[ir1] = sref1.ref_;
                scores[ir1] = sref1.score_;
                ++ir1;
            }
            multiLinks.addLink(new PairsRowLink(ref0, ref1s, scores, bestOnly));
        }
        return multiLinks;
    }

    private boolean acceptRow(RowLink link, MultiJoinType[] joinTypes) {
        boolean[] present = new boolean[this.nTable_];
        int nref = link.size();
        for (int i = 0; i < nref; ++i) {
            RowRef ref = link.getRef(i);
            int iTable = ref.getTableIndex();
            present[iTable] = true;
        }
        return MultiJoinType.accept(joinTypes, present);
    }

    LinkSet eliminateMultipleRowEntries(LinkSet pairs) throws InterruptedException {
        Collection<RowLink> inPairs = this.toSortedList(pairs, new Comparator<RowLink>(){

            @Override
            public int compare(RowLink o1, RowLink o2) {
                double score2;
                RowLink2 r1 = (RowLink2)o1;
                RowLink2 r2 = (RowLink2)o2;
                double score1 = r1.getScore();
                if (score1 < (score2 = r2.getScore())) {
                    return -1;
                }
                if (score1 > score2) {
                    return 1;
                }
                return r1.compareTo(r2);
            }
        });
        pairs = null;
        LinkSet outPairs = this.createLinkSet();
        HashSet<RowRef> seenRows = new HashSet<RowRef>();
        ProgressTracker tracker = new ProgressTracker(this.indicator_, inPairs.size(), "Eliminating multiple row references");
        for (RowLink2 rowLink2 : inPairs) {
            boolean seen2;
            double score = rowLink2.getScore();
            if (rowLink2.size() != 2 || Double.isNaN(score) || score < 0.0) {
                throw new IllegalArgumentException();
            }
            RowRef ref1 = rowLink2.getRef(0);
            RowRef ref2 = rowLink2.getRef(1);
            if (ref1.getTableIndex() != 0 || ref2.getTableIndex() != 1) {
                throw new IllegalArgumentException();
            }
            boolean seen1 = !seenRows.add(ref1);
            boolean bl = seen2 = !seenRows.add(ref2);
            if (!seen1 && !seen2) {
                outPairs.addLink(rowLink2);
            }
            tracker.nextProgress();
        }
        tracker.close();
        return outPairs;
    }

    private LinkSet agglomerateLinks(LinkSet links) throws InterruptedException {
        ObjectBinner<RowRef, RowLink> refBinner = Binners.createModifiableObjectBinner();
        ProgressTracker mapTracker = new ProgressTracker(this.indicator_, links.size(), "Mapping rows to links");
        for (RowLink link : links) {
            int nref = link.size();
            for (int i = 0; i < nref; ++i) {
                RowRef ref = link.getRef(i);
                refBinner.addItem(ref, link);
            }
            mapTracker.nextProgress();
        }
        mapTracker.close();
        LinkSet agglomeratedLinks = this.createLinkSet();
        ProgressTracker isoTracker = new ProgressTracker(this.indicator_, links.size(), "Identifying isolated links");
        for (RowLink link : links) {
            RowRef ref;
            int i;
            int nref = link.size();
            boolean isolated = true;
            for (i = 0; isolated && i < nref; ++i) {
                ref = link.getRef(i);
                List refLinks = refBinner.getList(ref);
                assert (refLinks.size() > 0);
                isolated = isolated && refLinks.size() == 1;
            }
            if (isolated) {
                assert (!agglomeratedLinks.containsLink(link));
                agglomeratedLinks.addLink(link);
                for (i = 0; i < nref; ++i) {
                    ref = link.getRef(i);
                    refBinner.remove(ref);
                }
            }
            isoTracker.nextProgress();
        }
        isoTracker.close();
        double nRefs = refBinner.getBinCount();
        this.indicator_.startStage("Walking links");
        HashSet<RowRef> refSet = new HashSet<RowRef>();
        while (refBinner.getBinCount() > 0L) {
            this.indicator_.setLevel(1.0 - (double)refBinner.getBinCount() / nRefs);
            RowRef ref1 = (RowRef)refBinner.getKeyIterator().next();
            refSet.clear();
            RowMatcher.walkLinks(ref1, refBinner, refSet);
            RowLink link = RowLink.createLink(refSet);
            assert (!agglomeratedLinks.containsLink(link));
            agglomeratedLinks.addLink(link);
        }
        this.indicator_.endStage();
        return agglomeratedLinks;
    }

    public static RowMatcher createMatcher(MatchEngine engine, StarTable[] tables, RowRunner runner) {
        return new RowMatcher(engine, tables, runner == null ? new SequentialMatchComputer() : new ParallelMatchComputer(runner));
    }

    private static void walkLinks(RowRef baseRef, ObjectBinner<RowRef, RowLink> refBinner, Set<RowRef> outSet) {
        if (!outSet.contains(baseRef)) {
            List<RowLink> links = refBinner.getList(baseRef);
            if (!links.isEmpty()) {
                outSet.add(baseRef);
                Iterator<RowLink> linkIt = links.iterator();
                while (linkIt.hasNext()) {
                    RowLink link = linkIt.next();
                    for (int i = 0; i < link.size(); ++i) {
                        RowRef rref = link.getRef(i);
                        RowMatcher.walkLinks(rref, refBinner, outSet);
                    }
                    linkIt.remove();
                }
            }
            if (links.isEmpty()) {
                refBinner.remove(baseRef);
            }
        }
    }

    private void checkRandom() {
        for (StarTable table : this.tables_) {
            if (table.isRandom()) continue;
            throw new IllegalArgumentException("Table " + table + " is not random access");
        }
    }

    private Coverage readCoverage(Supplier<Coverage> coverageFact, int tIndex) throws IOException, InterruptedException {
        StarTable table = this.tables_[tIndex];
        Coverage cov = this.computer_.readCoverage(coverageFact, table, this.indicator_, "Assessing range of coordinates from table " + (tIndex + 1));
        this.indicator_.logMessage("Coverage is: " + cov.coverageText());
        return cov;
    }

    private void binRowRefs(int itab, Coverage coverage, ObjectBinner<Object, RowRef> binner, boolean newBins) throws IOException, InterruptedException {
        if (coverage.isEmpty()) {
            return;
        }
        StarTable table = this.tables_[itab];
        long ninclude = this.computer_.binRowRefs(this.engine_.createMatchKitFactory(), coverage.createTestFactory(), table, itab, binner, newBins, this.indicator_, "Binning rows for table " + (itab + 1));
        long nrow = table.getRowCount();
        long nexclude = nrow - ninclude;
        if (nexclude > 0L) {
            this.indicator_.logMessage(nexclude + "/" + nrow + " rows excluded (out of match region)");
        }
    }

    private void binsToLinks(ObjectBinner<Object, RowRef> binner, LinkSet linkSet) throws InterruptedException {
        long nrow = binner.getItemCount();
        long nbin = binner.getBinCount();
        this.indicator_.logMessage(nrow + " row refs in " + nbin + " bins");
        this.indicator_.logMessage("(average bin occupancy " + (float)nrow / (float)nbin + ")");
        ProgressTracker tracker = new ProgressTracker(this.indicator_, nbin, "Consolidating potential match groups");
        Iterator<Object> it = binner.getKeyIterator();
        while (it.hasNext()) {
            Object key = it.next();
            List<RowRef> refList = binner.getList(key);
            if (refList.size() > 1) {
                linkSet.addLink(RowLink.createLink(refList));
            }
            it.remove();
            tracker.nextProgress();
        }
        assert (binner.getBinCount() == 0L);
        tracker.close();
    }

    private void binsToInternalLinks(LongBinner binner, LinkSet linkSet, int itable) throws InterruptedException {
        long nbin = binner.getBinCount();
        ProgressTracker tracker = new ProgressTracker(this.indicator_, nbin, "Consolidating potential match groups");
        Iterator<?> it = binner.getKeyIterator();
        while (it.hasNext()) {
            Object key = it.next();
            long[] irs = binner.getLongs(key);
            int nir = irs.length;
            if (nir > 1) {
                RowLink link;
                if (nir == 2) {
                    link = new RowLink2(new RowRef(itable, irs[0]), new RowRef(itable, irs[1]));
                } else {
                    RowRef[] refs = new RowRef[nir];
                    for (int iir = 0; iir < nir; ++iir) {
                        refs[iir] = new RowRef(itable, irs[iir]);
                    }
                    link = RowLinkN.fromModifiableArray(refs);
                }
                linkSet.addLink(link);
            }
            it.remove();
            tracker.nextProgress();
        }
        assert (binner.getBinCount() == 0L);
        tracker.close();
    }

    private Collection<RowLink> toSortedList(LinkSet linkSet, Comparator<RowLink> comparator) {
        int nLink = linkSet.size();
        RowLink[] links = new RowLink[nLink];
        int il = 0;
        for (RowLink link : linkSet) {
            links[il++] = link;
        }
        Arrays.parallelSort(links, comparator);
        return Arrays.asList(links);
    }

    private void startMatch() {
        this.startTime_ = new Date().getTime();
        this.indicator_.logMessage("Params:" + RowMatcher.formatParams(this.engine_.getMatchParameters()));
        this.indicator_.logMessage("Tuning:" + RowMatcher.formatParams(this.engine_.getTuningParameters()));
        this.indicator_.logMessage("Processing: " + this.computer_.getDescription());
    }

    private static String formatParams(DescribedValue[] params) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            sbuf.append(i == 0 ? " " : ", ").append(params[i]);
        }
        return sbuf.toString();
    }

    private void endMatch() {
        long millis = new Date().getTime() - this.startTime_;
        this.indicator_.logMessage("Elapsed time for match: " + millis / 1000L + " seconds");
    }

    private static int checkedLongToInt(long lval) {
        return Tables.checkedLongToInt(lval);
    }

    private static class Intersection {
        final Coverage coverage_;
        final long[] inRangeCounts_;

        public Intersection(Coverage coverage, long[] inRangeCounts) {
            this.coverage_ = coverage;
            this.inRangeCounts_ = inRangeCounts;
        }
    }

    private static class ScoredRef {
        final RowRef ref_;
        final double score_;

        public ScoredRef(RowRef ref, double score) {
            this.ref_ = ref;
            this.score_ = score;
        }
    }
}

