/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.formats.DocumentedStreamStarTableWriter;
import uk.ac.starlink.util.ConfigMethod;

public class CsvTableWriter
extends DocumentedStreamStarTableWriter {
    private boolean writeHeader_ = true;
    private char delimiter_;
    private int maxFieldChars_ = Integer.MAX_VALUE;
    static final String SET_DELIMITER_DOC = "<p>Field delimiter character, by default a comma. Permitted values are a single character like \"<code>|</code>\", a hexadecimal character code like \"<code>0x7C</code>\", or one of the names \"<code>comma</code>\", \"<code>space</code>\" or \"<code>tab</code>\". Some choices of delimiter, for instance whitespace characters, might not work well or might behave in surprising ways.</p>";

    public CsvTableWriter() {
        this(true);
    }

    public CsvTableWriter(boolean writeHeader) {
        super(new String[]{"csv"});
        this.setDelimiter(',');
        this.setWriteHeader(writeHeader);
    }

    @ConfigMethod(property="header", doc="<p>If true, the first line of the CSV output will be a header containing the column names; if false, no header line is written and all lines represent data rows.</p>", sequence=1)
    public void setWriteHeader(boolean writeHeader) {
        this.writeHeader_ = writeHeader;
    }

    public boolean getWriteHeader() {
        return this.writeHeader_;
    }

    @ConfigMethod(property="delimiter", doc="<p>Field delimiter character, by default a comma. Permitted values are a single character like \"<code>|</code>\", a hexadecimal character code like \"<code>0x7C</code>\", or one of the names \"<code>comma</code>\", \"<code>space</code>\" or \"<code>tab</code>\". Some choices of delimiter, for instance whitespace characters, might not work well or might behave in surprising ways.</p>", example="|", sequence=2)
    public void setDelimiter(char delimiter) {
        this.delimiter_ = delimiter;
    }

    public char getDelimiter() {
        return this.delimiter_;
    }

    @ConfigMethod(property="maxCell", doc="<p>Maximum width in characters of an output table cell. Cells longer than this will be truncated.</p>", example="160", sequence=3)
    public void setMaxFieldChars(int maxFieldChars) {
        this.maxFieldChars_ = maxFieldChars;
    }

    public int getMaxFieldChars() {
        return this.maxFieldChars_;
    }

    @Override
    public String getFormatName() {
        return this.writeHeader_ ? "CSV" : "CSV-noheader";
    }

    @Override
    public String getMimeType() {
        return "text/csv; header=\"" + (this.writeHeader_ ? "present" : "absent") + "\"";
    }

    @Override
    public boolean docIncludesExample() {
        return true;
    }

    @Override
    public String getXmlDescription() {
        return this.readText("CsvTableWriter.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStarTable(StarTable table, OutputStream ostrm) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(ostrm);
        int ncol = table.getColumnCount();
        ColumnInfo[] cinfos = Tables.getColumnInfos(table);
        RowSequence rseq = table.getRowSequence();
        try {
            if (this.getWriteHeader()) {
                String[] headRow = new String[ncol];
                for (int icol = 0; icol < ncol; ++icol) {
                    headRow[icol] = cinfos[icol].getName();
                }
                this.writeRow(out, headRow);
            }
            String[] dataRow = new String[ncol];
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                for (int icol = 0; icol < ncol; ++icol) {
                    dataRow[icol] = cinfos[icol].formatValue(row[icol], this.maxFieldChars_);
                }
                this.writeRow(out, dataRow);
            }
        }
        finally {
            ((Writer)out).flush();
            rseq.close();
        }
    }

    private void writeRow(Writer out, String[] row) throws IOException {
        int ncol = row.length;
        for (int icol = 0; icol < ncol; ++icol) {
            this.writeField(out, row[icol]);
            out.write(icol < ncol - 1 ? (int)this.delimiter_ : 10);
        }
    }

    private void writeField(Writer out, String value) throws IOException {
        char c;
        int i;
        if (value == null || value.length() == 0) {
            return;
        }
        int nchar = value.length();
        boolean quoted = false;
        switch (value.charAt(0)) {
            case '\t': 
            case ' ': {
                quoted = true;
            }
        }
        switch (value.charAt(nchar - 1)) {
            case '\t': 
            case ' ': {
                quoted = true;
            }
        }
        for (i = 0; i < nchar && !quoted; ++i) {
            c = value.charAt(i);
            if (c != '\n' && c != '\r' && c != '\"' && c != this.delimiter_) continue;
            quoted = true;
        }
        if (!quoted) {
            out.write(value);
        } else {
            out.write(34);
            for (i = 0; i < nchar; ++i) {
                c = value.charAt(i);
                switch (c) {
                    case '\"': {
                        out.write(34);
                    }
                }
                out.write(c);
            }
            out.write(34);
        }
    }
}

