/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.stream.Collectors;
import uk.ac.starlink.table.Documented;

public interface DocumentedIOHandler
extends Documented {
    public String[] getExtensions();

    public boolean docIncludesExample();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public String readText(String resourceName) {
        try {
            URL url = this.getClass().getResource(resourceName);
            try (BufferedReader rdr = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));){
                String string = rdr.lines().collect(Collectors.joining("\n"));
                return string;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read resource " + resourceName, e);
        }
    }

    public static boolean matchesExtension(DocumentedIOHandler handler, String filename) {
        int iext = filename.lastIndexOf(46);
        return iext > 0 && Arrays.asList(handler.getExtensions()).contains(filename.substring(iext + 1).toLowerCase());
    }

    public static String toLink(String url) {
        return new StringBuffer().append("<a href='").append(url).append("'>").append(url).append("</a>").toString();
    }
}

