/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.formats;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.formats.DocumentedTableBuilder;
import uk.ac.starlink.table.formats.ErrorMode;
import uk.ac.starlink.table.formats.MrtReader;
import uk.ac.starlink.util.ConfigMethod;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.IOSupplier;

public class MrtTableBuilder
extends DocumentedTableBuilder {
    private ErrorMode errorMode_;
    private boolean checkMagic_;
    private boolean useFloat_;
    public static final String MAGIC_TXT = "Title: ";

    public MrtTableBuilder() {
        this(ErrorMode.WARN, true, false);
    }

    public MrtTableBuilder(ErrorMode errorMode, boolean checkMagic, boolean useFloat) {
        super(new String[]{"mrt", "cds"});
        this.errorMode_ = errorMode;
        this.checkMagic_ = checkMagic;
        this.useFloat_ = useFloat;
    }

    @Override
    public String getFormatName() {
        return "MRT";
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    @ConfigMethod(property="errmode", doc="<p>Indicates what action should be taken if formatting errors\nare detected in the file at read time.\n</p>", example="FAIL")
    public void setErrorMode(ErrorMode errorMode) {
        this.errorMode_ = errorMode;
    }

    public ErrorMode getErrorMode() {
        return this.errorMode_;
    }

    @ConfigMethod(property="checkmagic", doc="<p>Determines whether an initial test is made to see whether\nthe file looks like MRT before attempting to read it as one;\nthe test is that it starts with the string\n\"<code>Title: </code>\".\nSetting this true is generally a good idea\nto avoid attempting to parse non-MRT files,\nbut you can set it false to attempt to read an MRT file\nthat starts with the wrong sequence.\n</p>", example="false")
    public void setCheckMagic(boolean checkMagic) {
        this.checkMagic_ = checkMagic;
    }

    public boolean getCheckMagic() {
        return this.checkMagic_;
    }

    @ConfigMethod(property="usefloat", doc="<p>Sets whether this handler will use a 32-bit float type\nfor reading sufficiently narrow floating point fields.\nThis is usually a good idea\nsince it reduces storage requirements\nwhen only a few significant figures are provided,\nbut can fail if the column contains any\nvery large absolute values (&gt;~1e38),\nwhich cannot be represented in a 32-bit IEEE float.\nSo it's safer to set it false.\n</p>\n<p>If it is set true,\nthen encountering values outside the representable range\nwill be reported in accordance with the current ErrorMode.\n</p>", example="true")
    public void setUseFloat(boolean useFloat) {
        this.useFloat_ = useFloat;
    }

    public boolean getUseFloat() {
        return this.useFloat_;
    }

    @Override
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storage) throws IOException {
        byte[] intro;
        if (this.checkMagic_ && !MrtTableBuilder.isMagic(intro = datsrc.getIntro())) {
            throw new TableFormatException("Does not start with sequence: \"Title: \"");
        }
        IOSupplier<MrtReader> rdrFact = () -> new MrtReader(new BufferedInputStream(datsrc.getInputStream()), this.errorMode_, this.useFloat_);
        MrtReader rdr = rdrFact.get();
        rdr.close();
        return MrtTableBuilder.createStarTable(rdr, rdrFact);
    }

    @Override
    public void streamStarTable(InputStream in, TableSink sink, String pos) throws IOException {
        try (MrtReader rdr = new MrtReader(in, this.errorMode_, this.useFloat_);){
            sink.acceptMetadata(MrtTableBuilder.createStarTable(rdr, () -> {
                throw new UnsupportedOperationException();
            }));
            while (rdr.next()) {
                sink.acceptRow(rdr.getRow());
            }
            sink.endRows();
        }
    }

    @Override
    public boolean canStream() {
        return true;
    }

    @Override
    public boolean docIncludesExample() {
        return false;
    }

    @Override
    public String getXmlDescription() {
        return this.readText("MrtTableBuilder.xml");
    }

    public static boolean isMagic(byte[] intro) {
        int mleng = MAGIC_TXT.length();
        if (intro.length > mleng) {
            for (int i = 0; i < mleng; ++i) {
                if ((char)intro[i] == MAGIC_TXT.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static StarTable createStarTable(final MrtReader rdr, final IOSupplier<? extends RowSequence> rseqFact) {
        AbstractStarTable table = new AbstractStarTable(){

            @Override
            public int getColumnCount() {
                return rdr.getColumnCount();
            }

            @Override
            public ColumnInfo getColumnInfo(int icol) {
                return rdr.getColumnInfo(icol);
            }

            @Override
            public long getRowCount() {
                return -1L;
            }

            @Override
            public RowSequence getRowSequence() throws IOException {
                return (RowSequence)rseqFact.get();
            }

            @Override
            public void close() throws IOException {
                rdr.close();
            }
        };
        table.getParameters().addAll(Arrays.asList(rdr.getParameters()));
        return table;
    }
}

