/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.tfcat;

import org.json.JSONObject;
import uk.ac.starlink.tfcat.Bbox;
import uk.ac.starlink.tfcat.Crs;
import uk.ac.starlink.tfcat.LinearRing;
import uk.ac.starlink.tfcat.Position;
import uk.ac.starlink.tfcat.TfcatObject;

public abstract class Geometry<S>
extends TfcatObject {
    private final S shape_;

    private Geometry(JSONObject json, String type, Crs crs, Bbox bbox, S shape) {
        super(json, type, crs, bbox);
        this.shape_ = shape;
    }

    public S getShape() {
        return this.shape_;
    }

    @Override
    public void purgeJson() {
        super.purgeJson();
        if (this.shape_ instanceof TfcatObject) {
            ((TfcatObject)this.shape_).purgeJson();
        } else if (this.shape_ instanceof TfcatObject[]) {
            for (TfcatObject tfc : (TfcatObject[])this.shape_) {
                tfc.purgeJson();
            }
        }
    }

    public static class GeometryCollection
    extends Geometry<Geometry<?>[]> {
        GeometryCollection(JSONObject json, Crs crs, Bbox bbox, Geometry<?>[] geoms) {
            super(json, "GeometryCollection", crs, bbox, geoms);
            for (Geometry<?> g : geoms) {
                g.setParent(this);
            }
        }
    }

    public static class MultiPolygon
    extends Geometry<LinearRing[][]> {
        MultiPolygon(JSONObject json, Crs crs, Bbox bbox, LinearRing[][] polygons) {
            super(json, "MultiPolygon", crs, bbox, polygons);
        }
    }

    public static class Polygon
    extends Geometry<LinearRing[]> {
        Polygon(JSONObject json, Crs crs, Bbox bbox, LinearRing[] rings) {
            super(json, "Polygon", crs, bbox, rings);
        }
    }

    public static class MultiLineString
    extends Geometry<Position[][]> {
        MultiLineString(JSONObject json, Crs crs, Bbox bbox, Position[][] lines) {
            super(json, "MultiLineString", crs, bbox, lines);
        }
    }

    public static class LineString
    extends Geometry<Position[]> {
        LineString(JSONObject json, Crs crs, Bbox bbox, Position[] positions) {
            super(json, "LineString", crs, bbox, positions);
        }
    }

    public static class MultiPoint
    extends Geometry<Position[]> {
        MultiPoint(JSONObject json, Crs crs, Bbox bbox, Position[] positions) {
            super(json, "MultiPoint", crs, bbox, positions);
        }
    }

    public static class Point
    extends Geometry<Position> {
        Point(JSONObject json, Crs crs, Bbox bbox, Position position) {
            super(json, "Point", crs, bbox, position);
        }
    }
}

