/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.tfcat;

import java.util.List;
import uk.ac.starlink.tfcat.BasicReporter;
import uk.ac.starlink.tfcat.TfcatObject;
import uk.ac.starlink.tfcat.TfcatUtil;
import uk.ac.starlink.tfcat.WordChecker;

public class TfcatStatus {
    private final Code code_;
    private final String message_;
    private static final WordChecker ucdChecker_ = TfcatUtil.getUcdChecker();
    private static final WordChecker unitChecker_ = TfcatUtil.getUnitChecker();

    protected TfcatStatus(Code code, String message) {
        this.code_ = code;
        this.message_ = message;
    }

    public Code getCode() {
        return this.code_;
    }

    public String getMessage() {
        return this.message_;
    }

    public static TfcatStatus getStatus(String tfcatTxt) {
        String msgTxt;
        if (tfcatTxt == null || tfcatTxt.length() == 0) {
            return null;
        }
        boolean isDebug = false;
        BasicReporter reporter = new BasicReporter(isDebug, ucdChecker_, unitChecker_);
        TfcatObject tfcat = TfcatUtil.parseTfcat(tfcatTxt, reporter);
        List<String> msgs = reporter.getMessages();
        int nmsg = msgs.size();
        switch (nmsg) {
            case 0: {
                msgTxt = null;
                break;
            }
            case 1: {
                msgTxt = msgs.get(0);
                break;
            }
            default: {
                msgTxt = String.join((CharSequence)"; ", msgs);
            }
        }
        Code code = tfcat == null ? Code.FAIL : (nmsg == 0 ? Code.OK : Code.INVALID);
        return new TfcatStatus(code, msgTxt);
    }

    public static enum Code {
        OK,
        INVALID,
        FAIL;

    }
}

