/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cea;

import java.util.ArrayList;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.DoubleParameter;
import uk.ac.starlink.task.InputStreamParameter;
import uk.ac.starlink.task.MultiParameter;
import uk.ac.starlink.task.OutputStreamParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.ttools.join.MatchEngineParameter;
import uk.ac.starlink.ttools.task.AbstractInputTableParameter;
import uk.ac.starlink.ttools.task.InputFormatParameter;
import uk.ac.starlink.ttools.task.OutputFormatParameter;
import uk.ac.starlink.ttools.task.OutputModeParameter;
import uk.ac.starlink.ttools.task.OutputTableParameter;

public class CeaParameter {
    private String name_;
    private String description_;
    private String summary_;
    private String type_;
    private String dflt_;
    private boolean isOutput_;
    private boolean isRef_;
    private boolean isMulti_;
    private boolean isNullPermitted_;
    private String[] options_;
    private static StarTableFactory tableFactory_ = new StarTableFactory();
    private static StarTableOutput tableOutput_ = new StarTableOutput();

    public CeaParameter(Parameter<?> taskParam) {
        this.name_ = taskParam.getName();
        this.description_ = taskParam.getDescription();
        this.summary_ = taskParam.getPrompt();
        this.dflt_ = taskParam.getStringDefault();
        this.isNullPermitted_ = taskParam.isNullPermitted();
        this.type_ = "text";
        if (taskParam instanceof OutputTableParameter || taskParam instanceof OutputStreamParameter) {
            this.setOutput(true);
        }
        if (taskParam instanceof AbstractInputTableParameter || taskParam instanceof InputStreamParameter) {
            this.isRef_ = true;
            this.dflt_ = null;
            this.truncateDescription();
        }
        if (taskParam instanceof MultiParameter) {
            this.isMulti_ = true;
        }
        if (taskParam instanceof BooleanParameter) {
            this.type_ = "boolean";
        }
        if (taskParam instanceof DoubleParameter) {
            this.type_ = "double";
        }
        if (taskParam instanceof ChoiceParameter) {
            this.options_ = ((ChoiceParameter)taskParam).getOptionNames();
        } else if (taskParam instanceof InputFormatParameter) {
            ArrayList<String> opts = new ArrayList<String>();
            opts.add("(auto)");
            opts.addAll(tableFactory_.getKnownFormats());
            this.options_ = opts.toArray(new String[0]);
        } else if (taskParam instanceof OutputFormatParameter) {
            ArrayList opts = new ArrayList(tableOutput_.getKnownFormats());
            opts.remove("jdbc");
            this.options_ = opts.toArray(new String[0]);
            assert (!opts.contains("(auto)"));
            this.dflt_ = null;
        } else if (taskParam instanceof MatchEngineParameter) {
            this.options_ = MatchEngineParameter.getExampleValues();
        } else if (taskParam instanceof OutputModeParameter) assert (false);
    }

    public String getName() {
        return this.name_;
    }

    public String getDescription() {
        return this.description_;
    }

    public String getSummary() {
        return this.summary_;
    }

    public String getType() {
        return this.type_;
    }

    public boolean isOutput() {
        return this.isOutput_;
    }

    public void setOutput(boolean isOutput) {
        this.isOutput_ = isOutput;
        if (isOutput) {
            this.isRef_ = true;
            this.dflt_ = null;
            this.isNullPermitted_ = false;
            this.truncateDescription();
        }
    }

    public void setRef(boolean isRef) {
        this.isRef_ = isRef;
        if (isRef) {
            this.dflt_ = null;
            this.isNullPermitted_ = false;
            this.truncateDescription();
        }
    }

    public boolean isRef() {
        return this.isRef_;
    }

    public boolean isMulti() {
        return this.isMulti_;
    }

    public boolean isNullPermitted() {
        return this.isNullPermitted_;
    }

    public String getDefault() {
        return this.dflt_;
    }

    public String[] getOptions() {
        return this.options_;
    }

    public void truncateDescription() {
        int dot1 = this.description_.indexOf(46);
        String string = this.description_ = dot1 > 0 ? this.description_.substring(0, dot1 + 1) : this.description_;
        if (this.description_.startsWith("<p>")) {
            this.description_ = this.description_.substring(3);
        }
    }
}

