/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.filter.ProcessingFilter;

public abstract class BasicFilter
implements ProcessingFilter {
    private final String name_;
    private final String usage_;

    protected BasicFilter(String name, String usage) {
        this.name_ = name;
        this.usage_ = usage;
    }

    public String getName() {
        return this.name_;
    }

    @Override
    public String getUsage() {
        return this.usage_;
    }

    @Override
    public String getDescription() {
        return DocUtils.join(this.getDescriptionLines());
    }

    protected abstract String[] getDescriptionLines();

    public static String explainSyntax(String[] usages) {
        int nUsage = usages.length;
        if (nUsage == 0) {
            return "";
        }
        StringBuffer sbuf = new StringBuffer().append("<p>").append("Syntax for the ");
        String[] refids = new String[nUsage];
        for (int i = 0; i < nUsage; ++i) {
            String refid;
            String usage;
            if (i > 0) {
                sbuf.append(i == nUsage - 1 ? " and " : ", ");
            }
            if ((usage = usages[i]).contains("expr") || usage.contains("key-list")) {
                refid = "jel";
            } else if (usage.contains("col-id")) {
                refid = "col-id";
            } else if (usage.contains("colid-list")) {
                refid = "colid-list";
            } else {
                throw new IllegalArgumentException("Unknown usage type " + usage);
            }
            refids[i] = refid;
            if (nUsage > 1) {
                sbuf.append("<ref id=\"").append(refid).append("\">");
            }
            sbuf.append("<code>").append("&lt;").append(usage).append("&gt;").append("</code>");
            if (nUsage > 1) {
                sbuf.append("</ref>");
            }
            sbuf.append(" ");
        }
        if (nUsage == 1) {
            sbuf.append("argument").append(" is described in ").append("<ref id=\"").append(refids[0]).append("\"/>");
        } else {
            sbuf.append("arguments").append(" is described in ").append("the manual");
        }
        sbuf.append(".\n").append("</p>\n");
        return sbuf.toString();
    }
}

