/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.IntStream;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowCollector;
import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;
import uk.ac.starlink.util.IntList;

public class ConstFilter
extends BasicFilter {
    public ConstFilter() {
        super("constcol", "[-noparam] [-acceptnull] [-[no]parallel] [<colid-list>]");
    }

    @Override
    protected String[] getDescriptionLines() {
        return new String[]{"<p>Identifies columns with constant values.", "Such columns are removed from the table and by default", "their fixed value is added to the table", "as a table parameter", "with the same name as the removed column.", "Such columns may have scalar or array values.", "</p>", "<p>The <code>-noparam</code> flag", "controls whether constant columns identified are recorded instead", "as table parameters (per-table metadata items).", "By default they are, but supplying <code>-noparam</code>", "means these values will just be discarded.", "</p>", "<p>The <code>-acceptnull</code> flag", "controls how blank values in candidate columns are treated.", "By default, all values in a column must be strictly the same", "for a column to be identified as constant value,", "but if <code>-acceptnull</code> is supplied", "then a column will be treated as constant if all its entries", "are <em>either</em> a single fixed value <em>or</em> blank.", "</p>", "<p>The <code>-[no]parallel</code> flag", "controls whether processing is done using multithreading", "for large tables.", "</p>", "<p>The <code>&lt;colid-list&gt;</code>", "gives the columns to be assessed by this filter;", "if not supplied, all columns will be examined.", "</p>", ConstFilter.explainSyntax(new String[]{"colid-list"})};
    }

    @Override
    public ProcessingStep createStep(Iterator<String> argIt) throws ArgException {
        boolean acceptNull = false;
        boolean toParam = true;
        boolean isParallel = false;
        String colIdList = null;
        while (argIt.hasNext()) {
            String arg = argIt.next();
            argIt.remove();
            if ("-param".equalsIgnoreCase(arg)) {
                toParam = true;
                continue;
            }
            if ("-noparam".equalsIgnoreCase(arg)) {
                toParam = false;
                continue;
            }
            if ("-acceptnull".equalsIgnoreCase(arg)) {
                acceptNull = true;
                continue;
            }
            if ("-noacceptnull".equalsIgnoreCase(arg)) {
                acceptNull = false;
                continue;
            }
            if ("-parallel".equalsIgnoreCase(arg)) {
                isParallel = true;
                continue;
            }
            if ("-noparallel".equalsIgnoreCase(arg)) {
                isParallel = false;
                continue;
            }
            if (arg.startsWith("-")) {
                throw new ArgException("Unknown flag \"" + arg + "\"");
            }
            if (colIdList == null) {
                colIdList = arg;
                continue;
            }
            throw new ArgException("Multiple column lists");
        }
        final boolean acceptNull0 = acceptNull;
        final boolean toParam0 = toParam;
        final String colIdList0 = colIdList;
        final RowRunner runner = isParallel ? RowRunner.DEFAULT : RowRunner.SEQUENTIAL;
        return new ProcessingStep(){

            @Override
            public StarTable wrap(StarTable inTable) throws IOException {
                int nc = inTable.getColumnCount();
                int[] icols = colIdList0 == null ? IntStream.range(0, nc).toArray() : new ColumnIdentifier(inTable).getColumnIndices(colIdList0);
                State[] states = (State[])runner.collect((RowCollector)new StateCollector(icols, acceptNull0), inTable);
                IntList iconstList = new IntList();
                ArrayList<State> constStates = new ArrayList<State>();
                for (int is = 0; is < icols.length; ++is) {
                    State state = states[is];
                    if (state.hasDifferent_) continue;
                    iconstList.add(icols[is]);
                    constStates.add(state);
                }
                int[] iconsts = iconstList.toIntArray();
                if (iconsts.length == 0) {
                    return inTable;
                }
                ColumnPermutedStarTable outTable = ColumnPermutedStarTable.deleteColumns((StarTable)inTable, (int[])iconsts);
                if (toParam0) {
                    for (int is = 0; is < iconsts.length; ++is) {
                        ColumnInfo cinfo = inTable.getColumnInfo(iconsts[is]);
                        DefaultValueInfo vinfo = new DefaultValueInfo((ValueInfo)cinfo);
                        Object value = ((State)constStates.get((int)is)).value_;
                        outTable.getParameters().add(new DescribedValue((ValueInfo)vinfo, value));
                    }
                }
                return outTable;
            }
        };
    }

    private static boolean arrayEquals(Object a1, Object a2) {
        Class<?> clazz = a1.getClass();
        if (byte[].class.equals(clazz)) {
            return Arrays.equals((byte[])a1, (byte[])a2);
        }
        if (short[].class.equals(clazz)) {
            return Arrays.equals((short[])a1, (short[])a2);
        }
        if (int[].class.equals(clazz)) {
            return Arrays.equals((int[])a1, (int[])a2);
        }
        if (long[].class.equals(clazz)) {
            return Arrays.equals((long[])a1, (long[])a2);
        }
        if (float[].class.equals(clazz)) {
            return Arrays.equals((float[])a1, (float[])a2);
        }
        if (double[].class.equals(clazz)) {
            return Arrays.equals((double[])a1, (double[])a2);
        }
        if (boolean[].class.equals(clazz)) {
            return Arrays.equals((boolean[])a1, (boolean[])a2);
        }
        if (char[].class.equals(clazz)) {
            return Arrays.equals((char[])a1, (char[])a2);
        }
        if (a1 instanceof Object[]) {
            return Arrays.equals((Object[])a1, (Object[])a2);
        }
        assert (false) : clazz;
        return false;
    }

    private static boolean allDifferent(State[] states) {
        int ns = states.length;
        for (int is = 0; is < ns; ++is) {
            if (states[is].hasDifferent_) continue;
            return false;
        }
        return true;
    }

    private static class State {
        boolean hasValue_;
        boolean hasDifferent_;
        Object value_;

        private State() {
        }
    }

    private static class StateCollector
    extends RowCollector<State[]> {
        private final int[] icols_;
        private final boolean acceptNull_;
        private final int ns_;

        StateCollector(int[] icols, boolean acceptNull) {
            this.icols_ = icols;
            this.acceptNull_ = acceptNull;
            this.ns_ = icols.length;
        }

        public State[] createAccumulator() {
            State[] states = new State[this.ns_];
            for (int is = 0; is < this.ns_; ++is) {
                states[is] = new State();
            }
            return states;
        }

        public State[] combine(State[] states1, State[] states2) {
            for (int is = 0; is < this.ns_; ++is) {
                State s1 = states1[is];
                State s2 = states2[is];
                if (s2.hasDifferent_) {
                    s1.hasDifferent_ = true;
                    continue;
                }
                if (!s2.hasValue_) continue;
                if (s1.hasValue_) {
                    if (!this.isDifferent(s1.value_, s2.value_)) continue;
                    s1.hasDifferent_ = true;
                    continue;
                }
                states1[is] = s2;
            }
            return states1;
        }

        public void accumulateRows(RowSplittable rseq, State[] states) throws IOException {
            while (!ConstFilter.allDifferent(states) && rseq.next()) {
                for (int is = 0; is < this.ns_; ++is) {
                    Object v = rseq.getCell(this.icols_[is]);
                    State s0 = states[is];
                    if (s0.hasDifferent_ || this.acceptNull_ && Tables.isBlank((Object)v)) continue;
                    if (s0.hasValue_) {
                        if (!this.isDifferent(s0.value_, v)) continue;
                        s0.hasDifferent_ = true;
                        continue;
                    }
                    s0.hasValue_ = true;
                    s0.value_ = v;
                }
            }
        }

        private boolean isDifferent(Object v1, Object v2) {
            boolean null1 = Tables.isBlank((Object)v1);
            boolean null2 = Tables.isBlank((Object)v2);
            if (null1 && null2) {
                return false;
            }
            if (null1 || null2) {
                return !this.acceptNull_;
            }
            Class<?> clazz = v1.getClass();
            if (!clazz.equals(v2.getClass())) {
                return true;
            }
            return clazz.getComponentType() == null ? !v1.equals(v2) : !ConstFilter.arrayEquals(v1, v2);
        }
    }
}

