/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.starlink.ttools.filter.Quantiler;

public class SortQuantiler
implements Quantiler {
    private final int blocksize_;
    private List<double[]> fullBlocks_;
    private int ix_;
    private double[] block_;
    private double[] sorted_;
    private int nsort_;
    public static final int DFLT_BLOCKSIZE = 16384;

    public SortQuantiler() {
        this(16384);
    }

    public SortQuantiler(int blocksize) {
        this.blocksize_ = blocksize;
        this.fullBlocks_ = new ArrayList<double[]>();
        this.ix_ = this.blocksize_;
    }

    @Override
    public void acceptDatum(double value) {
        if (!Double.isNaN(value)) {
            if (this.ix_ > this.blocksize_ - 1) {
                if (this.block_ != null) {
                    this.fullBlocks_.add(this.block_);
                }
                this.block_ = new double[this.blocksize_];
                this.ix_ = 0;
            }
            this.block_[this.ix_++] = value;
        }
    }

    @Override
    public void addQuantiler(Quantiler o) {
        SortQuantiler other = (SortQuantiler)o;
        this.fullBlocks_.addAll(other.fullBlocks_);
        if (other.block_ != null) {
            for (int i = 0; i < other.ix_; ++i) {
                this.acceptDatum(other.block_[i]);
            }
        }
    }

    @Override
    public void ready() {
        if (this.sorted_ == null) {
            double[] all;
            int nall;
            if (this.block_ == null) {
                assert (this.fullBlocks_.size() == 0);
                nall = 0;
                all = new double[]{};
            } else if (this.ix_ > 0 || this.fullBlocks_.size() > 1) {
                int ns = this.ix_;
                for (double[] block : this.fullBlocks_) {
                    ns += block.length;
                }
                all = new double[ns];
                nall = ns;
                int ipos = 0;
                for (double[] block : this.fullBlocks_) {
                    System.arraycopy(block, 0, all, ipos, block.length);
                    ipos += block.length;
                }
                if (this.block_ != null) {
                    System.arraycopy(this.block_, 0, all, ipos, this.ix_);
                }
                assert ((ipos += this.ix_) == nall);
            } else {
                all = this.fullBlocks_.get(0);
                nall = this.ix_;
            }
            this.block_ = null;
            this.fullBlocks_ = null;
            Arrays.parallelSort(all, 0, nall);
            this.sorted_ = all;
            this.nsort_ = nall;
        }
    }

    @Override
    public double getValueAtQuantile(double quantile) {
        if (this.sorted_ == null) {
            throw new IllegalStateException("Not ready");
        }
        if (quantile >= 0.0 && quantile <= 1.0) {
            if (this.nsort_ > 1) {
                double dpos = quantile * (double)(this.nsort_ - 1);
                int ipos = (int)dpos;
                double frac = dpos - (double)ipos;
                double value = this.sorted_[ipos];
                if (frac > 0.0) {
                    value += frac * (this.sorted_[ipos + 1] - this.sorted_[ipos]);
                }
                return value;
            }
            if (this.nsort_ == 1) {
                return this.sorted_[0];
            }
            assert (this.nsort_ == 0);
            return Double.NaN;
        }
        throw new IllegalArgumentException("Quantile out of range 0..1");
    }
}

