/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.gui;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import uk.ac.starlink.ttools.build.Heading;

public class DocNames {
    public static final char ARRAY_SUFFIX = ',';
    public static final char TOKEN_SEPARATOR = '-';

    public static URL docURL(Object obj) {
        if (obj instanceof Class) {
            return DocNames.classDocURL((Class)obj);
        }
        if (obj instanceof Field) {
            return DocNames.fieldDocURL((Field)obj);
        }
        if (obj instanceof Method) {
            return DocNames.methodDocURL((Method)obj);
        }
        if (obj instanceof Heading) {
            return DocNames.headingDocURL((Heading)obj);
        }
        return null;
    }

    public static String typeNameToWord(String typeName) {
        return typeName == null ? null : typeName.replaceFirst(".*[.$]", "");
    }

    private static URL docURL(Class<?> clazz, String suffix) {
        String fqname = clazz.getName();
        String rpath = "/" + fqname.replaceAll("\\.", "/") + suffix;
        return clazz.getResource(rpath);
    }

    private static URL classDocURL(Class<?> clazz) {
        return DocNames.docURL(clazz, ".html");
    }

    private static URL fieldDocURL(Field field) {
        return DocNames.docURL(field.getDeclaringClass(), '-' + field.getName() + ".html");
    }

    private static URL methodDocURL(Method method) {
        StringBuffer mangle = new StringBuffer();
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            mangle.append('-');
            int narray = 0;
            Class<?> clazz = types[i];
            while (clazz.isArray()) {
                ++narray;
                clazz = clazz.getComponentType();
            }
            mangle.append(DocNames.typeNameToWord(clazz.getName()));
            for (int j = 0; j < narray; ++j) {
                mangle.append(',');
            }
        }
        return DocNames.docURL(method.getDeclaringClass(), '-' + method.getName() + mangle.toString() + ".html");
    }

    private static URL headingDocURL(Heading heading) {
        return DocNames.docURL(Heading.class, heading.getDocSuffix());
    }
}

