/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.ErrorModeSelection;
import uk.ac.starlink.ttools.plot.ErrorRenderer;
import uk.ac.starlink.ttools.plot.MarkShape;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.layer.MarkerStyle;
import uk.ac.starlink.util.IconUtils;

public class MarkStyleSelectors {
    private static final int MAX_SIZE = 5;
    private static final int MAX_THICK = 10;
    private static final MarkShape[] SHAPES = new MarkShape[]{MarkShape.FILLED_CIRCLE, MarkShape.OPEN_CIRCLE, MarkShape.CROSS, MarkShape.CROXX, MarkShape.OPEN_SQUARE, MarkShape.OPEN_DIAMOND, MarkShape.OPEN_TRIANGLE_UP, MarkShape.OPEN_TRIANGLE_DOWN, MarkShape.FILLED_SQUARE, MarkShape.FILLED_DIAMOND, MarkShape.FILLED_TRIANGLE_UP, MarkShape.FILLED_TRIANGLE_DOWN};

    private MarkStyleSelectors() {
    }

    public static JComboBox<MarkShape> createShapeSelector() {
        return MarkStyleSelectors.createShapeSelector(SHAPES);
    }

    public static JComboBox<MarkShape> createShapeSelector(MarkShape[] shapes) {
        final JComboBox<MarkShape> selector = new JComboBox<MarkShape>(shapes);
        selector.setRenderer((ListCellRenderer<MarkShape>)new MarkRenderer<MarkShape>(){

            @Override
            public MarkShape getMarkShape(int index) {
                return (MarkShape)selector.getItemAt(index);
            }

            @Override
            public MarkShape getMarkShape() {
                return (MarkShape)selector.getItemAt(selector.getSelectedIndex());
            }

            @Override
            public Color getMarkColor() {
                return Color.BLACK;
            }

            @Override
            public int getMarkSize() {
                return 5;
            }
        });
        return selector;
    }

    public static JComboBox<MarkerShape> createMarkerShapeSelector(MarkerShape[] shapes) {
        final JComboBox<MarkerShape> selector = new JComboBox<MarkerShape>(shapes);
        selector.setRenderer((ListCellRenderer<MarkerShape>)new MarkerRenderer<MarkerShape>(){

            @Override
            public MarkerShape getMarkerShape(int index) {
                return (MarkerShape)selector.getItemAt(index);
            }

            @Override
            public MarkerShape getMarkerShape() {
                return (MarkerShape)selector.getItemAt(selector.getSelectedIndex());
            }

            @Override
            public Color getMarkerColor() {
                return Color.BLACK;
            }

            @Override
            public int getMarkerSize() {
                return 5;
            }
        });
        return selector;
    }

    public static JComboBox<Integer> createSizeSelector() {
        return MarkStyleSelectors.createSizeSelector(5);
    }

    public static JComboBox<Integer> createSizeSelector(int maxSize) {
        final JComboBox<Integer> selector = new JComboBox<Integer>(MarkStyleSelectors.createNumberedModel(maxSize + 1));
        selector.setRenderer((ListCellRenderer<Integer>)new MarkRenderer<Integer>(true){

            @Override
            public int getMarkSize(int index) {
                return index;
            }

            @Override
            public int getMarkSize() {
                return selector.getSelectedIndex();
            }

            @Override
            public Color getMarkColor() {
                return Color.BLACK;
            }

            @Override
            public MarkShape getMarkShape() {
                return MarkShape.OPEN_SQUARE;
            }
        });
        return selector;
    }

    public static JComboBox<ErrorRenderer> createErrorSelector(ErrorRenderer[] errorRenderers, ErrorRenderer defaultRenderer, ErrorModeSelection[] errorModeSelections) {
        ErrorRendererComboBoxModel model = new ErrorRendererComboBoxModel(errorRenderers, defaultRenderer, errorModeSelections);
        ErrorRendererRenderer renderer = new ErrorRendererRenderer(errorModeSelections);
        JComboBox<ErrorRenderer> errorSelector = new JComboBox<ErrorRenderer>(model);
        errorSelector.setRenderer(renderer);
        return errorSelector;
    }

    public static ComboBoxModel<Integer> createNumberedModel(int count) {
        Integer[] items = new Integer[count];
        for (int i = 0; i < count; ++i) {
            items[i] = i;
        }
        return new DefaultComboBoxModel<Integer>(items);
    }

    public static MarkStyle getStyle(MarkShape shape, int size, Color color, int opaqueLimit, boolean hidePoints, ErrorRenderer errorRenderer, MarkStyle.Line line, int thick, float[] dash, ErrorModeSelection[] errModels) {
        MarkStyle style = size == 0 ? MarkShape.POINT.getStyle(color, 0) : shape.getStyle(color, size);
        style.setOpaqueLimit(opaqueLimit);
        style.setLine(line);
        style.setHidePoints(hidePoints);
        style.setErrorRenderer(errorRenderer);
        style.setLineWidth(thick);
        style.setDash(dash);
        style.setErrorModeModels(errModels);
        return style;
    }

    private static abstract class MarkerRenderer<E>
    implements ListCellRenderer<E> {
        private boolean useText_;
        private final BasicComboBoxRenderer baseRenderer_;

        MarkerRenderer() {
            this(false);
        }

        MarkerRenderer(boolean useText) {
            this.useText_ = useText;
            this.baseRenderer_ = new BasicComboBoxRenderer();
        }

        MarkerShape getMarkerShape(int itemIndex) {
            return this.getMarkerShape();
        }

        abstract MarkerShape getMarkerShape();

        int getMarkerSize(int itemIndex) {
            return this.getMarkerSize();
        }

        abstract int getMarkerSize();

        Color getMarkerColor(int itemIndex) {
            return this.getMarkerColor();
        }

        abstract Color getMarkerColor();

        @Override
        public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean hasFocus) {
            Component c = this.baseRenderer_.getListCellRendererComponent((JList<?>)list, (Object)value, index, isSelected, hasFocus);
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                if (!this.useText_) {
                    label.setText(null);
                }
                MarkerStyle style = index >= 0 ? this.getMarkerShape(index).getStyle(this.getMarkerColor(index), this.getMarkerSize(index)) : this.getMarkerShape().getStyle(this.getMarkerColor(), this.getMarkerSize());
                label.setIcon(style.getLegendIcon());
            }
            return c;
        }
    }

    private static abstract class MarkRenderer<E>
    implements ListCellRenderer<E> {
        private boolean useText_;
        private final BasicComboBoxRenderer baseRenderer_;

        MarkRenderer() {
            this(false);
        }

        MarkRenderer(boolean useText) {
            this.useText_ = useText;
            this.baseRenderer_ = new BasicComboBoxRenderer();
        }

        MarkShape getMarkShape(int itemIndex) {
            return this.getMarkShape();
        }

        abstract MarkShape getMarkShape();

        int getMarkSize(int itemIndex) {
            return this.getMarkSize();
        }

        abstract int getMarkSize();

        Color getMarkColor(int itemIndex) {
            return this.getMarkColor();
        }

        abstract Color getMarkColor();

        @Override
        public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean hasFocus) {
            Component c = this.baseRenderer_.getListCellRendererComponent((JList<?>)list, (Object)value, index, isSelected, hasFocus);
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                if (!this.useText_) {
                    label.setText(null);
                }
                MarkStyle style = index >= 0 ? MarkStyleSelectors.getStyle(this.getMarkShape(index), this.getMarkSize(index), this.getMarkColor(index), 1, false, ErrorRenderer.NONE, null, 1, null, new ErrorModeSelection[0]) : MarkStyleSelectors.getStyle(this.getMarkShape(), this.getMarkSize(), this.getMarkColor(), 1, false, ErrorRenderer.NONE, null, 1, null, new ErrorModeSelection[0]);
                label.setIcon(style.getLegendIcon());
            }
            return c;
        }
    }

    private static class ErrorRendererRenderer
    implements ListCellRenderer<ErrorRenderer> {
        private final ErrorModeSelection[] errModeSelections_;
        private final BasicComboBoxRenderer baseRenderer_;

        ErrorRendererRenderer(ErrorModeSelection[] errorModeSelections) {
            this.errModeSelections_ = errorModeSelections;
            this.baseRenderer_ = new BasicComboBoxRenderer();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ErrorRenderer> list, ErrorRenderer er, int index, boolean isSelected, boolean hasFocus) {
            Component c = this.baseRenderer_.getListCellRendererComponent(list, er, index, isSelected, hasFocus);
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                Icon icon = null;
                ErrorMode[] modes = new ErrorMode[this.errModeSelections_.length];
                for (int imode = 0; imode < modes.length; ++imode) {
                    modes[imode] = this.errModeSelections_[imode].getErrorMode();
                }
                icon = er.getLegendIcon(modes, 40, 15, 5, 1);
                label.setText((icon = IconUtils.colorIcon((Icon)icon, (Color)c.getForeground())) == null ? "??" : null);
                label.setIcon(icon);
            }
            return c;
        }
    }

    private static class ErrorRendererComboBoxModel
    extends AbstractListModel<ErrorRenderer>
    implements ComboBoxModel<ErrorRenderer>,
    ActionListener {
        private final ErrorRenderer[] allRenderers_;
        private final ErrorRenderer defaultRenderer_;
        private final ErrorModeSelection[] modeSelections_;
        private List<ErrorRenderer> activeRendererList_;
        private ErrorRenderer selected_;

        ErrorRendererComboBoxModel(ErrorRenderer[] renderers, ErrorRenderer defaultRenderer, ErrorModeSelection[] modeSelections) {
            this.allRenderers_ = renderers;
            this.defaultRenderer_ = defaultRenderer;
            this.modeSelections_ = modeSelections;
            this.selected_ = defaultRenderer;
            this.updateState();
            for (int idim = 0; idim < modeSelections.length; ++idim) {
                modeSelections[idim].addActionListener(this);
            }
        }

        @Override
        public ErrorRenderer getElementAt(int index) {
            return this.activeRendererList_.get(index);
        }

        @Override
        public int getSize() {
            return this.activeRendererList_.size();
        }

        @Override
        public Object getSelectedItem() {
            return this.selected_;
        }

        @Override
        public void setSelectedItem(Object item) {
            if (!this.activeRendererList_.contains(item) || !(item instanceof ErrorRenderer)) {
                throw new IllegalArgumentException("No such selection " + item);
            }
            this.selected_ = (ErrorRenderer)item;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.updateState();
        }

        private void updateState() {
            int ndim = 0;
            for (int idim = 0; idim < this.modeSelections_.length; ++idim) {
                if (ErrorMode.NONE.equals(this.modeSelections_[idim].getErrorMode())) continue;
                ++ndim;
            }
            ArrayList<ErrorRenderer> rendererList = new ArrayList<ErrorRenderer>();
            for (int ir = 0; ir < this.allRenderers_.length; ++ir) {
                ErrorRenderer renderer = this.allRenderers_[ir];
                if (!renderer.supportsDimensionality(ndim)) continue;
                rendererList.add(renderer);
            }
            if (!rendererList.contains(this.selected_)) {
                this.selected_ = this.defaultRenderer_;
            }
            this.activeRendererList_ = rendererList;
            this.fireContentsChanged(this, 0, this.activeRendererList_.size() - 1);
        }
    }
}

