/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.jel;

import java.io.IOException;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.jel.JELRowReader;
import uk.ac.starlink.ttools.jel.StarTableJELRowReader;
import uk.ac.starlink.util.IntList;

public class ColumnIdentifier {
    private final StarTable table_;
    private final int ncol_;
    private final String[] colNames_;
    private final String[] colUcds_;
    private final String[] colUtypes_;
    private boolean caseSensitive_;

    public ColumnIdentifier(StarTable table) {
        this.table_ = table;
        this.ncol_ = this.table_.getColumnCount();
        this.colNames_ = new String[this.ncol_];
        this.colUcds_ = new String[this.ncol_];
        this.colUtypes_ = new String[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            String utype;
            String ucd;
            ColumnInfo info = this.table_.getColumnInfo(icol);
            String name = info.getName();
            if (name != null) {
                this.colNames_[icol] = name.trim();
            }
            if ((ucd = info.getUCD()) != null) {
                this.colUcds_[icol] = ucd.trim();
            }
            if ((utype = info.getUtype()) == null) continue;
            this.colUtypes_[icol] = utype.trim();
        }
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive_ = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive_;
    }

    public int getColumnIndex(String colid) throws IOException {
        return this.getScalarColumnIndex(colid, NotFoundMode.FAIL);
    }

    public int[] getColumnIndices(String colidList) throws IOException {
        IntList colIds = new IntList();
        for (String token : colidList.trim().split("\\s+")) {
            colIds.addAll(this.tokenToColumnIndices(token));
        }
        return colIds.toIntArray();
    }

    private int[] tokenToColumnIndices(String token) throws IOException {
        int icol = this.getScalarColumnIndex(token, NotFoundMode.RETURN);
        if (icol >= 0) {
            return new int[]{icol};
        }
        Pattern regex = ColumnIdentifier.globToRegex(token, this.isCaseSensitive());
        if (regex != null) {
            return this.findMatchingColumns(regex);
        }
        int iMinus = token.indexOf(45);
        if (iMinus >= 0 && token.length() > 1) {
            int icN;
            int ic0 = iMinus > 0 ? this.getScalarColumnIndex(token.substring(0, iMinus), NotFoundMode.FAIL) : 0;
            int n = icN = iMinus < token.length() - 1 ? this.getScalarColumnIndex(token.substring(iMinus + 1), NotFoundMode.FAIL) : this.ncol_ - 1;
            if (icN < ic0) {
                throw new IOException("Negative column range \"" + token + "\" (" + ic0 + "-" + icN + ")");
            }
            int[] icols = new int[icN - ic0 + 1];
            for (int ic = ic0; ic <= icN; ++ic) {
                icols[ic - ic0] = ic;
            }
            return icols;
        }
        this.getScalarColumnIndex(token, NotFoundMode.FAIL);
        assert (false);
        return new int[0];
    }

    public boolean[] getColumnFlags(String colIdList) throws IOException {
        boolean[] colFlags = new boolean[this.ncol_];
        int[] icols = this.getColumnIndices(colIdList);
        for (int i = 0; i < icols.length; ++i) {
            colFlags[icols[i]] = true;
        }
        return colFlags;
    }

    private int getScalarColumnIndex(String colid, NotFoundMode notFound) throws IOException {
        if ((colid = colid.trim()).length() == 0) {
            return notFound.returnValue("Blank column ID not allowed");
        }
        if (colid.matches("\\Q$\\E?[0-9]+")) {
            int ix1;
            if (colid.charAt(0) == '$') {
                colid = colid.substring(1);
            }
            if ((ix1 = Integer.parseInt(colid)) < 1 || ix1 > this.ncol_) {
                return notFound.returnValue("Column index " + ix1 + " out of range 1.." + this.ncol_);
            }
            return ix1 - 1;
        }
        String ucd = JELRowReader.stripPrefix(colid, "ucd$");
        if (ucd != null) {
            Pattern ucdRegex = StarTableJELRowReader.getUcdRegex(ucd);
            for (int icol = 0; icol < this.ncol_; ++icol) {
                String colUcd = this.colUcds_[icol];
                if (colUcd == null || !ucdRegex.matcher(colUcd).matches()) continue;
                return icol;
            }
            return notFound.returnValue("No column with UCD matching " + ucd);
        }
        String utype = JELRowReader.stripPrefix(colid, "utype$");
        if (utype != null) {
            Pattern utypeRegex = StarTableJELRowReader.getUtypeRegex(utype);
            for (int icol = 0; icol < this.ncol_; ++icol) {
                String colUtype = this.colUtypes_[icol];
                if (colUtype == null || !utypeRegex.matcher(colUtype).matches()) continue;
                return icol;
            }
            return notFound.returnValue("No column with Utype matching " + utype);
        }
        for (int icol = 0; icol < this.ncol_; ++icol) {
            String name = this.colNames_[icol];
            if (!(this.isCaseSensitive() ? colid.equals(name) : colid.equalsIgnoreCase(name))) continue;
            return icol;
        }
        return notFound.returnValue("No column matching \"" + colid + "\"");
    }

    private int[] findMatchingColumns(Pattern regex) {
        int ncol = this.table_.getColumnCount();
        IntList icolList = new IntList();
        for (int icol = 0; icol < ncol; ++icol) {
            String colName = this.table_.getColumnInfo(icol).getName();
            if (colName == null || !regex.matcher(colName.trim()).matches()) continue;
            icolList.add(icol);
        }
        return icolList.toIntArray();
    }

    public static Pattern globToRegex(String glob, boolean caseSensitive) {
        if (glob.indexOf(42) < 0) {
            return null;
        }
        if (glob.indexOf("**") >= 0) {
            throw new IllegalArgumentException("Bad pattern (adjacent wildcards): " + glob);
        }
        StringBuffer sbuf = new StringBuffer();
        boolean quoted = false;
        for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            if (c == '*') {
                if (quoted) {
                    sbuf.append("\\E");
                    quoted = false;
                }
                sbuf.append(".*");
                continue;
            }
            if (!quoted) {
                sbuf.append("\\Q");
                quoted = true;
            }
            sbuf.append(c);
        }
        String regex = sbuf.toString();
        int flags = caseSensitive ? 0 : 2;
        return Pattern.compile(regex, flags);
    }

    private static enum NotFoundMode {
        RETURN{

            @Override
            int returnValue(String msg) {
                return -1;
            }
        }
        ,
        FAIL{

            @Override
            int returnValue(String msg) throws IOException {
                throw new IOException(msg);
            }
        };


        abstract int returnValue(String var1) throws IOException;
    }
}

