/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.moc;

import uk.ac.starlink.ttools.moc.BagMocBuilder;
import uk.ac.starlink.ttools.moc.BitSetBag;
import uk.ac.starlink.ttools.moc.CdsMocBuilder;
import uk.ac.starlink.ttools.moc.IntegerBag;
import uk.ac.starlink.ttools.moc.LongBag;
import uk.ac.starlink.ttools.moc.MocBuilder;
import uk.ac.starlink.ttools.moc.MultiBitSetBag;

public abstract class MocImpl {
    private final String name_;
    private final String description_;
    public static final int BITSET_MAXORDER = 12;
    private static final int BITSET_MAXSIZE = 0xC000000;
    public static final MocImpl CDS = new MocImpl("cds", "Uses CDS SMoc class"){
        final int batchSize = 1;

        @Override
        public MocBuilder createMocBuilder(int mocOrder) {
            return CdsMocBuilder.createCdsMocBuilder(mocOrder, 1);
        }
    };
    public static final MocImpl BITSET = new MocImpl("bits", "Uses BitSets"){

        @Override
        public MocBuilder createMocBuilder(int mocOrder) {
            return new BagMocBuilder(mocOrder, s -> s <= 0xC000000L ? new BitSetBag((int)s) : new MultiBitSetBag(s));
        }
    };
    public static final MocImpl LIST = new MocImpl("lists", "Uses BitSets and lists"){

        @Override
        public MocBuilder createMocBuilder(int mocOrder) {
            return new BagMocBuilder(mocOrder, s -> {
                if (s < 0xC000000L) {
                    return new BitSetBag((int)s);
                }
                if (s < Integer.MAX_VALUE) {
                    return new IntegerBag();
                }
                return new LongBag();
            });
        }
    };
    public static final MocImpl AUTO = new MocImpl("auto", "Chooses implementation based on order"){

        @Override
        public MocBuilder createMocBuilder(int mocOrder) {
            return (mocOrder <= 12 ? BITSET : CDS).createMocBuilder(mocOrder);
        }
    };

    protected MocImpl(String name, String description) {
        this.name_ = name;
        this.description_ = description;
    }

    public abstract MocBuilder createMocBuilder(int var1);

    public String getName() {
        return this.name_;
    }

    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.name_;
    }
}

