/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

public class XYStats {
    private final boolean xLog_;
    private final boolean yLog_;
    private double n;
    private double sX;
    private double sY;
    private double sXX;
    private double sYY;
    private double sXY;
    private double minX;
    private double maxX;
    private static final double LOG10SCALE = 1.0 / Math.log(10.0);

    public XYStats(boolean xLog, boolean yLog) {
        this.xLog_ = xLog;
        this.yLog_ = yLog;
        this.minX = Double.MAX_VALUE;
        this.maxX = -1.7976931348623157E308;
    }

    public void addPoint(double x, double y) {
        if (this.xLog_) {
            x = Math.log(x) * LOG10SCALE;
        }
        if (this.yLog_) {
            y = Math.log(y) * LOG10SCALE;
        }
        this.n += 1.0;
        this.sX += x;
        this.sY += y;
        this.sXX += x * x;
        this.sYY += y * y;
        this.sXY += x * y;
        if (x < this.minX) {
            this.minX = x;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
    }

    public double[] getLinearCoefficients() {
        double s2x = this.n * this.sXX - this.sX * this.sX;
        double c = (this.sXX * this.sY - this.sX * this.sXY) / s2x;
        double m = (this.n * this.sXY - this.sX * this.sY) / s2x;
        return new double[]{c, m};
    }

    public double getCorrelation() {
        double s2x = this.n * this.sXX - this.sX * this.sX;
        double s2y = this.n * this.sYY - this.sY * this.sY;
        return (this.n * this.sXY - this.sX * this.sY) / Math.sqrt(s2x * s2y);
    }

    public double[] linearRegressionLine() {
        double[] coeffs = this.getLinearCoefficients();
        double c = coeffs[0];
        double m = coeffs[1];
        double xlo = this.minX;
        double ylo = m * this.minX + c;
        double xhi = this.maxX;
        double yhi = m * this.maxX + c;
        if (this.xLog_) {
            xlo = Math.pow(10.0, xlo);
            xhi = Math.pow(10.0, xhi);
        }
        if (this.yLog_) {
            ylo = Math.pow(10.0, ylo);
            yhi = Math.pow(10.0, yhi);
        }
        return new double[]{xlo, ylo, xhi, yhi};
    }
}

