/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.logging.Logger;
import uk.ac.starlink.util.SplitCollector;
import uk.ac.starlink.util.SplitPolicy;
import uk.ac.starlink.util.SplitProcessor;
import uk.ac.starlink.util.Splittable;

public abstract class SplitRunner<S extends Splittable<S>> {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2");
    private static final SplitPolicy DFLT_POLICY = SplitRunner.createDefaultPolicy();

    public abstract <A> A collect(SplitCollector<S, A> var1, Supplier<S> var2);

    public abstract <A> A collectPool(SplitCollector<S, A> var1, Supplier<S> var2);

    public abstract boolean willAttemptSplit(S var1);

    public static <S extends Splittable<S>> SplitRunner<S> createDefaultRunner() {
        return SplitRunner.createStandardRunner(DFLT_POLICY);
    }

    public static <S extends Splittable<S>> SplitRunner<S> createStandardRunner(final SplitPolicy policy) {
        return policy.getForkJoinPool().getParallelism() > 1 ? new PoolSwitchRunner<S>(SplitProcessor.createBasicParallelProcessor((SplitPolicy)policy), SplitProcessor.createPoolParallelProcessor((SplitPolicy)policy)){

            @Override
            public boolean willAttemptSplit(S content) {
                return policy.willAttemptSplit(content);
            }

            public String toString() {
                return "Standard[" + policy + "]";
            }
        } : SplitRunner.createSequentialRunner();
    }

    public static <S extends Splittable<S>> SplitRunner<S> createBenchRunner() {
        final SplitPolicy policy = DFLT_POLICY;
        return new BenchRunner<S>(Arrays.asList(SplitProcessor.createSequentialProcessor(), SplitProcessor.createBasicParallelProcessor((SplitPolicy)policy), SplitProcessor.createPoolParallelProcessor((SplitPolicy)policy))){

            @Override
            public boolean willAttemptSplit(S content) {
                return policy.willAttemptSplit(content);
            }

            public String toString() {
                return "Bench[" + policy + "]";
            }
        };
    }

    public static <S extends Splittable<S>> SplitRunner<S> createSequentialRunner() {
        SplitProcessor seqProc = SplitProcessor.createSequentialProcessor();
        return new PoolSwitchRunner<S>(seqProc, seqProc){

            @Override
            public boolean willAttemptSplit(S content) {
                return false;
            }

            public String toString() {
                return "Sequential";
            }
        };
    }

    private static SplitPolicy createDefaultPolicy() {
        Supplier<ForkJoinPool> fjPoolSupplier = () -> ForkJoinPool.commonPool();
        int minTaskSize = 100000;
        short maxTasksPerCore = 8;
        SplitPolicy policy = new SplitPolicy(fjPoolSupplier, minTaskSize, maxTasksPerCore);
        logger_.info("Default concurrency: " + policy);
        return policy;
    }

    private static abstract class BenchRunner<S extends Splittable<S>>
    extends SplitRunner<S> {
        private final List<SplitProcessor<S>> procs_;

        BenchRunner(List<SplitProcessor<S>> procs) {
            this.procs_ = procs;
        }

        @Override
        public <A> A collect(SplitCollector<S, A> collector, Supplier<S> splitSupplier) {
            StringBuffer tbuf = new StringBuffer();
            Object result = null;
            int millis0 = -1;
            for (SplitProcessor<S> proc : this.procs_) {
                long t0 = System.nanoTime();
                result = proc.collect(collector, (Splittable)splitSupplier.get());
                int millis = (int)((System.nanoTime() - t0) / 1000000L);
                tbuf.append("   ").append(proc).append(":").append(String.format("%5d", millis));
                if (millis0 < 0) {
                    millis0 = millis;
                    continue;
                }
                tbuf.append(" (").append(millis > 0 ? String.format("%4.1f", (double)millis0 / (double)millis) : "    ").append(")");
            }
            System.out.println(tbuf.toString());
            return (A)result;
        }

        @Override
        public <A> A collectPool(SplitCollector<S, A> collector, Supplier<S> splitSupplier) {
            return this.collect(collector, splitSupplier);
        }
    }

    private static abstract class PoolSwitchRunner<S extends Splittable<S>>
    extends SplitRunner<S> {
        private final SplitProcessor<S> procNoPool_;
        private final SplitProcessor<S> procWithPool_;

        PoolSwitchRunner(SplitProcessor<S> procNoPool, SplitProcessor<S> procWithPool) {
            this.procNoPool_ = procNoPool;
            this.procWithPool_ = procWithPool;
        }

        @Override
        public <A> A collect(SplitCollector<S, A> collector, Supplier<S> splitSupplier) {
            return (A)this.procNoPool_.collect(collector, (Splittable)splitSupplier.get());
        }

        @Override
        public <A> A collectPool(SplitCollector<S, A> collector, Supplier<S> splitSupplier) {
            return (A)this.procWithPool_.collect(collector, (Splittable)splitSupplier.get());
        }
    }
}

