/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.plaf.basic.BasicArrowButton;
import uk.ac.starlink.util.gui.ShrinkWrapper;

public class PaletteColorChooserPanel
extends AbstractColorChooserPanel {
    private final Map<String, Color[]> paletteMap_;
    private final JColorChooser chooser_;
    private PalettePanel ppanel_;
    private NavigateAction[] navActs_;

    public PaletteColorChooserPanel(Map<String, Color[]> paletteMap, JColorChooser chooser) {
        this.paletteMap_ = paletteMap;
        this.chooser_ = chooser;
    }

    @Override
    protected void buildChooser() {
        this.setLayout(new BorderLayout());
        this.ppanel_ = new PalettePanel(this.paletteMap_);
        this.ppanel_.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)this.ppanel_, "Center");
        Box bbox = Box.createHorizontalBox();
        this.add((Component)bbox, "South");
        bbox.add(Box.createHorizontalGlue());
        this.navActs_ = new NavigateAction[]{new NavigateAction(5), new NavigateAction(7), new NavigateAction(3), new NavigateAction(1)};
        InputMap inputMap = this.getInputMap(2);
        for (NavigateAction navAct : this.navActs_) {
            bbox.add(Box.createHorizontalStrut(5));
            bbox.add((Component)new ShrinkWrapper((Component)navAct.createButton()));
            String navKey = "Palette." + navAct.txt_;
            inputMap.put(navAct.keyStroke_, navKey);
            this.getActionMap().put(navKey, navAct);
        }
        this.ppanel_.setSelection(-1, -1);
    }

    @Override
    public String getDisplayName() {
        return "Palettes";
    }

    @Override
    public int getMnemonic() {
        return 80;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void updateChooser() {
    }

    private class PalettePanel
    extends JComponent {
        private final int np_;
        private final String[] labels_;
        private final Color[][] colors_;
        private final int ncmax_;
        private final int xPatch_ = 12;
        private final int yPatch_ = 12;
        private final int xGap_ = 4;
        private final int yGap_ = 4;
        private final Font font_;
        private final int yPatchOff_;
        private final int txtWidth_;
        private final int lineHeight_;
        private final LineMetrics lineMetrics_;
        private final Color txtColor_;
        private final Color selectColor_;
        private final Color overColor_;
        private int[] xySel_;
        private int[] xyOver_;

        PalettePanel(Map<String, Color[]> paletteMap) {
            this.np_ = paletteMap.size();
            this.labels_ = new String[this.np_];
            this.colors_ = new Color[this.np_][];
            int ip = 0;
            int ncmax = 0;
            for (Map.Entry<String, Color[]> entry : paletteMap.entrySet()) {
                this.labels_[ip] = entry.getKey() + ": ";
                this.colors_[ip] = entry.getValue();
                ncmax = Math.max(ncmax, this.colors_[ip].length);
                ++ip;
            }
            this.ncmax_ = ncmax;
            this.font_ = UIManager.getFont("Label.font");
            this.xyOver_ = new int[]{-1, -1};
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
            int txtWidth = 0;
            int txtHeight = 0;
            for (String label : this.labels_) {
                Rectangle r = this.font_.getStringBounds(label, frc).getBounds();
                txtWidth = Math.max(txtWidth, r.width);
                txtHeight = Math.max(txtHeight, r.height);
            }
            this.txtWidth_ = txtWidth;
            this.lineHeight_ = txtHeight;
            this.lineMetrics_ = this.font_.getLineMetrics(this.labels_[0], frc);
            this.yPatchOff_ = (this.lineHeight_ - 12) / 2;
            this.txtColor_ = UIManager.getColor("ColorChooser.foreground");
            this.overColor_ = UIManager.getColor("ComboBox.selectionBackground");
            this.selectColor_ = this.txtColor_;
            this.setSelection(-1, -1);
            final PalettePanel paletteComp = this;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    int[] sel = PalettePanel.this.getGridPosition(evt.getPoint());
                    int ix = sel[0];
                    int iy = sel[1];
                    if (ix >= 0 && iy >= 0) {
                        PalettePanel.this.setSelection(ix, iy);
                    }
                    paletteComp.repaint();
                }
            });
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent evt) {
                    PalettePanel.access$502(PalettePanel.this, PalettePanel.this.getGridPosition(evt.getPoint()));
                    paletteComp.repaint();
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Color color0 = g.getColor();
            Font font0 = g.getFont();
            g.setFont(this.font_);
            Insets insets = this.getInsets();
            int gy = insets.top;
            int yTxtOff = (int)this.lineMetrics_.getHeight();
            for (int ip = 0; ip < this.np_; ++ip) {
                int gx = insets.left;
                g.setColor(this.txtColor_);
                g.drawString(this.labels_[ip], gx, gy + yTxtOff);
                gx += this.txtWidth_;
                Color[] colors = this.colors_[ip];
                for (int ic = 0; ic < colors.length; ++ic) {
                    int x0 = gx += 4;
                    int y0 = gy + this.yPatchOff_;
                    int w0 = 12;
                    int h0 = 12;
                    if (ic == this.xySel_[0] && ip == this.xySel_[1]) {
                        g.setColor(this.selectColor_);
                        g.fillRect(x0 - 4, y0 - 4, w0 + 8, h0 + 8);
                    } else if (ic == this.xyOver_[0] && ip == this.xyOver_[1]) {
                        g.setColor(this.overColor_);
                        g.fillRect(x0 - 3, y0 - 3, w0 + 6, h0 + 6);
                    }
                    g.setColor(Color.GRAY);
                    g.fillRect(x0 - 1, y0 - 1, w0 + 2, h0 + 2);
                    g.setColor(colors[ic]);
                    g.fillRect(x0, y0, w0, h0);
                    gx += 16;
                }
                gy += this.lineHeight_ + 4;
            }
            g.setColor(color0);
            g.setFont(font0);
        }

        @Override
        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(this.txtWidth_ + this.ncmax_ * 20 + insets.left + insets.right, this.np_ * this.lineHeight_ + (this.np_ - 1) * 4 + insets.top + insets.bottom);
        }

        private int[] getGridPosition(Point p) {
            int[] nArray;
            int iy;
            Insets insets = this.getInsets();
            int px = p.x - insets.left - this.txtWidth_ - 4;
            int ix = px % 20 <= 12 ? px / 20 : -1;
            int py = p.y - insets.top - this.yPatchOff_;
            int n = iy = py % (this.lineHeight_ + 4) <= 12 ? py / (this.lineHeight_ + 4) : -1;
            if (iy >= 0 && iy < this.np_ && ix >= 0 && ix < this.colors_[iy].length) {
                int[] nArray2 = new int[2];
                nArray2[0] = ix;
                nArray = nArray2;
                nArray2[1] = iy;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = -1;
                nArray = nArray3;
                nArray3[1] = -1;
            }
            return nArray;
        }

        public void navigate(int dx, int dy) {
            int ix = this.xySel_[0];
            int iy = this.xySel_[1];
            if (ix >= 0 && iy >= 0) {
                int nc = this.colors_[iy].length;
                ix = (ix + dx + nc) % nc;
                iy = (iy + dy + this.np_) % this.np_;
                nc = this.colors_[iy].length;
                ix = Math.min(ix, nc - 1);
            }
            this.setSelection(ix, iy);
        }

        private void setSelection(int ix, int iy) {
            boolean hasSel;
            this.xySel_ = new int[]{ix, iy};
            boolean bl = hasSel = ix >= 0 && iy >= 0;
            if (hasSel) {
                PaletteColorChooserPanel.this.chooser_.getSelectionModel().setSelectedColor(this.colors_[iy][ix]);
            }
            if (PaletteColorChooserPanel.this.navActs_ != null) {
                for (NavigateAction act : PaletteColorChooserPanel.this.navActs_) {
                    act.setEnabled(hasSel);
                }
            }
            this.repaint();
        }

        static /* synthetic */ int[] access$502(PalettePanel x0, int[] x1) {
            x0.xyOver_ = x1;
            return x1;
        }
    }

    private class NavigateAction
    extends AbstractAction {
        private final int swingDirection_;
        private final String txt_;
        private final int dx_;
        private final int dy_;
        private final KeyStroke keyStroke_;

        NavigateAction(int swingDirection) {
            int keyEvent;
            this.swingDirection_ = swingDirection;
            switch (this.swingDirection_) {
                case 1: {
                    this.txt_ = "Up";
                    this.dx_ = 0;
                    this.dy_ = -1;
                    keyEvent = 38;
                    break;
                }
                case 5: {
                    this.txt_ = "Down";
                    this.dx_ = 0;
                    this.dy_ = 1;
                    keyEvent = 40;
                    break;
                }
                case 7: {
                    this.txt_ = "Left";
                    this.dx_ = -1;
                    this.dy_ = 0;
                    keyEvent = 37;
                    break;
                }
                case 3: {
                    this.txt_ = "Right";
                    this.dx_ = 1;
                    this.dy_ = 0;
                    keyEvent = 39;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.keyStroke_ = KeyStroke.getKeyStroke(keyEvent, 0);
            this.putValue("Name", this.txt_);
            this.putValue("ShortDescription", "Move " + this.txt_ + " in palette grid");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PaletteColorChooserPanel.this.ppanel_.navigate(this.dx_, this.dy_);
            PaletteColorChooserPanel.this.ppanel_.repaint();
        }

        public JButton createButton() {
            BasicArrowButton button = new BasicArrowButton(this.swingDirection_);
            button.setAction(this);
            return button;
        }
    }
}

