/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import uk.ac.starlink.ttools.plot2.config.RangeSlider;

public class RangeSliderUtil {
    private static boolean jideBroken_;
    private static final Logger logger_;

    private RangeSliderUtil() {
    }

    public static JSlider createRangeSlider(int imin, int imax) {
        JSlider slider = RangeSliderUtil.createUnconfiguredRangeSlider(imin, imax);
        RangeSliderUtil.setSliderRange(slider, imin, imax);
        return slider;
    }

    private static JSlider createUnconfiguredRangeSlider(int imin, int imax) {
        if (!jideBroken_) {
            try {
                return new JideRangeSlider(imin, imax);
            }
            catch (Throwable e) {
                jideBroken_ = true;
                logger_.log(Level.INFO, "JIDE-OSS RangeSlider unavailable, using fallback (" + e + ")", e);
            }
        }
        return new RangeSlider(imin, imax);
    }

    public static int[] getSliderRange(JSlider slider) {
        BoundedRangeModel model = slider.getModel();
        int ilo = model.getValue();
        int ihi = ilo + model.getExtent();
        return new int[]{ilo, ihi};
    }

    public static void setSliderRange(JSlider slider, int ilo, int ihi) {
        BoundedRangeModel model = slider.getModel();
        model.setExtent(0);
        model.setValue(ilo);
        model.setExtent(ihi - ilo);
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.config");
    }

    private static class JideRangeSlider
    extends com.jidesoft.swing.RangeSlider {
        JideRangeSlider(int imin, int imax) {
            super(imin, imax);
        }

        public void updateUI() {
            if (UIDefaultsLookup.get((Object)this.getActualUIClassID()) == null) {
                LookAndFeelFactory.installJideExtension();
            }
            try {
                Class<?> uiClass = Class.forName(UIManager.getString(this.getActualUIClassID()));
                Class<JComponent> acClass = JComponent.class;
                Method m = uiClass.getMethod("createUI", acClass);
                if (m != null) {
                    Object uiObject = m.invoke(null, new Object[]{this});
                    this.setUI((ComponentUI)uiObject);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString(), e);
            }
        }
    }
}

