/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.io.IOException;
import java.util.function.Function;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.RowData;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.StorageType;
import uk.ac.starlink.ttools.plot2.data.UserDataReader;

@Equality
public class CoordSpec {
    private final DataSpec dataSpec_;
    private final int icoord_;
    private final StarTable table_;
    private final String coordId_;
    private final StorageType storageType_;
    private final Function<Object[], ?> inputStorage_;

    public CoordSpec(DataSpec dataSpec, int icoord) {
        this.dataSpec_ = dataSpec;
        this.icoord_ = icoord;
        this.table_ = dataSpec.getSourceTable();
        this.coordId_ = dataSpec.getCoordId(icoord);
        Coord coord = dataSpec.getCoord(icoord);
        this.storageType_ = coord.getStorageType();
        ValueInfo[] infos = dataSpec.getUserCoordInfos(icoord);
        DomainMapper[] dms = dataSpec.getUserCoordMappers(icoord);
        this.inputStorage_ = coord.inputStorage(infos, dms);
    }

    public StarTable getTable() {
        return this.table_;
    }

    public StorageType getStorageType() {
        return this.storageType_;
    }

    public String getCoordId() {
        return this.coordId_;
    }

    public Reader valueReader(RowData rdata) {
        UserDataReader dataReader = this.dataSpec_.createUserDataReader();
        return irow -> {
            Object[] userCoords = dataReader.getUserCoordValues(rdata, irow, this.icoord_);
            Object value = this.inputStorage_.apply(userCoords);
            assert (value != null);
            return value;
        };
    }

    public boolean equals(Object o) {
        if (o instanceof CoordSpec) {
            CoordSpec other = (CoordSpec)o;
            return other.table_.equals(this.table_) && other.coordId_.equals(this.coordId_);
        }
        return false;
    }

    public int hashCode() {
        return this.table_.hashCode() * 37 + this.coordId_.hashCode();
    }

    public String toString() {
        return String.valueOf(this.coordId_);
    }

    @FunctionalInterface
    public static interface Reader {
        public Object readValue(long var1) throws IOException;
    }
}

