/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.starlink.ttools.plot2.data.CachedColumn;
import uk.ac.starlink.ttools.plot2.data.CachedColumnFactory;
import uk.ac.starlink.ttools.plot2.data.CachedReader;
import uk.ac.starlink.ttools.plot2.data.StorageType;
import uk.ac.starlink.util.ByteList;
import uk.ac.starlink.util.DoubleList;
import uk.ac.starlink.util.FloatList;
import uk.ac.starlink.util.IntList;
import uk.ac.starlink.util.LongList;
import uk.ac.starlink.util.ShortList;

public class MemoryColumnFactory
implements CachedColumnFactory {
    private static final Map<StorageType, ColumnCreator> creatorMap_ = MemoryColumnFactory.createCreatorMap();

    @Override
    public CachedColumn createColumn(StorageType type, long nrow) {
        return creatorMap_.get((Object)type).createColumn(nrow);
    }

    private static Map<StorageType, ColumnCreator> createCreatorMap() {
        HashMap<StorageType, ColumnCreator> map = new HashMap<StorageType, ColumnCreator>();
        map.put(StorageType.BOOLEAN, new ColumnCreator(){

            @Override
            public CachedColumn createColumn(long nrow) {
                return new BitSetColumn(nrow);
            }
        });
        map.put(StorageType.DOUBLE, new ColumnCreator(){

            @Override
            public CachedColumn createColumn(long nrow) {
                return nrow >= 0L ? new FixedDoubleColumn(nrow) : new UnknownDoubleColumn();
            }
        });
        map.put(StorageType.FLOAT, new ColumnCreator(){

            @Override
            public CachedColumn createColumn(long nrow) {
                return nrow >= 0L ? new FixedFloatColumn(nrow) : new UnknownFloatColumn();
            }
        });
        map.put(StorageType.LONG, new ColumnCreator(){

            @Override
            public CachedColumn createColumn(long nrow) {
                return nrow >= 0L ? new FixedLongColumn(nrow) : new UnknownLongColumn();
            }
        });
        map.put(StorageType.INT, new ColumnCreator(){

            @Override
            public CachedColumn createColumn(long nrow) {
                return nrow >= 0L ? new FixedIntColumn(nrow) : new UnknownIntColumn();
            }
        });
        map.put(StorageType.SHORT, new ColumnCreator(){

            @Override
            public CachedColumn createColumn(long nrow) {
                return nrow >= 0L ? new FixedShortColumn(nrow) : new UnknownShortColumn();
            }
        });
        map.put(StorageType.BYTE, new ColumnCreator(){

            @Override
            public CachedColumn createColumn(long nrow) {
                return nrow >= 0L ? new FixedByteColumn(nrow) : new UnknownByteColumn();
            }
        });
        map.put(StorageType.STRING, new ColumnCreator(){

            @Override
            public CachedColumn createColumn(long nrow) {
                return nrow >= 0L ? new FixedObjectColumn<String>(String.class, nrow) : new UnknownObjectColumn<String>(String.class);
            }
        });
        map.put(StorageType.FLOAT_ARRAY, new ColumnCreator(){

            @Override
            public CachedColumn createColumn(long nrow) {
                return nrow >= 0L ? new FixedObjectColumn<float[]>(float[].class, nrow) : new UnknownObjectColumn<float[]>(float[].class);
            }
        });
        map.put(StorageType.DOUBLE_ARRAY, new ColumnCreator(){

            @Override
            public CachedColumn createColumn(long nrow) {
                return nrow >= 0L ? new FixedObjectColumn<double[]>(double[].class, nrow) : new UnknownObjectColumn<double[]>(double[].class);
            }
        });
        map.put(StorageType.INT3, new ColumnCreator(){

            @Override
            public CachedColumn createColumn(long nrow) {
                return nrow >= 0L ? new FixedIntArrayColumn(3, nrow){

                    @Override
                    protected CachedReader createReader(int[] data) {
                        return new IntReader3(data);
                    }
                } : new UnknownIntArrayColumn(3){

                    @Override
                    protected CachedReader createReader(int[] data) {
                        return new IntReader3(data);
                    }
                };
            }
        });
        map.put(StorageType.DOUBLE3, new ColumnCreator(){

            @Override
            public CachedColumn createColumn(long nrow) {
                return nrow >= 0L ? new FixedDoubleArrayColumn(3, nrow){

                    @Override
                    protected CachedReader createReader(double[] data) {
                        return new DoubleReader3(data);
                    }
                } : new UnknownDoubleArrayColumn(3){

                    @Override
                    protected CachedReader createReader(double[] data) {
                        return new DoubleReader3(data);
                    }
                };
            }
        });
        map.put(StorageType.FLOAT3, new ColumnCreator(){

            @Override
            public CachedColumn createColumn(long nrow) {
                return nrow >= 0L ? new FixedFloatArrayColumn(3, nrow){

                    @Override
                    protected CachedReader createReader(float[] data) {
                        return new FloatReader3(data);
                    }
                } : new UnknownFloatArrayColumn(3){

                    @Override
                    protected CachedReader createReader(float[] data) {
                        return new FloatReader3(data);
                    }
                };
            }
        });
        assert (map.keySet().containsAll(Arrays.asList(StorageType.values())));
        return Collections.unmodifiableMap(map);
    }

    private static double toDouble(Object obj) {
        return ((Number)obj).doubleValue();
    }

    private static float toFloat(Object obj) {
        return ((Number)obj).floatValue();
    }

    private static long toLong(Object obj) {
        return ((Number)obj).longValue();
    }

    private static int toInt(Object obj) {
        return ((Number)obj).intValue();
    }

    private static short toShort(Object obj) {
        return ((Number)obj).shortValue();
    }

    private static byte toByte(Object obj) {
        return ((Number)obj).byteValue();
    }

    private static boolean toBoolean(Object obj) {
        return (Boolean)obj;
    }

    private static String toString(Object obj) {
        return (String)obj;
    }

    private static class IntReader3
    implements CachedReader {
        private final int[] data_;
        private final int[] v3_;

        IntReader3(int[] data) {
            this.data_ = data;
            this.v3_ = new int[3];
            if (data.length % 3 != 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public Object getObjectValue(long ix) {
            int ipos = (int)ix * 3;
            this.v3_[0] = this.data_[ipos++];
            this.v3_[1] = this.data_[ipos++];
            this.v3_[2] = this.data_[ipos];
            return this.v3_;
        }

        @Override
        public double getDoubleValue(long ix) {
            return Double.NaN;
        }

        @Override
        public int getIntValue(long ix) {
            return Integer.MIN_VALUE;
        }

        @Override
        public long getLongValue(long ix) {
            return Long.MIN_VALUE;
        }

        @Override
        public boolean getBooleanValue(long ix) {
            return false;
        }
    }

    private static class FloatReader3
    implements CachedReader {
        private final float[] data_;
        private final float[] v3_;

        FloatReader3(float[] data) {
            this.data_ = data;
            this.v3_ = new float[3];
            if (data.length % 3 != 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public Object getObjectValue(long ix) {
            int ipos = (int)ix * 3;
            this.v3_[0] = this.data_[ipos++];
            this.v3_[1] = this.data_[ipos++];
            this.v3_[2] = this.data_[ipos];
            return this.v3_;
        }

        @Override
        public double getDoubleValue(long ix) {
            return Double.NaN;
        }

        @Override
        public int getIntValue(long ix) {
            return Integer.MIN_VALUE;
        }

        @Override
        public long getLongValue(long ix) {
            return Long.MIN_VALUE;
        }

        @Override
        public boolean getBooleanValue(long ix) {
            return false;
        }
    }

    private static class DoubleReader3
    implements CachedReader {
        private final double[] data_;
        private final double[] v3_;

        DoubleReader3(double[] data) {
            this.data_ = data;
            this.v3_ = new double[3];
            if (data.length % 3 != 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public Object getObjectValue(long ix) {
            int ipos = (int)ix * 3;
            this.v3_[0] = this.data_[ipos++];
            this.v3_[1] = this.data_[ipos++];
            this.v3_[2] = this.data_[ipos];
            return this.v3_;
        }

        @Override
        public double getDoubleValue(long ix) {
            return Double.NaN;
        }

        @Override
        public int getIntValue(long ix) {
            return Integer.MIN_VALUE;
        }

        @Override
        public long getLongValue(long ix) {
            return Long.MIN_VALUE;
        }

        @Override
        public boolean getBooleanValue(long ix) {
            return false;
        }
    }

    private static class ByteArrayReader
    implements CachedReader {
        private final byte[] data_;

        ByteArrayReader(byte[] data) {
            this.data_ = data;
        }

        @Override
        public Object getObjectValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public double getDoubleValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public int getIntValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public long getLongValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public boolean getBooleanValue(long ix) {
            return false;
        }
    }

    private static class ShortArrayReader
    implements CachedReader {
        private final short[] data_;

        ShortArrayReader(short[] data) {
            this.data_ = data;
        }

        @Override
        public Object getObjectValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public double getDoubleValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public int getIntValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public long getLongValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public boolean getBooleanValue(long ix) {
            return false;
        }
    }

    private static class IntArrayReader
    implements CachedReader {
        private final int[] data_;

        IntArrayReader(int[] data) {
            this.data_ = data;
        }

        @Override
        public Object getObjectValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public double getDoubleValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public int getIntValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public long getLongValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public boolean getBooleanValue(long ix) {
            return false;
        }
    }

    private static class LongArrayReader
    implements CachedReader {
        private final long[] data_;

        LongArrayReader(long[] data) {
            this.data_ = data;
        }

        @Override
        public Object getObjectValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public double getDoubleValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public int getIntValue(long ix) {
            return (int)this.data_[(int)ix];
        }

        @Override
        public long getLongValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public boolean getBooleanValue(long ix) {
            return false;
        }
    }

    private static class FloatArrayReader
    implements CachedReader {
        private final float[] data_;

        FloatArrayReader(float[] data) {
            this.data_ = data;
        }

        @Override
        public Object getObjectValue(long ix) {
            return Float.valueOf(this.data_[(int)ix]);
        }

        @Override
        public double getDoubleValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public int getIntValue(long ix) {
            return (int)this.data_[(int)ix];
        }

        @Override
        public long getLongValue(long ix) {
            return (long)this.data_[(int)ix];
        }

        @Override
        public boolean getBooleanValue(long ix) {
            return false;
        }
    }

    private static class DoubleArrayReader
    implements CachedReader {
        private final double[] data_;

        DoubleArrayReader(double[] data) {
            this.data_ = data;
        }

        @Override
        public Object getObjectValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public double getDoubleValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public int getIntValue(long ix) {
            return (int)this.data_[(int)ix];
        }

        @Override
        public long getLongValue(long ix) {
            return (long)this.data_[(int)ix];
        }

        @Override
        public boolean getBooleanValue(long ix) {
            return false;
        }
    }

    private static class ObjectArrayReader<T>
    implements CachedReader {
        private final T[] data_;

        public ObjectArrayReader(T[] data) {
            this.data_ = data;
        }

        public T getObjectValue(long ix) {
            return this.data_[(int)ix];
        }

        @Override
        public double getDoubleValue(long ix) {
            return Double.NaN;
        }

        @Override
        public int getIntValue(long ix) {
            return Integer.MIN_VALUE;
        }

        @Override
        public long getLongValue(long ix) {
            return Long.MIN_VALUE;
        }

        @Override
        public boolean getBooleanValue(long ix) {
            return false;
        }
    }

    private static class BitSetReader
    implements CachedReader {
        private final BitSet mask_;

        public BitSetReader(BitSet mask) {
            this.mask_ = mask;
        }

        @Override
        public Object getObjectValue(long ix) {
            return this.mask_.get((int)ix);
        }

        @Override
        public boolean getBooleanValue(long ix) {
            return this.mask_.get((int)ix);
        }

        @Override
        public double getDoubleValue(long ix) {
            return Double.NaN;
        }

        @Override
        public int getIntValue(long ix) {
            return Integer.MIN_VALUE;
        }

        @Override
        public long getLongValue(long ix) {
            return Long.MIN_VALUE;
        }
    }

    private static abstract class UnknownIntArrayColumn
    implements CachedColumn {
        private final int ncol_;
        private IntList list_;
        private int[] data_;

        UnknownIntArrayColumn(int ncol) {
            this.ncol_ = ncol;
            this.list_ = new IntList();
        }

        @Override
        public void add(Object value) {
            int[] ival = (int[])value;
            for (int ic = 0; ic < this.ncol_; ++ic) {
                this.list_.add(ival[ic]);
            }
        }

        @Override
        public void endAdd() {
            this.data_ = this.list_.toIntArray();
            this.list_ = null;
        }

        @Override
        public long getRowCount() {
            return (this.data_ == null ? this.list_.size() : this.data_.length) / this.ncol_;
        }

        @Override
        public CachedReader createReader() {
            return this.createReader(this.data_);
        }

        protected abstract CachedReader createReader(int[] var1);
    }

    private static abstract class UnknownFloatArrayColumn
    implements CachedColumn {
        private final int ncol_;
        private FloatList list_;
        private float[] data_;

        UnknownFloatArrayColumn(int ncol) {
            this.ncol_ = ncol;
            this.list_ = new FloatList();
        }

        @Override
        public void add(Object value) {
            float[] fval = (float[])value;
            for (int ic = 0; ic < this.ncol_; ++ic) {
                this.list_.add(fval[ic]);
            }
        }

        @Override
        public void endAdd() {
            this.data_ = this.list_.toFloatArray();
            this.list_ = null;
        }

        @Override
        public long getRowCount() {
            return (this.data_ == null ? this.list_.size() : this.data_.length) / this.ncol_;
        }

        @Override
        public CachedReader createReader() {
            return this.createReader(this.data_);
        }

        protected abstract CachedReader createReader(float[] var1);
    }

    private static abstract class UnknownDoubleArrayColumn
    implements CachedColumn {
        private final int ncol_;
        private DoubleList list_;
        private double[] data_;

        UnknownDoubleArrayColumn(int ncol) {
            this.ncol_ = ncol;
            this.list_ = new DoubleList();
        }

        @Override
        public void add(Object value) {
            double[] dval = (double[])value;
            for (int ic = 0; ic < this.ncol_; ++ic) {
                this.list_.add(dval[ic]);
            }
        }

        @Override
        public void endAdd() {
            this.data_ = this.list_.toDoubleArray();
            this.list_ = null;
        }

        @Override
        public long getRowCount() {
            return (this.data_ == null ? this.list_.size() : this.data_.length) / this.ncol_;
        }

        @Override
        public CachedReader createReader() {
            return this.createReader(this.data_);
        }

        protected abstract CachedReader createReader(double[] var1);
    }

    private static class UnknownByteColumn
    implements CachedColumn {
        private ByteList list_ = new ByteList();
        private byte[] data_;

        UnknownByteColumn() {
        }

        @Override
        public void add(Object value) {
            this.list_.add(MemoryColumnFactory.toByte(value));
        }

        @Override
        public void endAdd() {
            this.data_ = this.list_.toByteArray();
            this.list_ = null;
        }

        @Override
        public long getRowCount() {
            return this.data_ == null ? (long)this.list_.size() : (long)this.data_.length;
        }

        @Override
        public CachedReader createReader() {
            return new ByteArrayReader(this.data_);
        }
    }

    private static class UnknownShortColumn
    implements CachedColumn {
        private ShortList list_ = new ShortList();
        private short[] data_;

        UnknownShortColumn() {
        }

        @Override
        public void add(Object value) {
            this.list_.add(MemoryColumnFactory.toShort(value));
        }

        @Override
        public void endAdd() {
            this.data_ = this.list_.toShortArray();
            this.list_ = null;
        }

        @Override
        public long getRowCount() {
            return this.data_ == null ? (long)this.list_.size() : (long)this.data_.length;
        }

        @Override
        public CachedReader createReader() {
            return new ShortArrayReader(this.data_);
        }
    }

    private static class UnknownIntColumn
    implements CachedColumn {
        private IntList list_ = new IntList();
        private int[] data_;

        UnknownIntColumn() {
        }

        @Override
        public void add(Object value) {
            this.list_.add(MemoryColumnFactory.toInt(value));
        }

        @Override
        public void endAdd() {
            this.data_ = this.list_.toIntArray();
            this.list_ = null;
        }

        @Override
        public long getRowCount() {
            return this.data_ == null ? (long)this.list_.size() : (long)this.data_.length;
        }

        @Override
        public CachedReader createReader() {
            return new IntArrayReader(this.data_);
        }
    }

    private static class UnknownLongColumn
    implements CachedColumn {
        private LongList list_ = new LongList();
        private long[] data_;

        UnknownLongColumn() {
        }

        @Override
        public void add(Object value) {
            this.list_.add(MemoryColumnFactory.toLong(value));
        }

        @Override
        public void endAdd() {
            this.data_ = this.list_.toLongArray();
            this.list_ = null;
        }

        @Override
        public long getRowCount() {
            return this.data_ == null ? (long)this.list_.size() : (long)this.data_.length;
        }

        @Override
        public CachedReader createReader() {
            return new LongArrayReader(this.data_);
        }
    }

    private static class UnknownFloatColumn
    implements CachedColumn {
        private FloatList list_ = new FloatList();
        private float[] data_;

        UnknownFloatColumn() {
        }

        @Override
        public void add(Object value) {
            this.list_.add(MemoryColumnFactory.toFloat(value));
        }

        @Override
        public void endAdd() {
            this.data_ = this.list_.toFloatArray();
            this.list_ = null;
        }

        @Override
        public long getRowCount() {
            return this.data_ == null ? (long)this.list_.size() : (long)this.data_.length;
        }

        @Override
        public CachedReader createReader() {
            return new FloatArrayReader(this.data_);
        }
    }

    private static class UnknownDoubleColumn
    implements CachedColumn {
        private DoubleList list_ = new DoubleList();
        private double[] data_;

        UnknownDoubleColumn() {
        }

        @Override
        public void add(Object value) {
            this.list_.add(MemoryColumnFactory.toDouble(value));
        }

        @Override
        public void endAdd() {
            this.data_ = this.list_.toDoubleArray();
            this.list_ = null;
        }

        @Override
        public long getRowCount() {
            return this.data_ == null ? (long)this.list_.size() : (long)this.data_.length;
        }

        @Override
        public CachedReader createReader() {
            return new DoubleArrayReader(this.data_);
        }
    }

    private static class UnknownObjectColumn<T>
    implements CachedColumn {
        private final Class<T> clazz_;
        private final T[] zArray_;
        private List<T> list_;
        private T[] data_;

        UnknownObjectColumn(Class<T> clazz) {
            this.clazz_ = clazz;
            Object[] zArray = (Object[])Array.newInstance(clazz, 0);
            this.zArray_ = zArray;
            this.list_ = new ArrayList<T>();
        }

        @Override
        public void add(Object value) {
            this.list_.add(this.clazz_.cast(value));
        }

        @Override
        public void endAdd() {
            this.data_ = this.list_.toArray(this.zArray_);
            this.list_ = null;
        }

        @Override
        public long getRowCount() {
            return this.data_ == null ? (long)this.list_.size() : (long)this.data_.length;
        }

        @Override
        public CachedReader createReader() {
            return new ObjectArrayReader<T>(this.data_);
        }
    }

    private static abstract class FixedIntArrayColumn
    implements CachedColumn {
        private final int ncol_;
        private final int nrow_;
        private final int[] data_;
        private int ipos_;

        FixedIntArrayColumn(int ncol, long nrow) {
            if (nrow * (long)ncol > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Too long " + nrow);
            }
            this.ncol_ = ncol;
            this.nrow_ = (int)nrow;
            this.data_ = new int[this.nrow_ * this.ncol_];
        }

        @Override
        public void add(Object value) {
            int[] ival = (int[])value;
            for (int ic = 0; ic < this.ncol_; ++ic) {
                this.data_[this.ipos_++] = ival[ic];
            }
        }

        @Override
        public void endAdd() {
        }

        @Override
        public long getRowCount() {
            return this.ipos_ / this.ncol_;
        }

        @Override
        public CachedReader createReader() {
            return this.createReader(this.data_);
        }

        protected abstract CachedReader createReader(int[] var1);
    }

    private static abstract class FixedFloatArrayColumn
    implements CachedColumn {
        private final int ncol_;
        private final int nrow_;
        private final float[] data_;
        private int ipos_;

        FixedFloatArrayColumn(int ncol, long nrow) {
            if (nrow * (long)ncol > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Too long " + nrow);
            }
            this.ncol_ = ncol;
            this.nrow_ = (int)nrow;
            this.data_ = new float[this.nrow_ * this.ncol_];
        }

        @Override
        public void add(Object value) {
            float[] fval = (float[])value;
            for (int ic = 0; ic < this.ncol_; ++ic) {
                this.data_[this.ipos_++] = fval[ic];
            }
        }

        @Override
        public void endAdd() {
        }

        @Override
        public long getRowCount() {
            return this.ipos_ / this.ncol_;
        }

        @Override
        public CachedReader createReader() {
            return this.createReader(this.data_);
        }

        protected abstract CachedReader createReader(float[] var1);
    }

    private static abstract class FixedDoubleArrayColumn
    implements CachedColumn {
        private final int ncol_;
        private final int nrow_;
        private final double[] data_;
        private int ipos_;

        FixedDoubleArrayColumn(int ncol, long nrow) {
            if (nrow * (long)ncol > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Too long " + nrow);
            }
            this.ncol_ = ncol;
            this.nrow_ = (int)nrow;
            this.data_ = new double[this.nrow_ * this.ncol_];
        }

        @Override
        public void add(Object value) {
            double[] dval = (double[])value;
            for (int ic = 0; ic < this.ncol_; ++ic) {
                this.data_[this.ipos_++] = dval[ic];
            }
        }

        @Override
        public void endAdd() {
        }

        @Override
        public long getRowCount() {
            return this.ipos_ / this.ncol_;
        }

        @Override
        public CachedReader createReader() {
            return this.createReader(this.data_);
        }

        protected abstract CachedReader createReader(double[] var1);
    }

    private static class FixedByteColumn
    implements CachedColumn {
        private final int nrow_;
        private final byte[] data_;
        private int irow_;

        FixedByteColumn(long nrow) {
            if (nrow > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Too long " + nrow);
            }
            this.nrow_ = (int)nrow;
            this.data_ = new byte[this.nrow_];
        }

        @Override
        public void add(Object value) {
            this.data_[this.irow_++] = MemoryColumnFactory.toByte(value);
        }

        @Override
        public void endAdd() {
        }

        @Override
        public long getRowCount() {
            return this.irow_;
        }

        @Override
        public CachedReader createReader() {
            return new ByteArrayReader(this.data_);
        }
    }

    private static class FixedShortColumn
    implements CachedColumn {
        private final int nrow_;
        private final short[] data_;
        private int irow_;

        FixedShortColumn(long nrow) {
            if (nrow > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Too long " + nrow);
            }
            this.nrow_ = (int)nrow;
            this.data_ = new short[this.nrow_];
        }

        @Override
        public void add(Object value) {
            this.data_[this.irow_++] = MemoryColumnFactory.toShort(value);
        }

        @Override
        public void endAdd() {
        }

        @Override
        public long getRowCount() {
            return this.irow_;
        }

        @Override
        public CachedReader createReader() {
            return new ShortArrayReader(this.data_);
        }
    }

    private static class FixedIntColumn
    implements CachedColumn {
        private final int nrow_;
        private final int[] data_;
        private int irow_;

        FixedIntColumn(long nrow) {
            if (nrow > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Too long " + nrow);
            }
            this.nrow_ = (int)nrow;
            this.data_ = new int[this.nrow_];
        }

        @Override
        public void add(Object value) {
            this.data_[this.irow_++] = MemoryColumnFactory.toInt(value);
        }

        @Override
        public void endAdd() {
        }

        @Override
        public long getRowCount() {
            return this.irow_;
        }

        @Override
        public CachedReader createReader() {
            return new IntArrayReader(this.data_);
        }
    }

    private static class FixedLongColumn
    implements CachedColumn {
        private final int nrow_;
        private final long[] data_;
        private int irow_;

        FixedLongColumn(long nrow) {
            if (nrow > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Too long " + nrow);
            }
            this.nrow_ = (int)nrow;
            this.data_ = new long[this.nrow_];
        }

        @Override
        public void add(Object value) {
            this.data_[this.irow_++] = MemoryColumnFactory.toLong(value);
        }

        @Override
        public void endAdd() {
        }

        @Override
        public long getRowCount() {
            return this.irow_;
        }

        @Override
        public CachedReader createReader() {
            return new LongArrayReader(this.data_);
        }
    }

    private static class FixedFloatColumn
    implements CachedColumn {
        private final int nrow_;
        private final float[] data_;
        private int irow_;

        FixedFloatColumn(long nrow) {
            if (nrow > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Too long " + nrow);
            }
            this.nrow_ = (int)nrow;
            this.data_ = new float[this.nrow_];
        }

        @Override
        public void add(Object value) {
            this.data_[this.irow_++] = MemoryColumnFactory.toFloat(value);
        }

        @Override
        public void endAdd() {
        }

        @Override
        public long getRowCount() {
            return this.irow_;
        }

        @Override
        public CachedReader createReader() {
            return new FloatArrayReader(this.data_);
        }
    }

    private static class FixedDoubleColumn
    implements CachedColumn {
        private final int nrow_;
        private final double[] data_;
        private int irow_;

        FixedDoubleColumn(long nrow) {
            if (nrow > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Too long " + nrow);
            }
            this.nrow_ = (int)nrow;
            this.data_ = new double[this.nrow_];
        }

        @Override
        public void add(Object value) {
            this.data_[this.irow_++] = MemoryColumnFactory.toDouble(value);
        }

        @Override
        public void endAdd() {
        }

        @Override
        public long getRowCount() {
            return this.irow_;
        }

        @Override
        public CachedReader createReader() {
            return new DoubleArrayReader(this.data_);
        }
    }

    private static class FixedObjectColumn<T>
    implements CachedColumn {
        private final Class<T> clazz_;
        private final int nrow_;
        private final T[] data_;
        private int irow_;

        FixedObjectColumn(Class<T> clazz, long nrow) {
            this.clazz_ = clazz;
            if (nrow > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Too long " + nrow);
            }
            this.nrow_ = (int)nrow;
            Object[] data = (Object[])Array.newInstance(clazz, this.nrow_);
            this.data_ = data;
        }

        @Override
        public void add(Object value) {
            this.data_[this.irow_++] = this.clazz_.cast(value);
        }

        @Override
        public void endAdd() {
        }

        @Override
        public long getRowCount() {
            return this.irow_;
        }

        @Override
        public CachedReader createReader() {
            return new ObjectArrayReader<T>(this.data_);
        }
    }

    private static class BitSetColumn
    implements CachedColumn {
        private final BitSet mask_;
        private int irow_;

        BitSetColumn(long nrow) {
            if (nrow > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Too long " + nrow);
            }
            this.mask_ = nrow >= 0L ? new BitSet((int)nrow) : new BitSet();
        }

        @Override
        public void add(Object value) {
            this.mask_.set(this.irow_++, MemoryColumnFactory.toBoolean(value));
        }

        @Override
        public void endAdd() {
        }

        @Override
        public long getRowCount() {
            return this.irow_;
        }

        @Override
        public CachedReader createReader() {
            return new BitSetReader(this.mask_);
        }
    }

    private static interface ColumnCreator {
        public CachedColumn createColumn(long var1);
    }
}

