/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import uk.ac.starlink.ttools.plot2.CoordSequence;
import uk.ac.starlink.ttools.plot2.Ranger;
import uk.ac.starlink.ttools.plot2.SplitRunner;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.util.SplitCollector;

public class TupleRunner
extends SplitRunner<TupleSequence> {
    private final SplitRunner<TupleSequence> runner_;
    private final SplitRunner<CoordSequence> coordRunner_;
    public static final TupleRunner DEFAULT = new TupleRunner(TupleRunner.createDefaultRunner());
    public static final TupleRunner SEQUENTIAL = new TupleRunner(TupleRunner.createSequentialRunner());
    public static final TupleRunner BENCH = new TupleRunner(TupleRunner.createBenchRunner());

    public TupleRunner(SplitRunner<?> runner) {
        SplitRunner<?> tr = runner;
        SplitRunner<?> cr = runner;
        this.runner_ = tr;
        this.coordRunner_ = cr;
    }

    @Override
    public boolean willAttemptSplit(TupleSequence tseq) {
        return this.runner_.willAttemptSplit(tseq);
    }

    @Override
    public <A> A collect(SplitCollector<TupleSequence, A> collector, Supplier<TupleSequence> tupleSupplier) {
        return this.runner_.collect(collector, tupleSupplier);
    }

    @Override
    public <A> A collectPool(SplitCollector<TupleSequence, A> collector, Supplier<TupleSequence> tupleSupplier) {
        return this.runner_.collectPool(collector, tupleSupplier);
    }

    public void paintData(final BiConsumer<TupleSequence, Paper> tuplePainter, final Paper paper, DataSpec dataSpec, DataStore dataStore) {
        TupleSequenceFactory tseqFact = new TupleSequenceFactory(dataSpec, dataStore);
        if (paper.canMerge() && tseqFact.willAttemptSplit()) {
            SplitCollector<TupleSequence, Paper> collector = new SplitCollector<TupleSequence, Paper>(){

                public Paper createAccumulator() {
                    return paper.createSheet();
                }

                public void accumulate(TupleSequence tseq, Paper p0) {
                    tuplePainter.accept(tseq, p0);
                }

                public Paper combine(Paper p1, Paper p2) {
                    p1.mergeSheet(p2);
                    return p1;
                }
            };
            paper.mergeSheet(this.collectPool((SplitCollector<TupleSequence, A>)((SplitCollector)collector), tseqFact));
        } else {
            tuplePainter.accept(tseqFact.get(), paper);
        }
    }

    public void rangeData(final BiConsumer<TupleSequence, Ranger> rangeFiller, final Ranger ranger, DataSpec dataSpec, DataStore dataStore) {
        TupleSequenceFactory tseqFact = new TupleSequenceFactory(dataSpec, dataStore);
        if (tseqFact.willAttemptSplit()) {
            SplitCollector<TupleSequence, Ranger> collector = new SplitCollector<TupleSequence, Ranger>(){

                public Ranger createAccumulator() {
                    return ranger.createCompatibleRanger();
                }

                public void accumulate(TupleSequence tseq, Ranger ranger2) {
                    rangeFiller.accept(tseq, ranger2);
                }

                public Ranger combine(Ranger r1, Ranger r2) {
                    r1.add(r2);
                    return r1;
                }
            };
            ranger.add(this.collect((SplitCollector<TupleSequence, A>)((SplitCollector)collector), tseqFact));
        } else {
            rangeFiller.accept(tseqFact.get(), ranger);
        }
    }

    public SplitRunner<CoordSequence> coordRunner() {
        return this.coordRunner_;
    }

    private class TupleSequenceFactory
    implements Supplier<TupleSequence> {
        private final Supplier<TupleSequence> baseFact_;
        private final AtomicReference<TupleSequence> tseqRef_;
        private final boolean willAttemptSplit_;

        TupleSequenceFactory(DataSpec dataSpec, DataStore dataStore) {
            this(() -> dataStore.getTupleSequence(dataSpec));
        }

        TupleSequenceFactory(Supplier<TupleSequence> baseFact) {
            this.baseFact_ = baseFact;
            TupleSequence tseq = baseFact.get();
            this.willAttemptSplit_ = TupleRunner.this.willAttemptSplit(tseq);
            this.tseqRef_ = new AtomicReference<TupleSequence>(tseq);
        }

        @Override
        public TupleSequence get() {
            TupleSequence tseq = this.tseqRef_.getAndSet(null);
            return tseq == null ? this.baseFact_.get() : tseq;
        }

        public boolean willAttemptSplit() {
            return this.willAttemptSplit_;
        }
    }
}

