/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.function.Supplier;
import uk.ac.starlink.ttools.plot.Corner;
import uk.ac.starlink.ttools.plot.Matrices;
import uk.ac.starlink.ttools.plot.Plot3D;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.CoordSequence;
import uk.ac.starlink.ttools.plot2.Orientation;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.Surround;
import uk.ac.starlink.ttools.plot2.Tick;
import uk.ac.starlink.ttools.plot2.TickLook;
import uk.ac.starlink.ttools.plot2.TickRun;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.geom.CubeAspect;
import uk.ac.starlink.ttools.plot2.geom.CubeSurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.GPoint3D;
import uk.ac.starlink.ttools.plot2.geom.OrientationPolicy;
import uk.ac.starlink.util.SplitCollector;

public class CubeSurface
implements Surface {
    private final int gxlo_;
    private final int gxhi_;
    private final int gylo_;
    private final int gyhi_;
    private final double[] dlos_;
    private final double[] dhis_;
    private final Scale[] scales_;
    private final boolean[] flipFlags_;
    private final double[] rotmat_;
    private final double zoom_;
    private final double xoff_;
    private final double yoff_;
    private final Tick[][] ticks_;
    private final Orientation[] orients_;
    private final String[] labels_;
    private final Captioner captioner_;
    private final boolean frame_;
    private final boolean antialias_;
    private final double gScale_;
    private final double gZoom_;
    private final int gXoff_;
    private final int gYoff_;
    private final double[] dScales_;
    private final double[] sOffs_;
    private static final TickLook TICKLOOK = TickLook.STANDARD;

    public CubeSurface(int gxlo, int gxhi, int gylo, int gyhi, double[] dlos, double[] dhis, Scale[] scales, boolean[] flipFlags, double[] rotmat, double zoom, double xoff, double yoff, Tick[][] ticks, Orientation[] orients, String[] labels, Captioner captioner, boolean frame, boolean antialias) {
        this.gxlo_ = gxlo;
        this.gxhi_ = gxhi;
        this.gylo_ = gylo;
        this.gyhi_ = gyhi;
        this.dlos_ = (double[])dlos.clone();
        this.dhis_ = (double[])dhis.clone();
        this.scales_ = (Scale[])scales.clone();
        this.flipFlags_ = (boolean[])flipFlags.clone();
        this.rotmat_ = (double[])rotmat.clone();
        this.zoom_ = zoom;
        this.xoff_ = xoff;
        this.yoff_ = yoff;
        this.ticks_ = (Tick[][])ticks.clone();
        this.orients_ = (Orientation[])orients.clone();
        this.labels_ = (String[])labels.clone();
        this.captioner_ = captioner;
        this.frame_ = frame;
        this.antialias_ = antialias;
        this.gScale_ = CubeSurface.getPixelScale(gxhi - gxlo, gyhi - gylo);
        this.gZoom_ = this.zoom_ * this.gScale_ / 2.0;
        this.gXoff_ = this.gxlo_ + (int)(this.xoff_ * this.gScale_) + (this.gxhi_ - this.gxlo_) / 2;
        this.gYoff_ = this.gylo_ + (int)(this.yoff_ * this.gScale_) + (this.gyhi_ - this.gylo_) / 2;
        this.sOffs_ = new double[3];
        this.dScales_ = new double[3];
        for (int id = 0; id < 3; ++id) {
            Scale scale = this.scales_[id];
            double flipMult = this.flipFlags_[id] ? -1.0 : 1.0;
            boolean flipFlag = this.flipFlags_[id];
            double slo = scale.dataToScale(this.dlos_[id]);
            double shi = scale.dataToScale(this.dhis_[id]);
            this.sOffs_[id] = -(slo + shi) / 2.0;
            this.dScales_[id] = flipMult / (shi - slo) * 2.0;
            assert (PlotUtil.approxEquals(-flipMult, this.normalise(this.dlos_, id)));
            assert (PlotUtil.approxEquals(flipMult, this.normalise(this.dhis_, id)));
        }
    }

    @Override
    public int getDataDimCount() {
        return 3;
    }

    @Override
    public Rectangle getPlotBounds() {
        return new Rectangle(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
    }

    @Override
    public Surround getSurround(boolean withScroll) {
        return new Surround();
    }

    @Override
    public Captioner getCaptioner() {
        return this.captioner_;
    }

    @Override
    public boolean dataToGraphics(double[] dataPos, boolean visibleOnly, Point2D.Double gPos) {
        return this.dataToGraphics3D(dataPos, visibleOnly, gPos, false);
    }

    @Override
    public boolean dataToGraphicsOffset(double[] dataPos0, Point2D.Double gPos0, double[] dataPos1, boolean visibleOnly, Point2D.Double gpos1) {
        return this.dataToGraphics(dataPos1, visibleOnly, gpos1);
    }

    public boolean dataToGraphicZ(double[] dataPos, boolean visibleOnly, GPoint3D gPos) {
        return this.dataToGraphics3D(dataPos, visibleOnly, gPos, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean dataToGraphics3D(double[] dataPos, boolean visibleOnly, Point2D.Double gPos, boolean is3d) {
        boolean knownInCube;
        if (visibleOnly) {
            if (!this.inRange(dataPos)) return false;
            knownInCube = true;
        } else {
            knownInCube = false;
        }
        double sx = this.normalise(dataPos, 0);
        double sy = this.normalise(dataPos, 1);
        double sz = this.normalise(dataPos, 2);
        assert (!knownInCube || this.isNormal(sx) && this.isNormal(sy) && this.isNormal(sz)) : "(" + sx + ", " + sy + ", " + sz + ")";
        double[] rot = this.rotmat_;
        double rx = rot[0] * sx + rot[1] * sy + rot[2] * sz;
        double ry = rot[3] * sx + rot[4] * sy + rot[5] * sz;
        double rz = rot[6] * sx + rot[7] * sy + rot[8] * sz;
        double gx = (double)this.gXoff_ + rx * this.gZoom_;
        double gy = (double)this.gYoff_ - rz * this.gZoom_;
        if (visibleOnly && (!(gx >= (double)this.gxlo_) || !(gx < (double)this.gxhi_) || !(gy >= (double)this.gylo_) || !(gy < (double)this.gyhi_))) return false;
        gPos.x = gx;
        gPos.y = gy;
        if (!is3d) return true;
        ((GPoint3D)gPos).z = ry;
        return true;
    }

    public void normalisedToGraphicZ(double sx, double sy, double sz, GPoint3D gPos) {
        double[] rot = this.rotmat_;
        double rx = rot[0] * sx + rot[1] * sy + rot[2] * sz;
        double ry = rot[3] * sx + rot[4] * sy + rot[5] * sz;
        double rz = rot[6] * sx + rot[7] * sy + rot[8] * sz;
        double gx = (double)this.gXoff_ + rx * this.gZoom_;
        double gy = (double)this.gYoff_ - rz * this.gZoom_;
        double dz = ry;
        gPos.x = gx;
        gPos.y = gy;
        gPos.z = dz;
    }

    public boolean inRange(double[] dataPos) {
        for (int i = 0; i < 3; ++i) {
            double d = dataPos[i];
            if (this.dlos_[i] <= d && d <= this.dhis_[i]) continue;
            return false;
        }
        return true;
    }

    public double[] getDataLimits(int idim) {
        return new double[]{this.dlos_[idim], this.dhis_[idim]};
    }

    public Scale[] getScales() {
        return this.scales_;
    }

    public boolean[] getFlipFlags() {
        return this.flipFlags_;
    }

    public double normalise(double[] dataPos, int idim) {
        return this.dScales_[idim] * (this.sOffs_[idim] + this.scales_[idim].dataToScale(dataPos[idim]));
    }

    private double unNormalise(double[] normPos, int idim) {
        double s = normPos[idim] / this.dScales_[idim] - this.sOffs_[idim];
        return this.scales_[idim].scaleToData(s);
    }

    private boolean isNormal(double d) {
        return d >= -1.0001 && d <= 1.0001;
    }

    public Point2D.Double projectNormalisedPos(double[] nPos) {
        double[] r = Matrices.mvMult(this.rotmat_, nPos);
        return new Point2D.Double((double)this.gXoff_ + r[0] * this.gZoom_, (double)this.gYoff_ - r[2] * this.gZoom_);
    }

    @Override
    public String formatPosition(double[] dataPos) {
        return null;
    }

    @Override
    public double[] graphicsToData(Point2D gpos0, Supplier<CoordSequence> dposSupplier) {
        if (dposSupplier == null) {
            return null;
        }
        int[] thresh1s = new int[]{2, 4, 8, 16};
        Arrays.sort(thresh1s);
        NeighbourCollector collector = new NeighbourCollector(this, gpos0, thresh1s);
        NeighbourData ndata = PlotUtil.COORD_RUNNER.collect(collector, dposSupplier);
        return collector.getMeanPosition(ndata);
    }

    @Override
    public boolean isContinuousLine(double[] dpos0, double[] dpos1) {
        return true;
    }

    @Override
    public void paintBackground(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        Color color0 = g2.getColor();
        g2.setColor(Color.WHITE);
        g2.fillRect(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
        g2.setColor(color0);
        if (this.frame_) {
            g2.clipRect(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialias_ ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            this.plotFrame(g2, false);
        }
    }

    @Override
    public void paintForeground(Graphics g) {
        if (this.frame_) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.clipRect(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialias_ ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            this.plotFrame(g2, true);
        }
    }

    ConfigMap getAspectConfig(boolean isIso) {
        int npix = Math.max(this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
        ConfigMap config = new ConfigMap();
        double xlo = this.dlos_[0];
        double ylo = this.dlos_[1];
        double zlo = this.dlos_[2];
        double xhi = this.dhis_[0];
        double yhi = this.dhis_[1];
        double zhi = this.dhis_[2];
        if (isIso) {
            double xr = xhi - xlo;
            double yr = yhi - ylo;
            double zr = zhi - zlo;
            config.put(CubeSurfaceFactory.XC_KEY, PlotUtil.roundNumber(0.5 * (xlo + xhi), xr / (double)npix));
            config.put(CubeSurfaceFactory.YC_KEY, PlotUtil.roundNumber(0.5 * (ylo + yhi), yr / (double)npix));
            config.put(CubeSurfaceFactory.ZC_KEY, PlotUtil.roundNumber(0.5 * (zlo + zhi), zr / (double)npix));
            config.put(CubeSurfaceFactory.SCALE_KEY, (xr + yr + zr) / 3.0);
        } else {
            config.putAll(PlotUtil.configLimits(CubeSurfaceFactory.XMIN_KEY, CubeSurfaceFactory.XMAX_KEY, xlo, xhi, npix));
            config.putAll(PlotUtil.configLimits(CubeSurfaceFactory.YMIN_KEY, CubeSurfaceFactory.YMAX_KEY, ylo, yhi, npix));
            config.putAll(PlotUtil.configLimits(CubeSurfaceFactory.ZMIN_KEY, CubeSurfaceFactory.ZMAX_KEY, zlo, zhi, npix));
        }
        config.put(CubeSurfaceFactory.ZOOM_KEY, this.zoom_);
        config.put(CubeSurfaceFactory.XOFF_KEY, this.xoff_);
        config.put(CubeSurfaceFactory.YOFF_KEY, this.yoff_);
        double[] eulers = CubeSurfaceFactory.rotationToEulerDegrees(this.rotmat_);
        double degEpsilon = 0.01;
        config.put(CubeSurfaceFactory.PHI_KEY, PlotUtil.roundNumber(eulers[0], degEpsilon));
        config.put(CubeSurfaceFactory.THETA_KEY, PlotUtil.roundNumber(eulers[1], degEpsilon));
        config.put(CubeSurfaceFactory.PSI_KEY, PlotUtil.roundNumber(eulers[2], degEpsilon));
        return config;
    }

    CubeAspect pan(Point2D pos0, Point2D pos1) {
        double xf = (pos0.getX() - pos1.getX()) / this.gScale_ / this.zoom_;
        double yf = (pos0.getY() - pos1.getY()) / this.gScale_ / this.zoom_;
        double phi = xf * Math.PI / 2.0;
        double psi = yf * Math.PI / 2.0;
        double[] rot = CubeSurface.rotateXZ(this.rotmat_, phi, psi);
        return this.adjustAspect(rot, this.zoom_, this.xoff_, this.yoff_);
    }

    CubeAspect centerZoom(double factor, boolean[] useFlags) {
        double[] midPos = new double[3];
        for (int i = 0; i < 3; ++i) {
            Scale scale = this.scales_[i];
            double smid = 0.5 * (scale.dataToScale(this.dlos_[i]) + scale.dataToScale(this.dhis_[i]));
            midPos[i] = scale.scaleToData(smid);
        }
        return this.zoomData(midPos, useFlags[0] ? factor : 1.0, useFlags[1] ? factor : 1.0, useFlags[2] ? factor : 1.0);
    }

    CubeAspect pointZoom(Point2D gpos, double xZoom, double yZoom) {
        int[] dirs = this.getScreenDirections();
        double[] factors = new double[]{1.0, 1.0, 1.0};
        factors[dirs[0]] = xZoom;
        factors[dirs[1]] = yZoom;
        return this.zoomData(this.graphicsToData(gpos), factors[0], factors[1], factors[2]);
    }

    CubeAspect pointPan(Point2D gpos0, Point gpos1) {
        double[] dp0 = this.graphicsToData(gpos0);
        double[] dp1 = this.graphicsToData(gpos1);
        double[][] limits = new double[3][];
        for (int i = 0; i < 3; ++i) {
            double[] dArray;
            Scale scale = this.scales_[i];
            double s0 = scale.dataToScale(dp0[i]);
            double s1 = scale.dataToScale(dp1[i]);
            double s10 = s1 - s0;
            double dlo = this.dlos_[i];
            double dhi = this.dhis_[i];
            double slo = scale.dataToScale(dlo);
            double shi = scale.dataToScale(dhi);
            double plo = scale.scaleToData(slo - s10);
            double phi = scale.scaleToData(shi - s10);
            double d = scale.isPositiveDefinite() ? Double.MIN_VALUE : -1.7976931348623157E308;
            if (plo > d && phi < Double.MAX_VALUE) {
                double[] dArray2 = new double[2];
                dArray2[0] = plo;
                dArray = dArray2;
                dArray2[1] = phi;
            } else {
                double[] dArray3 = new double[2];
                dArray3[0] = dlo;
                dArray = dArray3;
                dArray3[1] = dhi;
            }
            limits[i] = dArray;
        }
        return new CubeAspect(limits[0], limits[1], limits[2], this.rotmat_, this.zoom_, this.xoff_, this.yoff_);
    }

    public int[] getScreenDirections() {
        double[] screenXs = new double[3];
        double[] screenYs = new double[3];
        double[] screenNs = new double[3];
        for (int i = 0; i < 3; ++i) {
            double[] r = Matrices.mvMult(this.rotmat_, Matrices.unit(i));
            screenXs[i] = r[0];
            screenYs[i] = r[2];
            screenNs[i] = r[1];
        }
        double maxX = 0.0;
        int imaxX = -1;
        for (int i = 0; i < 3; ++i) {
            if (!(Math.abs(screenXs[i]) > Math.abs(maxX))) continue;
            maxX = screenXs[i];
            imaxX = i;
        }
        int iaxX = imaxX;
        double maxY = 0.0;
        int imaxY = -1;
        for (int i = 0; i < 3; ++i) {
            if (!(Math.abs(screenYs[i]) > Math.abs(maxY)) || i == iaxX) continue;
            maxY = screenYs[i];
            imaxY = i;
        }
        int iaxY = imaxY;
        double maxN = 0.0;
        int imaxN = -1;
        for (int i = 0; i < 3; ++i) {
            if (i == iaxX || i == iaxY) continue;
            maxN = screenNs[i];
            imaxN = i;
        }
        int iaxN = imaxN;
        return new int[]{iaxX, iaxY, iaxN};
    }

    private double[] graphicsToData(Point2D gpos) {
        int[] dirs = this.getScreenDirections();
        int iscreenX = dirs[0];
        int iscreenY = dirs[1];
        int iscreenN = dirs[2];
        double[] normOrigin = new double[3];
        double[] normX1 = (double[])normOrigin.clone();
        double[] normY1 = (double[])normOrigin.clone();
        normX1[iscreenX] = 1.0;
        normY1[iscreenY] = 1.0;
        Point2D.Double g0 = this.projectNormalisedPos(normOrigin);
        Point2D.Double gX = this.projectNormalisedPos(normX1);
        Point2D.Double gY = this.projectNormalisedPos(normY1);
        double[] normPos = new double[3];
        normPos[iscreenN] = 0.0;
        normPos[iscreenX] = this.projectGraphicsToNormalised(g0, gX, gpos);
        normPos[iscreenY] = this.projectGraphicsToNormalised(g0, gY, gpos);
        return new double[]{this.unNormalise(normPos, 0), this.unNormalise(normPos, 1), this.unNormalise(normPos, 2)};
    }

    private double projectGraphicsToNormalised(Point2D origin, Point2D unit, Point2D point) {
        double dux = unit.getX() - origin.getX();
        double duy = unit.getY() - origin.getY();
        double dpx = point.getX() - origin.getX();
        double dpy = point.getY() - origin.getY();
        return (dpx * dux + dpy * duy) / (dux * dux + duy * duy);
    }

    CubeAspect center(double[] dpos) {
        double[][] limits = new double[3][];
        for (int i = 0; i < 3; ++i) {
            Scale scale = this.scales_[i];
            double sp = scale.dataToScale(dpos[i]);
            double slo = scale.dataToScale(this.dlos_[i]);
            double shi = scale.dataToScale(this.dhis_[i]);
            double smid = 0.5 * (slo + shi);
            double soffset = sp - smid;
            double dmin = scale.scaleToData(slo + soffset);
            double dmax = scale.scaleToData(shi + soffset);
            limits[i] = new double[]{dmin, dmax};
        }
        return new CubeAspect(limits[0], limits[1], limits[2], this.rotmat_, this.zoom_, this.xoff_, this.yoff_);
    }

    private CubeAspect zoomData(double[] dpos0, double xFactor, double yFactor, double zFactor) {
        double[] factors = new double[]{xFactor, yFactor, zFactor};
        double[][] limits = new double[3][];
        for (int i = 0; i < 3; ++i) {
            double[] dArray;
            Scale scale = this.scales_[i];
            double f1 = 1.0 / factors[i];
            double dlo = this.dlos_[i];
            double dhi = this.dhis_[i];
            double slo = scale.dataToScale(dlo);
            double shi = scale.dataToScale(dhi);
            double s0 = scale.dataToScale(dpos0[i]);
            double zlo = scale.scaleToData(s0 + (slo - s0) * f1);
            double zhi = scale.scaleToData(s0 + (shi - s0) * f1);
            double d = scale.isPositiveDefinite() ? Double.MIN_VALUE : -1.7976931348623157E308;
            if (zlo > d && zhi < Double.MAX_VALUE) {
                double[] dArray2 = new double[2];
                dArray2[0] = zlo;
                dArray = dArray2;
                dArray2[1] = zhi;
            } else {
                double[] dArray3 = new double[2];
                dArray3[0] = dlo;
                dArray = dArray3;
                dArray3[1] = dhi;
            }
            limits[i] = dArray;
        }
        return new CubeAspect(limits[0], limits[1], limits[2], this.rotmat_, this.zoom_, this.xoff_, this.yoff_);
    }

    public boolean equals(Object o) {
        if (o instanceof CubeSurface) {
            CubeSurface other = (CubeSurface)o;
            return this.gxlo_ == other.gxlo_ && this.gxhi_ == other.gxhi_ && this.gylo_ == other.gylo_ && this.gyhi_ == other.gyhi_ && Arrays.equals(this.dlos_, other.dlos_) && Arrays.equals(this.dhis_, other.dhis_) && Arrays.equals(this.scales_, other.scales_) && Arrays.equals(this.flipFlags_, other.flipFlags_) && this.zoom_ == other.zoom_ && this.xoff_ == other.xoff_ && this.yoff_ == other.yoff_ && Arrays.equals(this.rotmat_, other.rotmat_) && Arrays.deepEquals((Object[])this.ticks_, (Object[])other.ticks_) && Arrays.equals(this.orients_, other.orients_) && Arrays.equals(this.labels_, other.labels_) && this.captioner_.equals(other.captioner_) && this.frame_ == other.frame_ && this.antialias_ == other.antialias_;
        }
        return false;
    }

    public int hashCode() {
        int code = 7701;
        code = 23 * code + this.gxlo_;
        code = 23 * code + this.gxhi_;
        code = 23 * code + this.gylo_;
        code = 23 * code + this.gyhi_;
        code = 23 * code + Arrays.hashCode(this.dlos_);
        code = 23 * code + Arrays.hashCode(this.dhis_);
        code = 23 * code + Arrays.hashCode(this.scales_);
        code = 23 * code + Arrays.hashCode(this.flipFlags_);
        code = 23 * code + Float.floatToIntBits((float)this.zoom_);
        code = 23 * code + Float.floatToIntBits((float)this.xoff_);
        code = 23 * code + Float.floatToIntBits((float)this.yoff_);
        code = 23 * code + Arrays.hashCode(this.rotmat_);
        code = 23 * code + Arrays.deepHashCode((Object[])this.ticks_);
        code = 23 * code + Arrays.hashCode(this.orients_);
        code = 23 * code + Arrays.hashCode(this.labels_);
        code = 23 * code + this.captioner_.hashCode();
        code = 23 * code + (this.frame_ ? 1 : 3);
        code = 23 * code + (this.antialias_ ? 5 : 7);
        return code;
    }

    private CubeAspect adjustAspect(double[] rotmat, double zoom, double xoff, double yoff) {
        return new CubeAspect(new double[]{this.dlos_[0], this.dhis_[0]}, new double[]{this.dlos_[1], this.dhis_[1]}, new double[]{this.dlos_[2], this.dhis_[2]}, rotmat, zoom, xoff, yoff);
    }

    private void plotFrame(Graphics g, boolean front) {
        GPoint3D gp0 = new GPoint3D();
        GPoint3D gp1 = new GPoint3D();
        Corner backCorner = null;
        double zmax = 0.0;
        for (int ic = 0; ic < 8; ++ic) {
            Corner corner = Corner.getCorner(ic);
            double[] dpos0 = this.getCornerDataPos(corner);
            this.dataToGraphicZ(dpos0, false, gp0);
            if (!(gp0.z > zmax)) continue;
            zmax = gp0.z;
            backCorner = corner;
        }
        Graphics2D g2 = (Graphics2D)g;
        Stroke stroke0 = g2.getStroke();
        Color color0 = g2.getColor();
        float sWidth = stroke0 instanceof BasicStroke ? ((BasicStroke)stroke0).getLineWidth() : 1.0f;
        g2.setStroke(new BasicStroke(sWidth, 1, 1));
        g.setColor(front ? Color.BLACK : Color.LIGHT_GRAY);
        for (int i0 = 0; i0 < 8; ++i0) {
            Corner c0 = Corner.getCorner(i0);
            double[] dpos0 = this.getCornerDataPos(c0);
            Corner[] friends = c0.getAdjacent();
            for (int i1 = 0; i1 < friends.length; ++i1) {
                boolean isHidden;
                Corner c1 = friends[i1];
                if (c1.compareTo(c0) <= 0) continue;
                double[] dpos1 = this.getCornerDataPos(c1);
                boolean bl = isHidden = c0 == backCorner || c1 == backCorner;
                if (!(isHidden ^ front)) continue;
                assert (c1 != Corner.ORIGIN);
                if (c0 == Corner.ORIGIN) {
                    this.drawFrameAxis(g2, dpos0, dpos1);
                    continue;
                }
                this.drawFrameLine(g2, dpos0, dpos1);
            }
        }
        g2.setColor(color0);
        g2.setStroke(stroke0);
    }

    private double[] getCornerDataPos(Corner corner) {
        boolean[] cflags = corner.getFlags();
        double[] dpos = new double[3];
        for (int i = 0; i < 3; ++i) {
            dpos[i] = cflags[i] ^ this.flipFlags_[i] ? this.dhis_[i] : this.dlos_[i];
        }
        return dpos;
    }

    private void drawFrameAxis(Graphics g, double[] dpos0, double[] dpos1) {
        int iaxis = -1;
        for (int i = 0; i < 3; ++i) {
            if (dpos0[i] == dpos1[i]) continue;
            assert (iaxis == -1);
            iaxis = i;
        }
        assert (iaxis >= 0 && iaxis < 3);
        double[] up = Matrices.normalise(Matrices.cross(this.getDepthVector(), Matrices.unit(iaxis)));
        boolean forward = true;
        int sx = (int)this.gScale_;
        int sy = g.getFontMetrics().getHeight();
        Point2D.Double sp00 = new Point2D.Double(0.0, 0.0);
        Point2D.Double sp10 = new Point2D.Double(sx, 0.0);
        Point2D.Double sp01 = new Point2D.Double(0.0, sy);
        AffineTransform atf = null;
        int itry = 0;
        while (atf == null) {
            boolean stopFiddling = itry > 5;
            double[] n00 = new double[3];
            double[] n10 = new double[3];
            double[] n01 = new double[3];
            for (int i = 0; i < 3; ++i) {
                n00[i] = this.normalise(forward ? dpos0 : dpos1, i);
                n10[i] = this.normalise(forward ? dpos1 : dpos0, i);
            }
            double uscale = (n10[iaxis] - n00[iaxis]) * (double)sy / (double)sx;
            for (int i = 0; i < 3; ++i) {
                n01[i] = n00[i] + uscale * up[i];
            }
            Point2D.Double tp00 = this.projectNormalisedPos(n00);
            Point2D.Double tp10 = this.projectNormalisedPos(n10);
            Point2D.Double tp01 = this.projectNormalisedPos(n01);
            if (tp01.y < tp00.y && !stopFiddling) {
                up = Matrices.mult(up, -1.0);
            } else {
                double[] sm = new double[]{sp00.x, sp10.x, sp01.x, sp00.y, sp10.y, sp01.y, 1.0, 1.0, 1.0};
                double[] tm = new double[]{tp00.x, tp10.x, tp01.x, tp00.y, tp10.y, tp01.y, 1.0, 1.0, 1.0};
                double[] m = Matrices.mmMult(tm, Matrices.invert(sm));
                double m00 = m[0];
                double m01 = m[1];
                double m02 = m[2];
                double m10 = m[3];
                double m11 = m[4];
                double m12 = m[5];
                assert (PlotUtil.approxEquals(m[6], 0.0)) : m[6];
                assert (PlotUtil.approxEquals(m[7], 0.0)) : m[7];
                assert (PlotUtil.approxEquals(m[8], 1.0)) : m[8];
                if (m00 * m11 - m01 * m10 < 0.0 && !stopFiddling) {
                    forward = !forward;
                } else {
                    atf = new AffineTransform(m00, m10, m01, m11, m02, m12);
                }
            }
            ++itry;
        }
        double det = atf.getDeterminant();
        if (det == 0.0 || Double.isNaN(det)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform atf0 = g2.getTransform();
        g2.transform(atf);
        g2.drawLine(0, 0, sx, 0);
        Axis ax = new Axis(0, sx, this.dlos_[iaxis], this.dhis_[iaxis], this.scales_[iaxis], !forward ^ this.flipFlags_[iaxis]);
        ax.drawLabels(this.ticks_[iaxis], this.labels_[iaxis], this.captioner_, TICKLOOK, this.orients_[iaxis], false, g2);
        g2.setTransform(atf0);
    }

    private void drawFrameLine(Graphics g, double[] dpos0, double[] dpos1) {
        GPoint3D gp0 = new GPoint3D();
        GPoint3D gp1 = new GPoint3D();
        this.dataToGraphicZ(dpos0, false, gp0);
        this.dataToGraphicZ(dpos1, false, gp1);
        g.drawLine(PlotUtil.ifloor(gp0.x), PlotUtil.ifloor(gp0.y), PlotUtil.ifloor(gp1.x), PlotUtil.ifloor(gp1.y));
    }

    private double[] getDepthVector() {
        return Matrices.mvMult(Matrices.invert(this.rotmat_), new double[]{0.0, 1.0, 0.0});
    }

    public static CubeSurface createSurface(Rectangle plotBounds, CubeAspect aspect, boolean forceIso, Scale[] scales, boolean[] flipFlags, String[] labels, double[] crowdFactors, OrientationPolicy orientpolicy, Captioner captioner, boolean frame, boolean minor, boolean antialias) {
        int i;
        int gxlo = plotBounds.x;
        int gxhi = plotBounds.x + plotBounds.width;
        int gylo = plotBounds.y;
        int gyhi = plotBounds.y + plotBounds.height;
        double[] dlos = new double[3];
        double[] dhis = new double[3];
        double[][] limits = aspect.getLimits();
        Tick[][] ticks = new Tick[3][];
        Orientation[] orients = new Orientation[3];
        int npix = CubeSurface.getPixelScale(plotBounds.width, plotBounds.height);
        for (i = 0; i < 3; ++i) {
            dlos[i] = limits[i][0];
            dhis[i] = limits[i][1];
        }
        if (forceIso && CubeSurface.isIsometricPossible(scales)) {
            double shi;
            double slo;
            int i2;
            Scale scale = scales[0];
            double sextent = scale.isPositiveDefinite() ? 1.0 : 0.0;
            for (i2 = 0; i2 < 3; ++i2) {
                slo = scale.dataToScale(dlos[i2]);
                shi = scale.dataToScale(dhis[i2]);
                sextent = Math.max(sextent, shi - slo);
            }
            for (i2 = 0; i2 < 3; ++i2) {
                slo = scale.dataToScale(dlos[i2]);
                shi = scale.dataToScale(dhis[i2]);
                double spad = 0.5 * (sextent - (shi - slo));
                dlos[i2] = scale.scaleToData(slo - spad);
                dhis[i2] = scale.scaleToData(shi + spad);
            }
        }
        for (i = 0; i < 3; ++i) {
            TickRun tickRun = scales[i].getTicker().getTicks(dlos[i], dhis[i], minor, captioner, orientpolicy.getOrientationsX(), npix, crowdFactors[i]);
            ticks[i] = tickRun.getTicks();
            orients[i] = tickRun.getOrientation();
        }
        double[] rotmat = aspect.getRotation();
        double zoom = aspect.getZoom();
        double xoff = aspect.getOffsetX();
        double yoff = aspect.getOffsetY();
        return new CubeSurface(gxlo, gxhi, gylo, gyhi, dlos, dhis, scales, flipFlags, rotmat, zoom, xoff, yoff, ticks, orients, labels, captioner, frame, antialias);
    }

    public static boolean isIsometricPossible(Scale[] scales) {
        return scales[0].equals(scales[1]) && scales[0].equals(scales[2]);
    }

    private static int getPixelScale(int xpix, int ypix) {
        return (int)((double)Math.min(xpix, ypix) / Math.sqrt(3.0));
    }

    private static double[] rotateXZ(double[] base, double phi, double psi) {
        double[] rotA = Plot3D.rotate(base, new double[]{0.0, 0.0, 1.0}, phi);
        double[] rotB = Plot3D.rotate(base, new double[]{1.0, 0.0, 0.0}, psi);
        return Matrices.mmMult(Matrices.mmMult(base, rotB), rotA);
    }

    private static class NeighbourCollector
    implements SplitCollector<CoordSequence, NeighbourData> {
        private final CubeSurface surf_;
        private final Point2D gpos0_;
        private final int nthresh_;
        private final int[] thresh2s_;
        private final double maxThresh2_;
        private final Scale[] scales_;

        NeighbourCollector(CubeSurface surf, Point2D gpos0, int[] thresh1s) {
            this.surf_ = surf;
            this.gpos0_ = gpos0;
            this.nthresh_ = thresh1s.length;
            this.scales_ = surf.scales_;
            this.thresh2s_ = new int[this.nthresh_];
            Arrays.setAll(this.thresh2s_, i -> thresh1s[i] * thresh1s[i]);
            this.maxThresh2_ = this.thresh2s_[this.nthresh_ - 1];
        }

        public NeighbourData createAccumulator() {
            return new NeighbourData(this.nthresh_);
        }

        public void accumulate(CoordSequence cseq, NeighbourData acc) {
            double[] dpos = cseq.getCoords();
            double[] sp0 = new double[3];
            Point2D.Double gp = new Point2D.Double();
            while (cseq.next()) {
                double d2;
                if (!this.surf_.dataToGraphics(dpos, true, gp) || !((d2 = this.gpos0_.distanceSq(gp)) <= this.maxThresh2_)) continue;
                for (int idim = 0; idim < 3; ++idim) {
                    double d = dpos[idim];
                    sp0[idim] = this.scales_[idim].dataToScale(d);
                }
                for (int ith = 0; ith < this.nthresh_; ++ith) {
                    if (!(d2 <= (double)this.thresh2s_[ith])) continue;
                    for (int idim = 0; idim < 3; ++idim) {
                        double[] dArray = acc.sposTots_[ith];
                        int n = idim;
                        dArray[n] = dArray[n] + sp0[idim];
                    }
                    int n = ith;
                    acc.counts_[n] = acc.counts_[n] + 1L;
                }
            }
        }

        public NeighbourData combine(NeighbourData acc1, NeighbourData acc2) {
            for (int ith = 0; ith < this.nthresh_; ++ith) {
                int n = ith;
                acc1.counts_[n] = acc1.counts_[n] + acc2.counts_[ith];
                for (int id = 0; id < 3; ++id) {
                    double[] dArray = acc1.sposTots_[ith];
                    int n2 = id;
                    dArray[n2] = dArray[n2] + acc2.sposTots_[ith][id];
                }
            }
            return acc1;
        }

        public double[] getMeanPosition(NeighbourData acc) {
            for (int ith = 0; ith < this.nthresh_; ++ith) {
                long count = acc.counts_[ith];
                if (count <= 0L) continue;
                double c1 = 1.0 / (double)count;
                double[] dposMean = new double[3];
                for (int id = 0; id < 3; ++id) {
                    double s = c1 * acc.sposTots_[ith][id];
                    dposMean[id] = this.scales_[id].scaleToData(s);
                }
                return dposMean;
            }
            return null;
        }
    }

    private static class NeighbourData {
        final long[] counts_;
        final double[][] sposTots_;

        NeighbourData(int ngrp) {
            this.counts_ = new long[ngrp];
            this.sposTots_ = new double[ngrp][3];
        }
    }
}

