/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Supplier;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.CoordSequence;
import uk.ac.starlink.ttools.plot2.Orientation;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.Surround;
import uk.ac.starlink.ttools.plot2.Tick;
import uk.ac.starlink.ttools.plot2.TickRun;
import uk.ac.starlink.ttools.plot2.Ticker;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.geom.AxisAnnotation;
import uk.ac.starlink.ttools.plot2.geom.OrientationPolicy;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.geom.PlaneAspect;
import uk.ac.starlink.ttools.plot2.geom.PlaneAxisAnnotation;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.SideFlags;
import uk.ac.starlink.ttools.plot2.geom.SlaveTicker;

public class PlaneSurface
implements Surface,
PlanarSurface {
    private final int gxlo_;
    private final int gxhi_;
    private final int gylo_;
    private final int gyhi_;
    private final double dxlo_;
    private final double dxhi_;
    private final double dylo_;
    private final double dyhi_;
    private final Scale xscale_;
    private final Scale yscale_;
    private final boolean xflip_;
    private final boolean yflip_;
    private final Tick[] xticks_;
    private final Tick[] yticks_;
    private final Orientation xorient_;
    private final Orientation yorient_;
    private final String xlabel_;
    private final String ylabel_;
    private final Tick[] x2ticks_;
    private final Tick[] y2ticks_;
    private final Orientation x2orient_;
    private final Orientation y2orient_;
    private final String x2label_;
    private final String y2label_;
    private final Captioner captioner_;
    private final SideFlags annotateflags_;
    private final Color gridcolor_;
    private final Color axlabelcolor_;
    private final boolean islabelposition_;
    private final Axis xAxis_;
    private final Axis yAxis_;

    public PlaneSurface(int gxlo, int gxhi, int gylo, int gyhi, double dxlo, double dxhi, double dylo, double dyhi, Scale xscale, Scale yscale, boolean xflip, boolean yflip, Tick[] xticks, Tick[] yticks, Orientation xorient, Orientation yorient, String xlabel, String ylabel, Tick[] x2ticks, Tick[] y2ticks, Orientation x2orient, Orientation y2orient, String x2label, String y2label, Captioner captioner, SideFlags annotateflags, Color gridcolor, Color axlabelcolor, boolean islabelposition) {
        this.gxlo_ = gxlo;
        this.gxhi_ = gxhi;
        this.gylo_ = gylo;
        this.gyhi_ = gyhi;
        this.dxlo_ = dxlo;
        this.dxhi_ = dxhi;
        this.dylo_ = dylo;
        this.dyhi_ = dyhi;
        this.xscale_ = xscale;
        this.yscale_ = yscale;
        this.xflip_ = xflip;
        this.yflip_ = yflip;
        this.xticks_ = xticks;
        this.yticks_ = yticks;
        this.xorient_ = xorient;
        this.yorient_ = yorient;
        this.xlabel_ = xlabel;
        this.ylabel_ = ylabel;
        this.x2ticks_ = x2ticks;
        this.y2ticks_ = y2ticks;
        this.x2orient_ = x2orient;
        this.y2orient_ = y2orient;
        this.x2label_ = x2label;
        this.y2label_ = y2label;
        this.captioner_ = captioner;
        this.annotateflags_ = annotateflags;
        this.gridcolor_ = gridcolor;
        this.axlabelcolor_ = axlabelcolor;
        this.islabelposition_ = islabelposition;
        this.xAxis_ = new Axis(this.gxlo_, this.gxhi_, this.dxlo_, this.dxhi_, this.xscale_, this.xflip_);
        this.yAxis_ = new Axis(this.gylo_, this.gyhi_, this.dylo_, this.dyhi_, this.yscale_, this.yflip_ ^ true);
        assert (this.equals(this));
    }

    @Override
    public Rectangle getPlotBounds() {
        return new Rectangle(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
    }

    @Override
    public Surround getSurround(boolean withScroll) {
        return this.createAxisAnnotation().getSurround(withScroll);
    }

    @Override
    public int getDataDimCount() {
        return 2;
    }

    @Override
    public boolean dataToGraphics(double[] dpos, boolean visibleOnly, Point2D.Double gp) {
        double gx = this.xAxis_.dataToGraphics(dpos[0]);
        double gy = this.yAxis_.dataToGraphics(dpos[1]);
        if (!visibleOnly || gx >= (double)this.gxlo_ && gx < (double)this.gxhi_ && gy >= (double)this.gylo_ && gy < (double)this.gyhi_) {
            gp.x = gx;
            gp.y = gy;
            return true;
        }
        return false;
    }

    @Override
    public boolean dataToGraphicsOffset(double[] dpos0, Point2D.Double gpos0, double[] dpos1, boolean visibleOnly, Point2D.Double gpos1) {
        return this.dataToGraphics(dpos1, visibleOnly, gpos1);
    }

    @Override
    public double[] graphicsToData(Point2D gp, Supplier<CoordSequence> dposSupplier) {
        return new double[]{this.xAxis_.graphicsToData(gp.getX()), this.yAxis_.graphicsToData(gp.getY())};
    }

    @Override
    public boolean isContinuousLine(double[] dpos0, double[] dpos1) {
        return true;
    }

    @Override
    public String formatPosition(double[] dpos) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(PlaneSurface.formatPosition(this.xAxis_, dpos[0])).append(", ").append(PlaneSurface.formatPosition(this.yAxis_, dpos[1]));
        if (this.islabelposition_) {
            sbuf.append(" (").append(this.xlabel_).append(", ").append(this.ylabel_).append(")");
        }
        return sbuf.toString();
    }

    @Override
    public Captioner getCaptioner() {
        return this.captioner_;
    }

    @Override
    public void paintBackground(Graphics g) {
        Color color0 = g.getColor();
        g.setColor(Color.WHITE);
        g.fillRect(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
        g.setColor(color0);
    }

    @Override
    public void paintForeground(Graphics g) {
        Color color0 = g.getColor();
        if (this.gridcolor_ != null) {
            Graphics gGrid = PlotUtil.createLineGraphics(g, this.gridcolor_);
            for (Tick tick : this.xticks_) {
                if (tick.getLabel() == null) continue;
                int gx = (int)this.xAxis_.dataToGraphics(tick.getValue());
                gGrid.drawLine(gx, this.gylo_, gx, this.gyhi_);
            }
            for (Tick tick : this.yticks_) {
                if (tick.getLabel() == null) continue;
                int gy = (int)this.yAxis_.dataToGraphics(tick.getValue());
                gGrid.drawLine(this.gxlo_, gy, this.gxhi_, gy);
            }
        }
        if (this.axlabelcolor_ != null) {
            g.setColor(this.axlabelcolor_);
            this.createAxisAnnotation().drawLabels(g);
            g.drawRect(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
        }
        g.setColor(color0);
    }

    ConfigMap getAspectConfig() {
        ConfigMap config = new ConfigMap();
        config.putAll(PlotUtil.configLimits(PlaneSurfaceFactory.XMIN_KEY, PlaneSurfaceFactory.XMAX_KEY, this.dxlo_, this.dxhi_, this.gxhi_ - this.gxlo_));
        config.putAll(PlotUtil.configLimits(PlaneSurfaceFactory.YMIN_KEY, PlaneSurfaceFactory.YMAX_KEY, this.dylo_, this.dyhi_, this.gyhi_ - this.gylo_));
        return config;
    }

    @Override
    public double[][] getDataLimits() {
        return new double[][]{{this.dxlo_, this.dxhi_}, {this.dylo_, this.dyhi_}};
    }

    @Override
    public Scale[] getScales() {
        return new Scale[]{this.xscale_, this.yscale_};
    }

    @Override
    public boolean[] getFlipFlags() {
        return new boolean[]{this.xflip_, this.yflip_};
    }

    @Override
    public boolean[] getTimeFlags() {
        return new boolean[]{false, false};
    }

    @Override
    public Axis[] getAxes() {
        return new Axis[]{this.xAxis_, this.yAxis_};
    }

    PlaneAspect zoom(Point2D pos, double xZoom, double yZoom) {
        return new PlaneAspect(this.xAxis_.dataZoom(this.xAxis_.graphicsToData(pos.getX()), xZoom), this.yAxis_.dataZoom(this.yAxis_.graphicsToData(pos.getY()), yZoom));
    }

    PlaneAspect pan(Point2D pos0, Point2D pos1, boolean xFlag, boolean yFlag) {
        if (xFlag || yFlag) {
            double[] dArray;
            double[] dArray2;
            if (xFlag) {
                dArray2 = this.xAxis_.dataPan(this.xAxis_.graphicsToData(pos0.getX()), this.xAxis_.graphicsToData(pos1.getX()));
            } else {
                double[] dArray3 = new double[2];
                dArray3[0] = this.dxlo_;
                dArray2 = dArray3;
                dArray3[1] = this.dxhi_;
            }
            if (yFlag) {
                dArray = this.yAxis_.dataPan(this.yAxis_.graphicsToData(pos0.getY()), this.yAxis_.graphicsToData(pos1.getY()));
            } else {
                double[] dArray4 = new double[2];
                dArray4[0] = this.dylo_;
                dArray = dArray4;
                dArray4[1] = this.dyhi_;
            }
            return new PlaneAspect(dArray2, dArray);
        }
        return null;
    }

    PlaneAspect center(double[] dpos, boolean xFlag, boolean yFlag) {
        Point2D.Double gp = new Point2D.Double();
        return this.dataToGraphics(dpos, false, gp) && PlotUtil.isPointFinite(gp) ? this.pan(gp, new Point2D.Double((double)(this.gxlo_ + this.gxhi_) * 0.5, (double)(this.gylo_ + this.gyhi_) * 0.5), xFlag, yFlag) : null;
    }

    PlaneAspect reframe(Rectangle frame) {
        Point gp1 = new Point(frame.x, frame.y);
        Point gp2 = new Point(frame.x + frame.width, frame.y + frame.height);
        double[] dpos1 = this.graphicsToData(gp1, null);
        double[] dpos2 = this.graphicsToData(gp2, null);
        return new PlaneAspect(PlotUtil.orderPair(dpos1[0], dpos2[0]), PlotUtil.orderPair(dpos1[1], dpos2[1]));
    }

    private AxisAnnotation createAxisAnnotation() {
        return new PlaneAxisAnnotation(this.gxlo_, this.gxhi_, this.gylo_, this.gyhi_, this.xAxis_, this.yAxis_, this.xticks_, this.yticks_, this.xorient_, this.yorient_, this.xlabel_, this.ylabel_, this.x2ticks_, this.y2ticks_, this.x2orient_, this.y2orient_, this.x2label_, this.y2label_, this.captioner_, this.annotateflags_);
    }

    public boolean equals(Object o) {
        if (o instanceof PlaneSurface) {
            PlaneSurface other = (PlaneSurface)o;
            return this.gxlo_ == other.gxlo_ && this.gxhi_ == other.gxhi_ && this.gylo_ == other.gylo_ && this.gyhi_ == other.gyhi_ && this.dxlo_ == other.dxlo_ && this.dxhi_ == other.dxhi_ && this.dylo_ == other.dylo_ && this.dyhi_ == other.dyhi_ && this.xscale_.equals(other.xscale_) && this.yscale_.equals(other.yscale_) && this.xflip_ == other.xflip_ && this.yflip_ == other.yflip_ && Arrays.equals(this.xticks_, other.xticks_) && Arrays.equals(this.yticks_, other.yticks_) && PlotUtil.equals(this.xorient_, other.xorient_) && PlotUtil.equals(this.yorient_, other.yorient_) && PlotUtil.equals(this.xlabel_, other.xlabel_) && PlotUtil.equals(this.ylabel_, other.ylabel_) && Arrays.equals(this.x2ticks_, other.x2ticks_) && Arrays.equals(this.y2ticks_, other.y2ticks_) && PlotUtil.equals(this.x2orient_, other.x2orient_) && PlotUtil.equals(this.y2orient_, other.y2orient_) && PlotUtil.equals(this.x2label_, other.x2label_) && PlotUtil.equals(this.y2label_, other.y2label_) && this.captioner_.equals(other.captioner_) && this.annotateflags_.equals(other.annotateflags_) && PlotUtil.equals(this.gridcolor_, other.gridcolor_) && PlotUtil.equals(this.axlabelcolor_, other.axlabelcolor_) && this.islabelposition_ == other.islabelposition_;
        }
        return false;
    }

    public int hashCode() {
        int code = 23023;
        code = 23 * code + this.gxlo_;
        code = 23 * code + this.gxhi_;
        code = 23 * code + this.gylo_;
        code = 23 * code + this.gyhi_;
        code = 23 * code + Float.floatToIntBits((float)this.dxlo_);
        code = 23 * code + Float.floatToIntBits((float)this.dxhi_);
        code = 23 * code + Float.floatToIntBits((float)this.dylo_);
        code = 23 * code + Float.floatToIntBits((float)this.dyhi_);
        code = 23 * code + this.xscale_.hashCode();
        code = 23 * code + this.yscale_.hashCode();
        code = 23 * code + (this.xflip_ ? 4 : 0) + (this.yflip_ ? 8 : 0);
        code = 23 * code + Arrays.hashCode(this.xticks_);
        code = 23 * code + Arrays.hashCode(this.yticks_);
        code = 23 * code + PlotUtil.hashCode(this.xorient_);
        code = 23 * code + PlotUtil.hashCode(this.yorient_);
        code = 23 * code + PlotUtil.hashCode(this.xlabel_);
        code = 23 * code + PlotUtil.hashCode(this.ylabel_);
        code = 23 * code + Arrays.hashCode(this.x2ticks_);
        code = 23 * code + Arrays.hashCode(this.y2ticks_);
        code = 23 * code + PlotUtil.hashCode(this.x2orient_);
        code = 23 * code + PlotUtil.hashCode(this.y2orient_);
        code = 23 * code + PlotUtil.hashCode(this.x2label_);
        code = 23 * code + PlotUtil.hashCode(this.y2label_);
        code = 23 * code + this.captioner_.hashCode();
        code = 23 * code + this.annotateflags_.hashCode();
        code = 23 * code + PlotUtil.hashCode(this.gridcolor_);
        code = 23 * code + PlotUtil.hashCode(this.axlabelcolor_);
        code = 23 * code + (this.islabelposition_ ? 5 : 13);
        return code;
    }

    public static PlaneSurface createSurface(Rectangle plotBounds, PlaneAspect aspect, Scale xscale, Scale yscale, boolean xflip, boolean yflip, String xlabel, String ylabel, DoubleUnaryOperator x2func, DoubleUnaryOperator y2func, String x2label, String y2label, Captioner captioner, SideFlags annotateflags, double xyfactor, double xcrowd, double ycrowd, OrientationPolicy orientpolicy, boolean minor, boolean shadow, Color gridcolor, Color axlabelcolor, boolean islabelposition) {
        TickRun x2tickRun;
        TickRun ytickRun;
        TickRun xtickRun;
        int gxlo = plotBounds.x;
        int gxhi = plotBounds.x + plotBounds.width;
        int gylo = plotBounds.y;
        int gyhi = plotBounds.y + plotBounds.height;
        double dxlo = aspect.getXMin();
        double dxhi = aspect.getXMax();
        double dylo = aspect.getYMin();
        double dyhi = aspect.getYMax();
        Ticker xTicker = xscale.getTicker();
        Ticker yTicker = yscale.getTicker();
        if (xyfactor > 0.0 && xscale.equals(yscale)) {
            double sx;
            double gx = gxhi - gxlo;
            double gy = gyhi - gylo;
            double sxlo = xscale.dataToScale(dxlo);
            double sxhi = xscale.dataToScale(dxhi);
            double sylo = yscale.dataToScale(dylo);
            double syhi = yscale.dataToScale(dyhi);
            double sy = syhi - sylo;
            double fadj = xyfactor * (gy / sy) / (gx / (sx = sxhi - sxlo));
            if (fadj > 1.0) {
                double dyadj = sy * (1.0 * fadj - 1.0);
                dylo = yscale.scaleToData(sylo += -0.5 * dyadj);
                dyhi = yscale.scaleToData(syhi += 0.5 * dyadj);
            } else {
                double dxadj = sx * (1.0 / fadj - 1.0);
                dxlo = xscale.scaleToData(sxlo += -0.5 * dxadj);
                dxhi = xscale.scaleToData(sxhi += 0.5 * dxadj);
            }
            assert (Math.abs(xyfactor * (gy / (syhi - sylo)) / (gx / (sxhi - sxlo)) - 1.0) < 1.0E-6);
            xtickRun = xTicker.getTicks(dxlo, dxhi, minor, captioner, orientpolicy.getOrientationsX(), plotBounds.width, 1.0);
            ytickRun = yTicker.getTicks(dylo, dyhi, minor, captioner, orientpolicy.getOrientationsY(), plotBounds.height, 1.0);
        } else {
            xtickRun = xTicker.getTicks(dxlo, dxhi, minor, captioner, orientpolicy.getOrientationsX(), plotBounds.width, xcrowd);
            ytickRun = yTicker.getTicks(dylo, dyhi, minor, captioner, orientpolicy.getOrientationsY(), plotBounds.height, ycrowd);
        }
        Tick[] xticks = xtickRun.getTicks();
        Tick[] yticks = ytickRun.getTicks();
        Orientation xorient = xtickRun.getOrientation();
        Orientation yorient = ytickRun.getOrientation();
        Axis xAxis = new Axis(gxlo, gxhi, dxlo, dxhi, xscale, xflip);
        Axis yAxis = new Axis(gylo, gyhi, dylo, dyhi, yscale, yflip ^ true);
        TickRun tickRun = x2func == null ? (shadow ? new TickRun(PlotUtil.getShadowTicks(xticks), Orientation.ANTI_X) : null) : (x2tickRun = SlaveTicker.createTicker(xAxis, x2func).getTicks(dxlo, dxhi, minor, captioner, orientpolicy.getOrientationsX2(), plotBounds.width, xcrowd));
        TickRun y2tickRun = y2func == null ? (shadow ? new TickRun(PlotUtil.getShadowTicks(yticks), Orientation.ANTI_Y) : null) : SlaveTicker.createTicker(yAxis, y2func).getTicks(dylo, dyhi, minor, captioner, orientpolicy.getOrientationsY2(), plotBounds.height, ycrowd);
        Tick[] x2ticks = x2tickRun == null ? null : x2tickRun.getTicks();
        Tick[] y2ticks = y2tickRun == null ? null : y2tickRun.getTicks();
        Orientation x2orient = x2tickRun == null ? null : x2tickRun.getOrientation();
        Orientation y2orient = y2tickRun == null ? null : y2tickRun.getOrientation();
        return new PlaneSurface(gxlo, gxhi, gylo, gyhi, dxlo, dxhi, dylo, dyhi, xscale, yscale, xflip, yflip, xticks, yticks, xorient, yorient, xlabel, ylabel, x2ticks, y2ticks, x2orient, y2orient, x2label, y2label, captioner, annotateflags, gridcolor, axlabelcolor, islabelposition);
    }

    public static String formatPosition(Axis axis, double dpos) {
        double dp2 = axis.graphicsToData(axis.dataToGraphics(dpos) + 2.0);
        return PlotUtil.formatNumber(dpos, Math.abs(dp2 - dpos) / 2.0);
    }
}

