/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Arrays;
import uk.ac.starlink.pal.Pal;
import uk.ac.starlink.ttools.plot.Matrices;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.geom.Sin2;
import uk.ac.starlink.ttools.plot2.geom.SkyAspect;
import uk.ac.starlink.ttools.plot2.geom.SkyFov;
import uk.ac.starlink.ttools.plot2.geom.SkySurface;
import uk.ac.starlink.ttools.plot2.geom.SkySurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.SkyviewProjection;

public class SinProjection
extends SkyviewProjection {
    private static final double[] RX = new double[]{1.0, 0.0, 0.0};
    private static final double[] RY = new double[]{0.0, 1.0, 0.0};
    private static final double[] RZ = new double[]{0.0, 0.0, 1.0};
    private static final double MAX_RANGE_ZOOM = 1.0E7;
    public static SinProjection INSTANCE = new SinProjection();

    private SinProjection() {
        super(new Sin2(), new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0), "Sin", "rotatable sphere");
    }

    @Override
    public boolean project(double rx, double ry, double rz, Point2D.Double pos) {
        if (rx >= 0.0) {
            pos.x = ry;
            pos.y = rz;
            return true;
        }
        return false;
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public boolean isContinuousLine(double[] r3a, double[] r3b) {
        return true;
    }

    @Override
    public double[] cursorRotate(double[] rot0, Point2D.Double pos0, Point2D.Double pos1) {
        double[] rot1 = this.genericRotate(rot0, pos0, pos1);
        if (rot1 != null) {
            return rot1;
        }
        boolean reflect = SinProjection.isReflected(rot0);
        double fr = reflect ? -1.0 : 1.0;
        double phi = pos1.x - pos0.x;
        double psi = pos1.y - pos0.y;
        double[] rm = rot0;
        double[] sightvec = Matrices.mvMult(Matrices.invert(rm), new double[]{1.0, 0.0, 0.0});
        double[] hvec = Matrices.normalise(Matrices.cross(sightvec, RZ));
        rm = SinProjection.rotateAround(rm, hvec, -psi);
        if (Matrices.mvMult(rm = SinProjection.rotateAround(rm, RZ, -phi * fr), RZ)[2] >= 0.0) {
            return rm;
        }
        double delta = Math.atan2(-rm[2], rm[8]);
        double alpha = Math.atan2(-rm[3], rm[4] * fr);
        delta = Math.min(1.5707963267948966, delta);
        delta = Math.max(-1.5707963267948966, delta);
        return SinProjection.verticalRotate(delta, alpha, reflect);
    }

    @Override
    public double[] projRotate(double[] rot0, Point2D.Double pos0, Point2D.Double pos1) {
        double[] rot1 = this.genericRotate(rot0, pos0, pos1);
        return rot1 == null ? rot0 : rot1;
    }

    @Override
    public boolean useRanges(boolean reflect, double[] r3, double radiusRad) {
        return !this.isFovSpecified(r3, radiusRad);
    }

    @Override
    public SkyAspect createAspect(boolean reflect, double[] r3, double radiusRad, Range[] vxyzRanges) {
        if (this.isFovSpecified(r3, radiusRad)) {
            double[] rotmat = SinProjection.rotateToCenter(r3, reflect);
            double zoom = 1.0 / Math.sin(Math.min(1.5707963267948966, radiusRad));
            return new SkyAspect(rotmat, zoom, 0.0, 0.0);
        }
        if (vxyzRanges != null) {
            assert (vxyzRanges.length == 3);
            if (SkySurfaceFactory.isAllSky(vxyzRanges)) {
                return SinProjection.getDefaultAspect(reflect);
            }
            double[] crot = SinProjection.getRangeRotation(vxyzRanges, reflect);
            if (crot == null) {
                return SinProjection.getDefaultAspect(reflect);
            }
            if (SinProjection.isSinglePoint(vxyzRanges)) {
                return new SkyAspect(crot, 1.0, 0.0, 0.0);
            }
            Range[] pxyRanges = this.readProjectedRanges(vxyzRanges, crot);
            double[] pxBounds = pxyRanges[0].getBounds();
            double[] pyBounds = pxyRanges[1].getBounds();
            double pmax = uk.ac.starlink.ttools.func.Arrays.maximum(new double[]{Math.abs(pxBounds[0]), Math.abs(pxBounds[1]), Math.abs(pyBounds[0]), Math.abs(pyBounds[1]), 1.0E-7});
            double zoom = 1.0 / pmax;
            return new SkyAspect(crot, zoom, 0.0, 0.0);
        }
        return SinProjection.getDefaultAspect(reflect);
    }

    @Override
    public SkyFov getFov(SkySurface surf) {
        if (SinProjection.isDefaultAspect(surf)) {
            return null;
        }
        double[] rotmat = surf.getRotation();
        double zoom = surf.getZoom();
        double[] center = Matrices.mvMult(Matrices.invert(rotmat), RX);
        double[] lonLat = surf.getRoundedLonLatDegrees(center);
        double rdeg = Math.toDegrees(Math.asin(1.0 / zoom));
        Rectangle bounds = surf.getPlotBounds();
        int npix = Math.max(bounds.width, bounds.height);
        double radiusDeg = PlotUtil.roundNumber(rdeg, rdeg / (10.0 * (double)npix));
        return new SkyFov(lonLat[0], lonLat[1], radiusDeg);
    }

    private static SkyAspect getDefaultAspect(boolean reflect) {
        double[] rot = SinProjection.verticalRotate(Math.toRadians(-15.0), Math.toRadians(-10.0), reflect);
        return new SkyAspect(rot, 1.0, 0.0, 0.0);
    }

    private static boolean isDefaultAspect(SkySurface surf) {
        double[] rotmat = surf.getRotation();
        SkyAspect dflt = SinProjection.getDefaultAspect(SinProjection.isReflected(rotmat));
        return surf.getZoom() == dflt.getZoom() && surf.getOffsetX() == dflt.getOffsetX() && surf.getOffsetY() == dflt.getOffsetY() && Arrays.equals(rotmat, dflt.getRotation());
    }

    private boolean isFovSpecified(double[] r3, double radiusRad) {
        return r3 != null && !Double.isNaN(r3[0]) && !Double.isNaN(r3[1]) && !Double.isNaN(r3[2]) && radiusRad > 0.0;
    }

    private Range[] readProjectedRanges(Range[] vxyzRanges, double[] rot) {
        double[] vxBounds = vxyzRanges[0].getBounds();
        double[] vyBounds = vxyzRanges[1].getBounds();
        double[] vzBounds = vxyzRanges[2].getBounds();
        double[] r3 = new double[3];
        Range pxRange = new Range();
        Range pyRange = new Range();
        Point2D.Double point = new Point2D.Double();
        for (int jx = 0; jx < 2; ++jx) {
            r3[0] = vxBounds[jx];
            for (int jy = 0; jy < 2; ++jy) {
                r3[1] = vyBounds[jy];
                for (int jz = 0; jz < 2; ++jz) {
                    r3[2] = vzBounds[jz];
                    double[] s3 = Matrices.normalise(Matrices.mvMult(rot, r3));
                    if (!this.project(s3[0], s3[1], s3[2], point)) continue;
                    pxRange.submit(point.x);
                    pyRange.submit(point.y);
                }
            }
        }
        return new Range[]{pxRange, pyRange};
    }

    private double[] genericRotate(double[] rot0, Point2D.Double pos0, Point2D.Double pos1) {
        double[] rv0 = new double[3];
        if (this.unproject(pos0, rv0) && this.getSkyviewProjecter().validPosition(new double[]{pos1.x, pos1.y})) {
            double[] unrot0 = Matrices.invert(rot0);
            double[] ru0 = Matrices.mvMult(unrot0, rv0);
            return SinProjection.getRotation(ru0, pos1, rot0);
        }
        return null;
    }

    private static boolean isSinglePoint(Range[] ranges) {
        for (Range range : ranges) {
            double[] bounds = range.getBounds();
            if (bounds[0] == bounds[1]) continue;
            return false;
        }
        return true;
    }

    private static double[] getRotation(double[] rv0, Point2D.Double pos1, double[] rot0) {
        double sa;
        boolean reflect = SinProjection.isReflected(rot0);
        final double fr = reflect ? -1.0 : 1.0;
        final double rx = rv0[0];
        final double ry = rv0[1];
        double rz = rv0[2];
        final double px = pos1.x;
        double py = pos1.y;
        double delta0 = Math.atan2(-rot0[2], rot0[8]);
        double alpha0 = Math.atan2(-rot0[3], rot0[4] * fr);
        double alpha = new Solver(){

            @Override
            double[] derivs(double a) {
                double sa = Math.sin(a);
                double ca = Math.cos(a);
                return new double[]{-sa * rx + ca * ry * fr - px, -ca * rx - sa * ry * fr};
            }
        }.solve(alpha0);
        if (Double.isNaN(alpha)) {
            return null;
        }
        final double ca = Math.cos(alpha);
        double delta = new Solver(sa = Math.sin(alpha), ry, fr, rz, py){
            final /* synthetic */ double val$sa;
            final /* synthetic */ double val$ry;
            final /* synthetic */ double val$fr;
            final /* synthetic */ double val$rz;
            final /* synthetic */ double val$py;
            {
                this.val$sa = d3;
                this.val$ry = d4;
                this.val$fr = d5;
                this.val$rz = d6;
                this.val$py = d7;
            }

            @Override
            double[] derivs(double d) {
                double sd = Math.sin(d);
                double cd = Math.cos(d);
                return new double[]{sd * (ca * rx + this.val$sa * this.val$ry * this.val$fr) + cd * this.val$rz - this.val$py, cd * (ca * rx + this.val$sa * this.val$ry * this.val$fr) - sd * this.val$rz};
            }
        }.solve(delta0);
        if (Double.isNaN(delta)) {
            return null;
        }
        double[] rot1 = SinProjection.verticalRotate(delta, alpha, reflect);
        if (Matrices.mvMult(rot1, rv0)[0] >= 0.0 && Matrices.mvMult(rot1, RZ)[2] > 0.0) {
            return rot1;
        }
        return null;
    }

    public static double[] verticalRotate(double delta, double alpha, boolean reflect) {
        double fr = reflect ? -1.0 : 1.0;
        double ca = Math.cos(alpha);
        double sa = Math.sin(alpha);
        double cd = Math.cos(delta);
        double sd = Math.sin(delta);
        double[] rot = new double[]{cd * ca, cd * sa * fr, -sd, -sa, ca * fr, 0.0, sd * ca, sd * sa * fr, cd};
        return rot;
    }

    private static double[] rotateAround(double[] matrix, double[] unitvec, double angle) {
        assert (Math.abs(unitvec[0] * unitvec[0] + unitvec[1] * unitvec[1] + unitvec[2] * unitvec[2] - 1.0) < 1000000.0);
        double[] rm = Matrices.fromPal(new Pal().Dav2m(Matrices.mult(unitvec, angle)));
        return Matrices.mmMult(matrix, rm);
    }

    private static boolean isReflected(double[] rotmat) {
        return Matrices.det(rotmat) < 0.0;
    }

    private static double[] rotateToCenter(double[] r3, boolean reflect) {
        double rx = r3[0];
        double ry = r3[1];
        double rz = r3[2];
        double fr = reflect ? -1.0 : 1.0;
        double alpha = Math.atan2(ry, rx);
        double ca = Math.cos(alpha);
        double sa = Math.sin(alpha);
        double delta = Math.atan2(-rz, ca * rx + sa * ry);
        return SinProjection.verticalRotate(delta, fr * alpha, reflect);
    }

    private static double[] getRangeRotation(Range[] vxyzRanges, boolean reflect) {
        double[] center = new double[3];
        for (int id = 0; id < 3; ++id) {
            double[] bounds = vxyzRanges[id].getBounds();
            double mid = 0.5 * (bounds[0] + bounds[1]);
            if (Double.isNaN(mid)) {
                return null;
            }
            assert (mid >= -1.001 && mid <= 1.001);
            center[id] = mid;
        }
        if (Matrices.mod(center) < 0.3) {
            return null;
        }
        center = Matrices.normalise(center);
        return SinProjection.rotateToCenter(center, reflect);
    }

    private static abstract class Solver {
        private static final double SMALL = 4.84813681109536E-12;
        private static final int IMAX = 24;

        private Solver() {
        }

        abstract double[] derivs(double var1);

        double solve(double x0) {
            double x = x0;
            for (int i = 0; i < 24; ++i) {
                double[] dxs = this.derivs(x);
                double f0 = dxs[0];
                double f1 = dxs[1];
                if (Math.abs(f0) <= 4.84813681109536E-12) {
                    return x;
                }
                x -= f0 / f1;
            }
            return Double.NaN;
        }
    }
}

