/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.BasicTicker;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Orientation;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Tick;
import uk.ac.starlink.ttools.plot2.TickRun;
import uk.ac.starlink.ttools.plot2.Ticker;

public class SlaveTicker
implements Ticker {
    private final Axis masterAxis_;
    private final DoubleUnaryOperator masterToSlaveFunc_;
    private final Ticker basicTicker_;
    private Lut lut_;
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2");

    public SlaveTicker(Axis masterAxis, DoubleUnaryOperator masterToSlaveFunc, Ticker basicTicker) {
        this.masterAxis_ = masterAxis;
        this.masterToSlaveFunc_ = masterToSlaveFunc;
        this.basicTicker_ = basicTicker;
    }

    @Override
    public TickRun getTicks(double masterDlo, double masterDhi, boolean withMinor, Captioner captioner, Orientation[] orients, int npix, double crowding) {
        double slaveD1 = this.masterToSlave(masterDlo);
        double slaveD2 = this.masterToSlave(masterDhi);
        if (!PlotUtil.isFinite(slaveD1) || !PlotUtil.isFinite(slaveD2) || slaveD1 == slaveD2) {
            return new TickRun(new Tick[0], orients[0]);
        }
        double slaveDlo = slaveD1 < slaveD2 ? slaveD1 : slaveD2;
        double slaveDhi = slaveD1 < slaveD2 ? slaveD2 : slaveD1;
        TickRun slaveTickRun = this.basicTicker_.getTicks(slaveDlo, slaveDhi, withMinor, captioner, orients, npix, crowding);
        Tick[] slaveTicks = slaveTickRun.getTicks();
        Orientation slaveOrient = slaveTickRun.getOrientation();
        int ntick = slaveTicks.length;
        Tick[] outTicks = new Tick[ntick];
        for (int it = 0; it < ntick; ++it) {
            Tick slaveTick = slaveTicks[it];
            outTicks[it] = new Tick(this.slaveToMaster(slaveTick.getValue()), slaveTick.getLabel());
        }
        return new TickRun(outTicks, slaveOrient);
    }

    public double masterToSlave(double masterValue) {
        return this.masterToSlaveFunc_.applyAsDouble(masterValue);
    }

    public double slaveToMaster(double slaveValue) {
        return this.masterAxis_.graphicsToData(this.getLut().lookupIndex(slaveValue));
    }

    private Lut getLut() {
        if (this.lut_ == null) {
            int[] glims = this.masterAxis_.getGraphicsLimits();
            this.lut_ = Lut.createLut(ig -> this.masterToSlave(this.masterAxis_.graphicsToData(ig)), glims[0], glims[1]);
        }
        return this.lut_;
    }

    public static SlaveTicker createTicker(Axis masterAxis, DoubleUnaryOperator masterToSlaveFunc) {
        return new SlaveTicker(masterAxis, masterToSlaveFunc, SlaveTicker.chooseBasicTicker(masterAxis, masterToSlaveFunc));
    }

    private static Ticker chooseBasicTicker(Axis masterAxis, DoubleUnaryOperator masterToSlaveFunc) {
        double s2;
        int[] glims = masterAxis.getGraphicsLimits();
        int glo = glims[0];
        int ghi = glims[1];
        IntToDoubleFunction sfunc = g -> masterToSlaveFunc.applyAsDouble(masterAxis.graphicsToData(g));
        double s1 = sfunc.applyAsDouble(glo);
        double slo = s1 < (s2 = sfunc.applyAsDouble(ghi)) ? s1 : s2;
        double shi = s1 < s2 ? s2 : s1;
        double smid = sfunc.applyAsDouble((ghi + glo) / 2);
        if (slo <= 0.0 || shi <= 0.0 || smid <= 0.0) {
            return BasicTicker.LINEAR;
        }
        double linearMid = (smid - slo) / shi;
        double logMid = Math.log(smid / slo) / Math.log(shi / slo);
        if (Math.abs(linearMid - 0.5) < 0.1) {
            return BasicTicker.LINEAR;
        }
        if (Math.abs(logMid - 0.5) < Math.abs(linearMid - 0.5)) {
            return BasicTicker.LOG;
        }
        return BasicTicker.LINEAR;
    }

    private static class Lut {
        private final boolean isFlip_;
        private final double[] values_;
        private final int i0_;
        private final int length_;

        private Lut(double[] values, int i0, boolean isFlip) {
            this.values_ = values;
            this.i0_ = i0;
            this.isFlip_ = isFlip;
            this.length_ = values.length;
        }

        public double lookupIndex(double value) {
            double rawIndex = this.rawLookup(value);
            return (double)this.i0_ + (this.isFlip_ ? (double)(this.length_ - 1) - rawIndex : rawIndex);
        }

        private double rawLookup(double value) {
            int ip = Arrays.binarySearch(this.values_, value);
            if (ip >= 0) {
                return ip;
            }
            if (ip == -1) {
                return 0.0;
            }
            if (ip == -this.length_ - 1) {
                return this.length_ - 1;
            }
            int ig0 = -ip - 1;
            int ig1 = ig0 + 1;
            if (ig1 < this.length_) {
                double v0 = this.values_[ig0];
                double v1 = this.values_[ig1];
                double frac = (value - v0) / (v1 - v0);
                return (double)ig0 + frac;
            }
            return ig0;
        }

        public static Lut createLut(IntToDoubleFunction mapping, int ilo, int ihi) {
            boolean isFlip = mapping.applyAsDouble(ilo) > mapping.applyAsDouble(ihi);
            int n = ihi - ilo + 1;
            double[] values = new double[n];
            boolean isAscending = true;
            for (int i = 0; i < n; ++i) {
                int j = ilo + (isFlip ? n - 1 - i : i);
                values[i] = mapping.applyAsDouble(j);
                if (i <= 0 || !(values[i] < values[i - 1])) continue;
                isAscending = false;
            }
            if (!isAscending) {
                logger_.severe("Non-monotonic lookup table likely to cause trouble");
            }
            return new Lut(values, ilo, isFlip);
        }
    }
}

