/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.DVMap;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import uk.ac.starlink.ttools.func.Times;
import uk.ac.starlink.ttools.jel.JELUtils;

public class TimeJELFunction
implements DoubleUnaryOperator {
    private final String fexpr_;
    private final TimeResolver tResolver_;
    private final CompiledExpression fCompex_;
    private final Object[] args_;
    private static final Map<String, TimeQuantity> tqMap_ = TimeJELFunction.createTimeQuantityMap();

    public TimeJELFunction(String fexpr) throws CompilationException {
        this.fexpr_ = fexpr;
        Class[] staticLib = JELUtils.getStaticClasses().toArray(new Class[0]);
        this.tResolver_ = new TimeResolver();
        Class[] dynamicLib = new Class[]{this.tResolver_.getClass()};
        Library lib = JELUtils.createLibrary(staticLib, dynamicLib, this.tResolver_);
        this.fCompex_ = Evaluator.compile(fexpr, lib, Double.TYPE);
        this.args_ = new Object[]{this.tResolver_};
    }

    @Override
    public double applyAsDouble(double unixSec) {
        this.tResolver_.setUnixSec(unixSec);
        try {
            return this.fCompex_.evaluate_double(this.args_);
        }
        catch (Throwable e) {
            return Double.NaN;
        }
    }

    public String getExpression() {
        return this.fexpr_;
    }

    public static TimeQuantity[] getTimeQuantities() {
        return tqMap_.values().toArray(new TimeQuantity[0]);
    }

    private static Map<String, TimeQuantity> createTimeQuantityMap() {
        double daysPerSec = 1.1574074074074073E-5;
        double mjdEpoch = 40587.0;
        double jdEpoch = 2440587.5;
        TimeQuantity[] tqs = new TimeQuantity[]{new TimeQuantity("mjd", "Modified Julian Date", unixSec -> unixSec * 1.1574074074074073E-5 + 40587.0), new TimeQuantity("jd", "Julian Day", unixSec -> unixSec * 1.1574074074074073E-5 + 2440587.5), new TimeQuantity("decYear", "decimal year CE", unixSec -> Times.mjdToDecYear(Times.unixMillisToMjd((long)(unixSec * 1000.0)))), new TimeQuantity("unixSec", "seconds since 1970-01-01T00:00:00", unixSec -> unixSec)};
        LinkedHashMap<String, TimeQuantity> map = new LinkedHashMap<String, TimeQuantity>();
        for (TimeQuantity tq : tqs) {
            map.put(tq.getName().toLowerCase(), tq);
        }
        return Collections.unmodifiableMap(map);
    }

    public static class TimeResolver
    extends DVMap {
        private double unixSec_;

        @Override
        public String getTypeName(String name) {
            return tqMap_.containsKey(name.toLowerCase()) ? "Double" : null;
        }

        public double getDoubleProperty(String name) {
            TimeQuantity tq = (TimeQuantity)tqMap_.get(name.toLowerCase());
            return tq != null ? tq.fromUnixSeconds(this.unixSec_) : Double.NaN;
        }

        private void setUnixSec(double unixSec) {
            this.unixSec_ = unixSec;
        }
    }

    public static class TimeQuantity {
        final String name_;
        final String description_;
        final DoubleUnaryOperator fromUnixSec_;

        TimeQuantity(String name, String description, DoubleUnaryOperator fromUnixSec) {
            this.name_ = name;
            this.description_ = description;
            this.fromUnixSec_ = fromUnixSec;
        }

        public String getName() {
            return this.name_;
        }

        public String getDescription() {
            return this.description_;
        }

        public double fromUnixSeconds(double unixSec) {
            return this.fromUnixSec_.applyAsDouble(unixSec);
        }
    }
}

