/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.RangeCollector;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingArrayCoord;
import uk.ac.starlink.ttools.plot2.data.Input;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.layer.ShapePlotter;
import uk.ac.starlink.ttools.plot2.layer.ShapeStyle;
import uk.ac.starlink.ttools.plot2.layer.WrapperPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.XYArrayData;

public class ArrayShapePlotter
extends ShapePlotter {
    private final ShapeForm form_;
    private final FloatingArrayCoord xsCoord_;
    private final FloatingArrayCoord ysCoord_;
    private final int icXs_;
    private final int icYs_;

    public ArrayShapePlotter(String name, ShapeForm form, ShapeMode mode) {
        super(name, form, mode, ArrayShapePlotter.createArrayCoordGroup(form, mode));
        this.form_ = form;
        this.xsCoord_ = FloatingArrayCoord.X;
        this.ysCoord_ = FloatingArrayCoord.Y;
        CoordGroup cgrp = this.getCoordGroup();
        this.icXs_ = 0;
        this.icYs_ = 1;
    }

    @Override
    public int getModeCoordsIndex(DataGeom geom) {
        return 2 + this.form_.getExtraCoords().length;
    }

    @Override
    public PlotLayer createLayer(DataGeom pointDataGeom, final DataSpec dataSpec, ShapeStyle style) {
        PlotLayer baseLayer = super.createLayer(pointDataGeom, dataSpec, style);
        if (baseLayer == null) {
            return null;
        }
        final Function<Tuple, XYArrayData> xyReader = ArrayShapePlotter.createXYArrayReader(this.xsCoord_, this.ysCoord_, this.icXs_, this.icYs_, dataSpec);
        return new WrapperPlotLayer(baseLayer){

            @Override
            public void extendCoordinateRanges(Range[] ranges, Scale[] scales, DataStore dataStore) {
                super.extendCoordinateRanges(ranges, scales, dataStore);
                RangeCollector<TupleSequence> rangeCollector = new RangeCollector<TupleSequence>(2){

                    public void accumulate(TupleSequence tseq, Range[] ranges) {
                        ArrayShapePlotter.this.extendRanges(tseq, xyReader, ranges[0], ranges[1]);
                    }
                };
                Range[] arrayRanges = dataStore.getTupleRunner().collect(rangeCollector, () -> dataStore.getTupleSequence(dataSpec));
                rangeCollector.mergeRanges(ranges, arrayRanges);
            }
        };
    }

    public static ArrayShapePlotter[] createArrayShapePlotters(ShapeForm[] forms, ShapeMode[] modes) {
        int nf = forms.length;
        int nm = modes.length;
        ArrayShapePlotter[] plotters = new ArrayShapePlotter[nf * nm];
        int ip = 0;
        for (ShapeMode mode : modes) {
            for (ShapeForm form : forms) {
                String name = form.getFormName() + "-" + mode.getModeName();
                plotters[ip++] = new ArrayShapePlotter(name, form, mode);
            }
        }
        assert (ip == plotters.length);
        return plotters;
    }

    public static boolean matchesAxis(String axName, Input input) {
        return "X".equals(axName) && input.getMeta().getLongName().equals(FloatingArrayCoord.X.getInput().getMeta().getLongName()) || "Y".equals(axName) && input.getMeta().getLongName().equals(FloatingArrayCoord.Y.getInput().getMeta().getLongName());
    }

    private void extendRanges(TupleSequence tseq, Function<Tuple, XYArrayData> xyReader, Range xRange, Range yRange) {
        while (tseq.next()) {
            XYArrayData xyData = xyReader.apply(tseq);
            if (xyData == null) continue;
            int np = xyData.getLength();
            for (int ip = 0; ip < np; ++ip) {
                xRange.submit(xyData.getX(ip));
                yRange.submit(xyData.getY(ip));
            }
        }
    }

    public static Function<Tuple, XYArrayData> createXYArrayReader(FloatingArrayCoord xsCoord, FloatingArrayCoord ysCoord, int icXs, int icYs, DataSpec dataSpec) {
        boolean hasY;
        boolean hasX = !dataSpec.isCoordBlank(icXs);
        boolean bl = hasY = !dataSpec.isCoordBlank(icYs);
        if (hasX && hasY) {
            return tuple -> {
                final int np = xsCoord.getArrayCoordLength((Tuple)tuple, icXs);
                if (np > 0 && np == ysCoord.getArrayCoordLength((Tuple)tuple, icYs)) {
                    final double[] xs = xsCoord.readArrayCoord((Tuple)tuple, icXs);
                    final double[] ys = ysCoord.readArrayCoord((Tuple)tuple, icYs);
                    return new XYArrayData(){

                        @Override
                        public int getLength() {
                            return np;
                        }

                        @Override
                        public double getX(int i) {
                            return xs[i];
                        }

                        @Override
                        public double getY(int i) {
                            return ys[i];
                        }
                    };
                }
                return null;
            };
        }
        if (hasX) {
            return tuple -> {
                final double[] xs = xsCoord.readArrayCoord((Tuple)tuple, icXs);
                return xs != null && xs.length > 0 ? new XYArrayData(){

                    @Override
                    public int getLength() {
                        return xs.length;
                    }

                    @Override
                    public double getX(int i) {
                        return xs[i];
                    }

                    @Override
                    public double getY(int i) {
                        return i;
                    }
                } : null;
            };
        }
        if (hasY) {
            return tuple -> {
                final double[] ys = ysCoord.readArrayCoord((Tuple)tuple, icYs);
                return ys != null && ys.length > 0 ? new XYArrayData(){

                    @Override
                    public int getLength() {
                        return ys.length;
                    }

                    @Override
                    public double getX(int i) {
                        return i;
                    }

                    @Override
                    public double getY(int i) {
                        return ys[i];
                    }
                } : null;
            };
        }
        return null;
    }

    private static CoordGroup createArrayCoordGroup(ShapeForm form, ShapeMode mode) {
        ArrayList<Coord> clist = new ArrayList<Coord>();
        clist.add(FloatingArrayCoord.X);
        clist.add(FloatingArrayCoord.Y);
        clist.addAll(Arrays.asList(form.getExtraCoords()));
        clist.addAll(Arrays.asList(mode.getExtraCoords()));
        Coord[] coords = clist.toArray(new Coord[0]);
        boolean[] rangeCoordFlags = new boolean[coords.length];
        rangeCoordFlags[0] = true;
        rangeCoordFlags[1] = true;
        return CoordGroup.createNoBasicCoordGroup(coords, form.getExtraPositionCount(), rangeCoordFlags);
    }
}

