/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.Icon;
import uk.ac.starlink.ttools.func.Arrays;
import uk.ac.starlink.ttools.plot2.Equality;

@Equality
public class FillMode {
    private final String name_;
    private final String description_;
    private final float lineAlpha_;
    private final float fillAlpha_;
    public static final FillMode SOLID = new FillMode("Solid", 0.0, 1.0, "area between level and axis is filled with solid colour");
    public static final FillMode LINE = new FillMode("Line", 1.0, 0.0, "level is marked by a wiggly line");
    public static final FillMode SEMI = new FillMode("Semi", 1.0, 0.25, "level is marked by a wiggly line, and area below it is filled with a transparent colour");

    public FillMode(String name, double lineAlpha, double fillAlpha, String description) {
        this.name_ = name;
        this.lineAlpha_ = FillMode.normalise(lineAlpha);
        this.fillAlpha_ = FillMode.normalise(fillAlpha);
        this.description_ = description;
    }

    public String getName() {
        return this.name_;
    }

    public String getDescription() {
        return this.description_;
    }

    public float getLineAlpha() {
        return this.lineAlpha_;
    }

    public float getFillAlpha() {
        return this.fillAlpha_;
    }

    public boolean hasLine() {
        return this.lineAlpha_ > 0.0f;
    }

    public boolean hasFill() {
        return this.fillAlpha_ > 0.0f;
    }

    public boolean isOpaque() {
        return !(this.lineAlpha_ != 0.0f && this.lineAlpha_ != 1.0f || this.fillAlpha_ != 0.0f && this.fillAlpha_ != 1.0f);
    }

    public Icon createIcon(int[] data, Color color, final Stroke stroke, final int pad) {
        final int max = (int)Arrays.maximum(data);
        final int np = data.length + 2;
        final int[] xs = new int[np];
        final int[] ys = new int[np];
        for (int ip = 1; ip < np - 1; ++ip) {
            xs[ip] = ip + pad;
            ys[ip] = max - data[ip - 1] + pad;
        }
        xs[0] = pad;
        ys[0] = max + pad;
        xs[np - 1] = np - 1 + pad;
        ys[np - 1] = max + pad;
        float[] rgba = color.getComponents(null);
        final float cr = rgba[0];
        final float cg = rgba[1];
        final float cb = rgba[2];
        final float alpha = rgba[3];
        return new Icon(){

            @Override
            public int getIconWidth() {
                return np + 2 * pad;
            }

            @Override
            public int getIconHeight() {
                return max + 2 * pad;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g.create();
                g = null;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int x0 = x + pad;
                int y0 = y + pad;
                g2.translate(x0, y0);
                g2.clipRect(-pad, -pad, np * 2 + pad, max + pad);
                if (FillMode.this.lineAlpha_ > 0.0f) {
                    g2.setStroke(stroke);
                    g2.setColor(new Color(cr, cg, cb, alpha * FillMode.this.lineAlpha_));
                    g2.drawPolyline(xs, ys, np);
                }
                if (FillMode.this.fillAlpha_ > 0.0f) {
                    g2.setColor(new Color(cr, cg, cb, alpha * FillMode.this.fillAlpha_));
                    g2.fillPolygon(xs, ys, np);
                }
            }
        };
    }

    private static float normalise(double alpha) {
        if (alpha >= 0.0 && alpha <= 1.0) {
            return (float)alpha;
        }
        if (alpha > 1.0) {
            return 1.0f;
        }
        return 0.0f;
    }

    public int hashCode() {
        int code = 234202;
        code = 23 * code + Float.floatToIntBits(this.lineAlpha_);
        code = 23 * code + Float.floatToIntBits(this.fillAlpha_);
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof FillMode) {
            FillMode other = (FillMode)o;
            return this.lineAlpha_ == other.lineAlpha_ && this.fillAlpha_ == other.fillAlpha_;
        }
        return false;
    }

    public String toString() {
        return this.name_;
    }
}

