/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

public class Gridder {
    private final int nx_;
    private final int ny_;

    public Gridder(int nx, int ny) {
        this.nx_ = nx;
        this.ny_ = ny;
    }

    public int getWidth() {
        return this.nx_;
    }

    public int getHeight() {
        return this.ny_;
    }

    public int getIndex(int ix, int iy) {
        return iy * this.nx_ + ix;
    }

    public int getX(int index) {
        return index % this.nx_;
    }

    public int getY(int index) {
        return index / this.nx_;
    }

    public int getLength() {
        return this.nx_ * this.ny_;
    }

    public int hashCode() {
        int code = 5502432;
        code = 23 * code + this.nx_;
        code = 23 * code + this.ny_;
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof Gridder) {
            Gridder other = (Gridder)o;
            return this.nx_ == other.nx_ && this.ny_ == other.ny_;
        }
        return false;
    }

    public static Gridder transpose(final Gridder base) {
        return new Gridder(base.getHeight(), base.getWidth()){

            @Override
            public int getIndex(int ix, int iy) {
                return base.getIndex(iy, ix);
            }

            @Override
            public int getX(int index) {
                return base.getY(index);
            }

            @Override
            public int getY(int index) {
                return base.getX(index);
            }
        };
    }
}

