/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.geom.GPoint3D;
import uk.ac.starlink.ttools.plot2.layer.LineXYShape;
import uk.ac.starlink.ttools.plot2.layer.MarkForm;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.layer.StrokeXYShape;
import uk.ac.starlink.ttools.plot2.layer.XYShape;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;

public abstract class LineTracer3D {
    final PaperType3D paperType_;
    final Paper paper_;
    final CubeSurface surf_;
    private NPoint lastPoint_;
    private static final double LIMIT = 100.0;

    protected LineTracer3D(PaperType3D paperType, Paper paper, CubeSurface surf) {
        this.paperType_ = paperType;
        this.paper_ = paper;
        this.surf_ = surf;
    }

    public void addPoint(double[] dpos, Color color) {
        double sx = LineTracer3D.limit(this.surf_.normalise(dpos, 0));
        double sy = LineTracer3D.limit(this.surf_.normalise(dpos, 1));
        double sz = LineTracer3D.limit(this.surf_.normalise(dpos, 2));
        NPoint point = new NPoint(sx, sy, sz, color, this.surf_);
        if (this.lastPoint_ != null) {
            this.traceLine(this.lastPoint_, point);
        }
        this.lastPoint_ = point;
    }

    abstract void traceLine(NPoint var1, NPoint var2);

    public static LineTracer3D createTracer(PaperType3D paperType, Paper paper, CubeSurface surf, Stroke stroke) {
        return new SegmentTracer(paperType, paper, surf, stroke);
    }

    public static LineTracer3D createTracer(PaperType3D paperType, Paper paper, CubeSurface surf, int thickness, int pixgap) {
        return pixgap == 0 ? new SegmentTracer(paperType, paper, surf, new BasicStroke(thickness, 1, 1)) : new MarkTracer(paperType, paper, surf, MarkForm.createMarkGlyph(MarkerShape.FILLED_CIRCLE, thickness - 1, true), pixgap);
    }

    private static double limit(double s) {
        return Math.max(-100.0, Math.min(100.0, s));
    }

    private static boolean coincides(GPoint3D p1, GPoint3D p2) {
        return LineTracer3D.toInt(p1.x) == LineTracer3D.toInt(p2.x) && LineTracer3D.toInt(p1.y) == LineTracer3D.toInt(p2.y);
    }

    private static int toInt(double d) {
        return PlotUtil.ifloor(d);
    }

    private static class DoubleLineGlyph
    implements Glyph {
        private final double kx_;
        private final double ky_;
        private final XYShape shape_;
        private final Stroke stroke_;

        public DoubleLineGlyph(double kx, double ky, XYShape shape, Stroke stroke) {
            this.kx_ = kx;
            this.ky_ = ky;
            this.shape_ = shape;
            this.stroke_ = stroke;
        }

        @Override
        public Pixer createPixer(Rectangle clip) {
            return this.shape_.getGlyph((short)this.kx_, (short)this.ky_).createPixer(clip);
        }

        @Override
        public void paintGlyph(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke stroke0 = g2.getStroke();
            g2.setStroke(this.stroke_);
            g2.draw(new Line2D.Double(0.0, 0.0, this.kx_, this.ky_));
            g2.setStroke(stroke0);
        }
    }

    private static interface LineGlyphFactory {
        public Glyph getLineGlyph(double var1, double var3);
    }

    private static class NPoint {
        final double sx_;
        final double sy_;
        final double sz_;
        final Color color_;
        final CubeSurface surf_;
        final int regionX_;
        final int regionY_;
        final int regionZ_;
        GPoint3D gpoint_;

        NPoint(double sx, double sy, double sz, Color color, CubeSurface surf) {
            this.sx_ = sx;
            this.sy_ = sy;
            this.sz_ = sz;
            this.color_ = color;
            this.surf_ = surf;
            this.regionX_ = this.getRegion(this.sx_);
            this.regionY_ = this.getRegion(this.sy_);
            this.regionZ_ = this.getRegion(this.sz_);
        }

        boolean isSegmentVisible(NPoint other) {
            return this.regionX_ * other.regionX_ != 1 && this.regionY_ * other.regionY_ != 1 && this.regionZ_ * other.regionZ_ != 1;
        }

        GPoint3D getGraphicsPoint() {
            if (this.gpoint_ == null) {
                this.gpoint_ = new GPoint3D();
                this.surf_.normalisedToGraphicZ(this.sx_, this.sy_, this.sz_, this.gpoint_);
            }
            return this.gpoint_;
        }

        private int getRegion(double s) {
            return s >= -1.0 ? (s < 1.0 ? 0 : 1) : -1;
        }
    }

    private static class SegmentTracer
    extends LineTracer3D {
        private final LineGlyphFactory liner_;
        private static final int SEGMAX = 5;
        private static final int SEGMAX2 = 25;

        public SegmentTracer(PaperType3D paperType, Paper paper, CubeSurface surf, final Stroke stroke) {
            super(paperType, paper, surf);
            final XYShape lineShape = stroke.equals(LineXYShape.STROKE) ? LineXYShape.INSTANCE : new StrokeXYShape(stroke);
            this.liner_ = paperType.isBitmap() ? new LineGlyphFactory(){

                @Override
                public Glyph getLineGlyph(double kx, double ky) {
                    return lineShape.getGlyph((short)Math.round(kx), (short)Math.round(ky));
                }
            } : new LineGlyphFactory(){

                @Override
                public Glyph getLineGlyph(double kx, double ky) {
                    return new DoubleLineGlyph(kx, ky, lineShape, stroke);
                }
            };
        }

        @Override
        void traceLine(NPoint n0, NPoint n1) {
            if (n0.isSegmentVisible(n1)) {
                GPoint3D g1;
                GPoint3D g0 = n0.getGraphicsPoint();
                if (LineTracer3D.coincides(g0, g1 = n1.getGraphicsPoint())) {
                    if (g1.z < g0.z && !n0.color_.equals(n1.color_)) {
                        this.paperType_.placeGlyph(this.paper_, g0.x, g0.y, g1.z, this.liner_.getLineGlyph(0.0, 0.0), n1.color_);
                    }
                } else {
                    double kx = g1.x - g0.x;
                    double ky = g1.y - g0.y;
                    if (kx * kx + ky * ky < 25.0) {
                        Glyph glyph = this.liner_.getLineGlyph(kx, ky);
                        this.paperType_.placeGlyph(this.paper_, g0.x, g0.y, 0.5 * (g0.z + g1.z), glyph, this.bisect(n0.color_, n1.color_));
                    } else {
                        NPoint n2 = this.bisect(n0, n1);
                        this.traceLine(n0, n2);
                        this.traceLine(n2, n1);
                    }
                }
            }
        }

        private NPoint bisect(NPoint n1, NPoint n2) {
            return new NPoint(0.5 * (n1.sx_ + n2.sx_), 0.5 * (n1.sy_ + n2.sy_), 0.5 * (n1.sz_ + n2.sz_), this.bisect(n1.color_, n2.color_), this.surf_);
        }

        private Color bisect(Color c1, Color c2) {
            if (c1 == null || c2 == null) {
                return null;
            }
            if (c1.equals(c2)) {
                return c1;
            }
            return new Color(c1.getRed() + c2.getRed() >> 1, c1.getGreen() + c2.getGreen() >> 1, c1.getBlue() + c2.getBlue() >> 1);
        }
    }

    private static class MarkTracer
    extends LineTracer3D {
        private final Glyph glyph_;
        private final int pixgap_;

        public MarkTracer(PaperType3D paperType, Paper paper, CubeSurface surf, Glyph glyph, int pixgap) {
            super(paperType, paper, surf);
            this.glyph_ = glyph;
            this.pixgap_ = pixgap;
        }

        @Override
        void traceLine(NPoint n0, NPoint n1) {
            if (n0.isSegmentVisible(n1)) {
                GPoint3D g0 = n0.getGraphicsPoint();
                GPoint3D g1 = n1.getGraphicsPoint();
                double dx = g1.x - g0.x;
                double dy = g1.y - g0.y;
                double dz = g1.z - g0.z;
                double dist = Math.hypot(dx, dy);
                int np = (int)Math.ceil(dist / (double)this.pixgap_);
                for (int ip = 0; ip < np; ++ip) {
                    double f = (double)ip / (double)np;
                    Color color = MarkTracer.scaleColor(n0.color_, n1.color_, f);
                    this.paperType_.placeGlyph(this.paper_, g0.x + dx * f, g0.y + dy * f, g0.z + dz * f, this.glyph_, color);
                }
            }
        }

        private static Color scaleColor(Color c1, Color c2, double f) {
            if (c1 == null || c2 == null) {
                return null;
            }
            if (c1.equals(c2)) {
                return c1;
            }
            int r1 = c1.getRed();
            int g1 = c1.getGreen();
            int b1 = c1.getBlue();
            int r2 = c2.getRed();
            int g2 = c2.getGreen();
            int b2 = c2.getBlue();
            return new Color(r1 + (int)(f * (double)(r2 - r1)), g1 + (int)(f * (double)(g2 - g1)), b1 + (int)(f * (double)(b2 - b1)));
        }
    }
}

