/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.geom.SliceDataGeom;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.BinSizer;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.Cumulation;
import uk.ac.starlink.ttools.plot2.layer.Kernel1d;
import uk.ac.starlink.ttools.plot2.layer.Kernel1dShape;
import uk.ac.starlink.ttools.plot2.layer.Normalisation;
import uk.ac.starlink.ttools.plot2.layer.StandardKernel1dShape;
import uk.ac.starlink.ttools.plot2.layer.Unit;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.util.SplitCollector;

public abstract class Pixel1dPlotter<S extends Style>
implements Plotter<S> {
    private final FloatingCoord xCoord_;
    private final FloatingCoord weightCoord_;
    private final ConfigKey<Combiner> combinerKey_;
    private final String name_;
    private final Icon icon_;
    private final CoordGroup pixoCoordGrp_;
    private final int icX_;
    private final int icWeight_;
    private static final int MAX_KERNEL_WIDTH = 50;
    private static final int MAX_KERNEL_EXTENT = 150;
    public static final ReportKey<Double> SMOOTHWIDTH_KEY = ReportKey.createDoubleKey(new ReportMeta("smoothwidth", "Smoothing Width"), false);
    public static final ConfigKey<BinSizer> SMOOTHSIZER_KEY = BinSizer.createSizerConfigKey(new ConfigMeta("smooth", "Smoothing").setStringUsage("+<width>|-<count>").setShortDescription("Smoothing width specification").setXmlDescription(new String[]{"<p>Configures the smoothing width for kernel density", "estimation.", "This is the characteristic width of the kernel function", "to be convolved with the density to produce the visible plot.", "</p>", BinSizer.getConfigKeyDescription()}), SMOOTHWIDTH_KEY, 100, true);
    public static final ConfigKey<Kernel1dShape> KERNEL_KEY = new OptionConfigKey<Kernel1dShape>(new ConfigMeta("kernel", "Kernel").setShortDescription("Smoothing kernel functional form").setXmlDescription(new String[]{"<p>The functional form of the smoothing kernel.", "The functions listed refer to the unscaled shape;", "all kernels are normalised to give a total area of unity.", "</p>"}), Kernel1dShape.class, StandardKernel1dShape.getStandardOptions(), (Kernel1dShape)StandardKernel1dShape.EPANECHNIKOV){

        @Override
        public String getXmlDescription(Kernel1dShape kshape) {
            return kshape.getDescription();
        }
    }.setOptionUsage().addOptionsXml();

    protected Pixel1dPlotter(FloatingCoord xCoord, boolean hasWeight, ConfigKey<Unit> unitKey, String name, Icon icon) {
        this.xCoord_ = xCoord;
        this.name_ = name;
        this.icon_ = icon;
        if (hasWeight) {
            this.weightCoord_ = FloatingCoord.WEIGHT_COORD;
            this.pixoCoordGrp_ = CoordGroup.createPartialCoordGroup(new Coord[]{xCoord, this.weightCoord_}, new boolean[]{true, true});
        } else {
            this.weightCoord_ = null;
            this.pixoCoordGrp_ = CoordGroup.createPartialCoordGroup(new Coord[]{xCoord}, new boolean[]{true});
        }
        this.combinerKey_ = Pixel1dPlotter.createCombinerKey(this.weightCoord_, unitKey);
        this.icX_ = this.pixoCoordGrp_.getExtraCoordIndex(0, null);
        this.icWeight_ = hasWeight ? this.pixoCoordGrp_.getExtraCoordIndex(1, null) : -1;
    }

    @Override
    public String getPlotterName() {
        return this.name_;
    }

    @Override
    public Icon getPlotterIcon() {
        return this.icon_;
    }

    @Override
    public CoordGroup getCoordGroup() {
        return this.pixoCoordGrp_;
    }

    @Override
    public boolean hasReports() {
        return false;
    }

    protected String getWeightingDescription() {
        if (this.icWeight_ >= 0) {
            return PlotUtil.concatLines(new String[]{"<p>A weighting may be applied to the calculated levels", "by supplying the", "<code>" + this.weightCoord_.getInput().getMeta().getShortName() + "</code>", "coordinate.", "In this case you can choose how these weights are aggregated", "in each pixel bin using the", "<code>" + this.combinerKey_.getMeta().getShortName() + "</code>", "parameter.", "The result is something like a smoothed version of the", "corresponding weighted histogram.", "Note that some combinations of the available parameters", "(e.g. a normalised cumulative median-aggregated KDE)", "may not make much visual sense.", "</p>"});
        }
        return "";
    }

    protected abstract boolean isY(S var1);

    protected abstract LayerOpt getLayerOpt(S var1);

    protected abstract int getPixelPadding(S var1, PlanarSurface var2);

    protected abstract Combiner getCombiner(S var1);

    protected abstract void paintBins(PlanarSurface var1, BinArray var2, S var3, Graphics2D var4);

    protected abstract void extendPixel1dCoordinateRanges(Range[] var1, Scale[] var2, S var3, DataSpec var4, DataStore var5);

    protected abstract ReportMap getPixel1dReport(Pixel1dPlan var1, S var2, Scale var3);

    public ConfigKey<Combiner> getCombinerKey() {
        return this.combinerKey_;
    }

    @Override
    public PlotLayer createLayer(DataGeom geom, DataSpec dataSpec, S style) {
        if (dataSpec == null || style == null) {
            return null;
        }
        final boolean isY = this.isY(style);
        LayerOpt layerOpt = this.getLayerOpt(style);
        SliceDataGeom pixoDataGeom = isY ? new SliceDataGeom(new FloatingCoord[]{null, this.xCoord_}, "Y") : new SliceDataGeom(new FloatingCoord[]{this.xCoord_, null}, "X");
        return new AbstractPlotLayer(this, pixoDataGeom, dataSpec, (Style)style, layerOpt, (Style)style, dataSpec, layerOpt){
            final /* synthetic */ Style val$style;
            final /* synthetic */ DataSpec val$dataSpec;
            final /* synthetic */ LayerOpt val$layerOpt;
            {
                this.val$style = style2;
                this.val$dataSpec = dataSpec2;
                this.val$layerOpt = layerOpt;
                super(plotter, geom, dataSpec, style, opt);
            }

            @Override
            public Drawing createDrawing(Surface surface, Map<AuxScale, Span> auxSpans, final PaperType paperType) {
                if (!(surface instanceof PlanarSurface)) {
                    throw new IllegalArgumentException("Not planar surface " + surface);
                }
                final PlanarSurface pSurf = (PlanarSurface)surface;
                final Axis xAxis = pSurf.getAxes()[isY ? 1 : 0];
                final Scale xScale = pSurf.getScales()[isY ? 1 : 0];
                final int xpad = Pixel1dPlotter.this.getPixelPadding(this.val$style, pSurf);
                final Combiner combiner = Pixel1dPlotter.this.getCombiner(this.val$style);
                return new Drawing(){

                    @Override
                    public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
                        for (int ip = 0; ip < knownPlans.length; ++ip) {
                            Pixel1dPlan plan;
                            if (!(knownPlans[ip] instanceof Pixel1dPlan) || !(plan = (Pixel1dPlan)knownPlans[ip]).matches(xAxis, xpad, combiner, val$dataSpec)) continue;
                            return plan;
                        }
                        BinArray binArray = Pixel1dPlotter.this.readBins(xAxis, 50, combiner, val$dataSpec, dataStore);
                        return new Pixel1dPlan(binArray, xAxis, 50, combiner, val$dataSpec);
                    }

                    @Override
                    public void paintData(Object plan, Paper paper, DataStore dataStore) {
                        Pixel1dPlan pPlan = (Pixel1dPlan)plan;
                        final BinArray binArray = pPlan.binArray_;
                        paperType.placeDecal(paper, new Decal(){

                            @Override
                            public void paintDecal(Graphics g) {
                                Pixel1dPlotter.this.paintBins(pSurf, binArray, val$style, (Graphics2D)g);
                            }

                            @Override
                            public boolean isOpaque() {
                                return val$layerOpt.isOpaque();
                            }
                        });
                    }

                    @Override
                    public ReportMap getReport(Object plan) {
                        return plan instanceof Pixel1dPlan ? Pixel1dPlotter.this.getPixel1dReport((Pixel1dPlan)plan, val$style, xScale) : null;
                    }
                };
            }

            @Override
            public void extendCoordinateRanges(Range[] ranges, Scale[] scales, DataStore dataStore) {
                Pixel1dPlotter.this.extendPixel1dCoordinateRanges(ranges, scales, this.val$style, this.val$dataSpec, dataStore);
            }
        };
    }

    public int getWeightCoordIndex() {
        return this.icWeight_;
    }

    public BinArray readBins(final Axis xAxis, int padPix, final Combiner combiner, DataSpec dataSpec, DataStore dataStore) {
        int[] glimits = xAxis.getGraphicsLimits();
        final int ilo = glimits[0] - padPix;
        final int ihi = glimits[1] + padPix;
        final boolean isUnweighted = this.weightCoord_ == null || dataSpec.isCoordBlank(this.icWeight_);
        SplitCollector<TupleSequence, BinAccumulator> collector = new SplitCollector<TupleSequence, BinAccumulator>(){

            public BinAccumulator createAccumulator() {
                return new BinAccumulator(ilo, ihi, combiner);
            }

            public void accumulate(TupleSequence tseq, BinAccumulator binAcc) {
                if (isUnweighted) {
                    while (tseq.next()) {
                        double dx = Pixel1dPlotter.this.xCoord_.readDoubleCoord(tseq, Pixel1dPlotter.this.icX_);
                        double gx = xAxis.dataToGraphics(dx);
                        binAcc.submitToBin(gx, 1.0);
                    }
                } else {
                    while (tseq.next()) {
                        double w = Pixel1dPlotter.this.weightCoord_.readDoubleCoord(tseq, Pixel1dPlotter.this.icWeight_);
                        if (!PlotUtil.isFinite(w)) continue;
                        double dx = Pixel1dPlotter.this.xCoord_.readDoubleCoord(tseq, Pixel1dPlotter.this.icX_);
                        double gx = xAxis.dataToGraphics(dx);
                        binAcc.submitToBin(gx, w);
                    }
                }
            }

            public BinAccumulator combine(BinAccumulator acc1, BinAccumulator acc2) {
                acc1.add(acc2);
                return acc1;
            }
        };
        return PlotUtil.tupleCollect(collector, dataSpec, dataStore).getResult();
    }

    public static double[] getDataBins(BinArray binArray, Axis xAxis, Kernel1d kernel, Normalisation norm, Combiner.Type ctype, Unit unit, Cumulation cumul) {
        double binWidth;
        double[] bins = binArray.getBins();
        int nb = bins.length;
        if (kernel != null) {
            bins = kernel.convolve(bins);
        }
        double max = 0.0;
        for (int ib = 0; ib < bins.length; ++ib) {
            double val = bins[ib];
            if (Double.isNaN(val)) continue;
            max = Math.max(max, Math.abs(val));
        }
        double total = binArray.loBin_ + binArray.midBin_ + binArray.hiBin_;
        double scale = norm.getScaleFactor(total, max, binWidth = PlotUtil.getPixelScaleExtent(xAxis) / unit.getExtent(), ctype, cumul.isCumulative());
        if (scale != 1.0) {
            double[] nbins = new double[nb];
            for (int ib = 0; ib < nb; ++ib) {
                nbins[ib] = scale * bins[ib];
            }
            bins = nbins;
        }
        if (cumul.isCumulative()) {
            double[] dlimits = xAxis.getDataLimits();
            boolean xflip = xAxis.dataToGraphics(dlimits[0]) > xAxis.dataToGraphics(dlimits[1]) ^ cumul.isReverse();
            double[] cbins = new double[nb];
            double sum = scale * (xflip ? binArray.hiBin_ : binArray.loBin_);
            for (int ib = 0; ib < nb; ++ib) {
                int jb = xflip ? nb - ib - 1 : ib;
                double value = bins[jb];
                if (!Double.isNaN(value)) {
                    sum += bins[jb];
                }
                cbins[jb] = sum;
            }
            bins = cbins;
        }
        return bins;
    }

    public static int getEffectiveExtent(Kernel1d kernel) {
        return Math.min(kernel.getExtent(), 150);
    }

    public static Kernel1d createKernel(Kernel1dShape kernelShape, BinSizer sizer, Axis xAxis, boolean isMean) {
        double width = Pixel1dPlotter.getPixelWidth(sizer, xAxis);
        return isMean ? kernelShape.createMeanKernel(width) : kernelShape.createFixedWidthKernel(width);
    }

    public static double getPixelWidth(BinSizer sizer, Axis xAxis) {
        double[] dLimits = xAxis.getDataLimits();
        int[] gLimits = xAxis.getGraphicsLimits();
        int gExtent = gLimits[1] - gLimits[0];
        Scale xScale = xAxis.getScale();
        double sWidth = sizer.getScaleWidth(xScale, dLimits[0], dLimits[1], false);
        double slo = xScale.dataToScale(dLimits[0]);
        double shi = xScale.dataToScale(dLimits[1]);
        return Math.abs((double)gExtent * (sWidth / (shi - slo)));
    }

    private static ConfigKey<Combiner> createCombinerKey(FloatingCoord weightCoord, ConfigKey<Unit> unitKey) {
        ConfigMeta meta = new ConfigMeta("combine", "Combine");
        boolean hasUnit = unitKey != null;
        meta.setShortDescription("Weight combination mode");
        StringBuffer dbuf = new StringBuffer();
        dbuf.append(PlotUtil.concatLines(new String[]{"<p>Defines how values contributing to the same bin", "are combined together to produce the value assigned to that bin,", "and hence its height.", "The bins in this case are 1-pixel wide, so lack much physical", "significance.", "This means that while some combination modes, such as", "<code>" + Combiner.WEIGHTED_DENSITY + "</code> and", "<code>" + Combiner.MEAN + "</code> make sense,", "others such as", "<code>" + Combiner.SUM + "</code> do not.", "</p>", "<p>The combined values are those given by the", "<code>" + weightCoord.getInput().getMeta().getShortName() + "</code> coordinate,", "but if no weight is supplied,", "a weighting of unity is assumed.", "</p>"}));
        if (hasUnit) {
            dbuf.append(PlotUtil.concatLines(new String[]{"<p>For density-like values", "(<code>" + Combiner.DENSITY + "</code>,", "<code>" + Combiner.WEIGHTED_DENSITY + "</code>)", "the scaling is additionally influenced by the", "<code>" + unitKey.getMeta().getShortName() + "</code>", "parameter.", "</p>"}));
        }
        meta.setXmlDescription(dbuf.toString());
        OptionConfigKey<Combiner> key = new OptionConfigKey<Combiner>(meta, Combiner.class, Combiner.getKnownCombiners(), Combiner.WEIGHTED_DENSITY){

            @Override
            public String getXmlDescription(Combiner combiner) {
                return combiner.getDescription();
            }
        };
        key.setOptionUsage();
        key.addOptionsXml();
        return key;
    }

    private static class BinAccumulator {
        private final Combiner.Container[] bins_;
        private final Combiner.Container loBin_;
        private final Combiner.Container hiBin_;
        private final Combiner.Container midBin_;
        private final int glo_;
        private final int ghi_;

        BinAccumulator(int glo, int ghi, Combiner combiner) {
            this.glo_ = glo;
            this.ghi_ = ghi;
            int nbin = ghi - glo;
            this.bins_ = new Combiner.Container[nbin];
            for (int i = 0; i < nbin; ++i) {
                this.bins_[i] = combiner.createContainer();
            }
            this.loBin_ = combiner.createContainer();
            this.hiBin_ = combiner.createContainer();
            this.midBin_ = combiner.createContainer();
        }

        void submitToBin(double gx, double inc) {
            double dx = Math.round(gx - (double)this.glo_);
            if (dx >= 0.0 && dx < (double)this.bins_.length) {
                this.bins_[(int)dx].submit(inc);
                this.midBin_.submit(inc);
            } else if (dx < 0.0) {
                this.loBin_.submit(inc);
            } else if (dx >= (double)this.bins_.length) {
                this.hiBin_.submit(inc);
            }
        }

        void add(BinAccumulator other) {
            this.loBin_.add(other.loBin_);
            this.hiBin_.add(other.hiBin_);
            this.midBin_.add(other.midBin_);
            for (int i = 0; i < this.bins_.length; ++i) {
                this.bins_[i].add(other.bins_[i]);
            }
        }

        BinArray getResult() {
            double[] dbins = new double[this.bins_.length];
            for (int i = 0; i < this.bins_.length; ++i) {
                double val;
                dbins[i] = val = this.bins_[i].getCombinedValue();
            }
            double loBin = this.getDefiniteValue(this.loBin_);
            double hiBin = this.getDefiniteValue(this.hiBin_);
            double midBin = this.getDefiniteValue(this.midBin_);
            return new BinArray(this.glo_, this.ghi_, dbins, loBin, hiBin, midBin);
        }

        private double getDefiniteValue(Combiner.Container container) {
            double d = container.getCombinedValue();
            return Double.isNaN(d) ? 0.0 : d;
        }
    }

    public static class BinArray {
        private final int glo_;
        private final int ghi_;
        private final double[] bins_;
        private final double loBin_;
        private final double hiBin_;
        private final double midBin_;

        private BinArray(int glo, int ghi, double[] bins, double loBin, double hiBin, double midBin) {
            this.glo_ = glo;
            this.ghi_ = ghi;
            this.bins_ = bins;
            this.loBin_ = loBin;
            this.hiBin_ = hiBin;
            this.midBin_ = midBin;
        }

        public double[] getBins() {
            return this.bins_;
        }

        public int getBinIndex(int gx) {
            return gx - this.glo_;
        }

        public int getGraphicsCoord(int index) {
            return index + this.glo_;
        }
    }

    public static class Pixel1dPlan {
        final BinArray binArray_;
        final Axis xAxis_;
        final int xpad_;
        final Combiner combiner_;
        final DataSpec dataSpec_;

        Pixel1dPlan(BinArray binArray, Axis xAxis, int xpad, Combiner combiner, DataSpec dataSpec) {
            this.binArray_ = binArray;
            this.xAxis_ = xAxis;
            this.xpad_ = xpad;
            this.combiner_ = combiner;
            this.dataSpec_ = dataSpec;
        }

        boolean matches(Axis xAxis, int xpad, Combiner combiner, DataSpec dataSpec) {
            return this.xAxis_.equals(xAxis) && this.combiner_.equals(combiner) && this.dataSpec_.equals(dataSpec) && this.xpad_ >= xpad;
        }
    }
}

