/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.layer.DrawingGlyph;
import uk.ac.starlink.ttools.plot2.layer.FillPixer;
import uk.ac.starlink.ttools.plot2.layer.LineGlyph;
import uk.ac.starlink.ttools.plot2.layer.PixelDrawing;
import uk.ac.starlink.ttools.plot2.layer.PixerFactory;
import uk.ac.starlink.ttools.plot2.layer.StrokeKit;

@Equality
public abstract class PolygonShape {
    private final String name_;
    private final String description_;
    public static final PolygonShape[] POLYSHAPES = PolygonShape.createPolygonShapes();

    protected PolygonShape(String name, String description) {
        this.name_ = name;
        this.description_ = description;
    }

    public abstract Glyph createPolygonGlyph(int var1, int var2, int[] var3, int[] var4, int var5);

    public abstract PolygonShape toThicker(int var1);

    public String getName() {
        return this.name_;
    }

    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.name_;
    }

    private static Rectangle getBounds(int[] xs, int[] ys, int np) {
        if (np > 0) {
            int xlo = xs[0];
            int ylo = ys[0];
            int xhi = xs[0];
            int yhi = ys[0];
            for (int ip = 0; ip < np; ++ip) {
                xlo = Math.min(xlo, xs[ip]);
                ylo = Math.min(ylo, ys[ip]);
                xhi = Math.max(xhi, xs[ip]);
                yhi = Math.max(yhi, ys[ip]);
            }
            return new Rectangle(xlo, ylo, xhi - xlo + 1, yhi - ylo + 1);
        }
        return new Rectangle();
    }

    private static PolygonShape[] createPolygonShapes() {
        return new PolygonShape[]{PolygonShape.createOutlineShape("outline", "draws a line round the outside of the polygon", false), PolygonShape.createOutlineShape("border", "draws a line butting up to the outside of the polygon; may look better for adjacent shapes, but more expensive to draw", true), PolygonShape.createFillShape("fill", "fills the interior of the polygon"), PolygonShape.createCrossShape("cross", "draws a line round the outside of the polygon and lines between all the vertices"), PolygonShape.createStarShape("star", "draws a line round the outside of the polygon and lines from the nominal center to each vertex")};
    }

    private static PolygonShape createOutlineShape(String name, String descrip, boolean isClip) {
        return new LineShape(name, descrip, isClip){

            @Override
            public LineGlyph createPolygonGlyph(int x0, int y0, final int[] xs, final int[] ys, final int np) {
                return new LineGlyph(){

                    @Override
                    public void paintGlyph(Graphics g, StrokeKit strokeKit) {
                        Graphics2D g2 = (Graphics2D)g;
                        Stroke stroke0 = g2.getStroke();
                        g2.setStroke(strokeKit.getRound());
                        g2.drawPolygon(xs, ys, np);
                        g2.setStroke(stroke0);
                    }

                    @Override
                    public Rectangle getPixelBounds() {
                        return PolygonShape.getBounds(xs, ys, np);
                    }

                    @Override
                    public void drawShape(PixelDrawing drawing) {
                        for (int ip = 0; ip < np; ++ip) {
                            int ip1 = (ip + 1) % np;
                            drawing.drawLine(xs[ip], ys[ip], xs[ip1], ys[ip1]);
                        }
                    }
                };
            }
        };
    }

    private static PolygonShape createCrossShape(String name, String descrip) {
        return new LineShape(name, descrip, false){

            @Override
            public LineGlyph createPolygonGlyph(int x0, int y0, final int[] xs, final int[] ys, final int np) {
                return new ClipLineGlyph(xs, ys, np){

                    @Override
                    public void paintInterior(Graphics g) {
                        for (int ip = 0; ip < np; ++ip) {
                            for (int ip2 = ip + 2; ip2 < np; ++ip2) {
                                g.drawLine(xs[ip], ys[ip], xs[ip2], ys[ip2]);
                            }
                        }
                    }

                    @Override
                    public void drawInterior(PixelDrawing d) {
                        for (int ip = 0; ip < np; ++ip) {
                            for (int ip2 = ip + 2; ip2 < np; ++ip2) {
                                d.drawLine(xs[ip], ys[ip], xs[ip2], ys[ip2]);
                            }
                        }
                    }
                };
            }
        };
    }

    private static PolygonShape createStarShape(String name, String descrip) {
        return new LineShape(name, descrip, false){

            @Override
            public LineGlyph createPolygonGlyph(final int x0, final int y0, final int[] xs, final int[] ys, final int np) {
                return new ClipLineGlyph(xs, ys, np){

                    @Override
                    public void paintInterior(Graphics g) {
                        for (int ip = 0; ip < np; ++ip) {
                            g.drawLine(x0, y0, xs[ip], ys[ip]);
                        }
                    }

                    @Override
                    public void drawInterior(PixelDrawing d) {
                        for (int ip = 0; ip < np; ++ip) {
                            d.drawLine(x0, y0, xs[ip], ys[ip]);
                        }
                    }
                };
            }
        };
    }

    private static PolygonShape createFillShape(String name, String descrip) {
        return new PolygonShape(name, descrip){

            @Override
            public Glyph createPolygonGlyph(int x0, int y0, final int[] xs, final int[] ys, final int np) {
                return new Glyph(){

                    @Override
                    public void paintGlyph(Graphics g) {
                        g.fillPolygon(xs, ys, np);
                    }

                    @Override
                    public Pixer createPixer(Rectangle clip) {
                        return PolygonShape.getBounds(xs, ys, np).intersects(clip) ? new FillPixer(xs, ys, np, clip) : null;
                    }
                };
            }

            @Override
            public PolygonShape toThicker(int nthick) {
                return this;
            }
        };
    }

    private static abstract class ClipLineGlyph
    extends LineGlyph {
        private final int[] xs_;
        private final int[] ys_;
        private final int np_;

        ClipLineGlyph(int[] xs, int[] ys, int np) {
            this.xs_ = xs;
            this.ys_ = ys;
            this.np_ = np;
        }

        abstract void paintInterior(Graphics var1);

        abstract void drawInterior(PixelDrawing var1);

        @Override
        public Rectangle getPixelBounds() {
            return PolygonShape.getBounds(this.xs_, this.ys_, this.np_);
        }

        @Override
        public void paintGlyph(Graphics g, StrokeKit strokeKit) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke stroke0 = g2.getStroke();
            Shape clip0 = g2.getClip();
            g2.setStroke(strokeKit.getRound());
            g2.clip(new Polygon(this.xs_, this.ys_, this.np_));
            this.paintInterior(g2);
            g2.setClip(clip0);
            g2.drawPolygon(this.xs_, this.ys_, this.np_);
            g2.setStroke(stroke0);
        }

        @Override
        public void drawShape(PixelDrawing drawing) {
            PixelDrawing mask = new PixelDrawing(drawing.getMinX(), drawing.getMinY(), drawing.getMaxX() - drawing.getMinX() + 1, drawing.getMaxY() - drawing.getMinY() + 1);
            mask.fillPolygon(this.xs_, this.ys_, this.np_);
            this.drawInterior(drawing);
            drawing.getPixels().and(mask.getPixels());
            for (int ip = 0; ip < this.np_; ++ip) {
                int ip1 = (ip + 1) % this.np_;
                drawing.drawLine(this.xs_[ip], this.ys_[ip], this.xs_[ip1], this.ys_[ip1]);
            }
        }
    }

    private static class ClipGlyph
    implements Glyph {
        private final DrawingGlyph baseGlyph_;
        private final int[] xs_;
        private final int[] ys_;
        private final int np_;

        ClipGlyph(DrawingGlyph baseGlyph, int[] xs, int[] ys, int np) {
            this.baseGlyph_ = baseGlyph;
            this.xs_ = xs;
            this.ys_ = ys;
            this.np_ = np;
        }

        @Override
        public void paintGlyph(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Shape clip0 = g2.getClip();
            g2.clip(new Polygon(this.xs_, this.ys_, this.np_));
            this.baseGlyph_.paintGlyph(g2);
            g2.setClip(clip0);
        }

        @Override
        public Pixer createPixer(Rectangle clip) {
            PixelDrawing drawing = this.baseGlyph_.createPixerFactory(clip);
            if (drawing == null) {
                return null;
            }
            PixelDrawing mask = new PixelDrawing(drawing.getMinX(), drawing.getMinY(), drawing.getMaxX() - drawing.getMinX() + 1, drawing.getMaxY() - drawing.getMinY() + 1);
            mask.fillPolygon(this.xs_, this.ys_, this.np_);
            drawing.getPixels().and(mask.getPixels());
            return drawing.createPixer();
        }
    }

    private static class FatShape
    extends PolygonShape {
        private final LineShape lineShape_;
        private final int nthick_;
        private final boolean isClip_;
        private final PixerFactory kernel_;
        private final StrokeKit strokeKit_;

        FatShape(LineShape lineShape, int nthick, boolean isClip) {
            super(lineShape.getName() + nthick, lineShape.getDescription() + " at line thickness " + nthick);
            this.lineShape_ = lineShape;
            this.nthick_ = nthick;
            this.isClip_ = isClip;
            this.kernel_ = LineGlyph.createThickKernel(nthick);
            this.strokeKit_ = LineGlyph.createThickStrokeKit(nthick);
        }

        @Override
        public Glyph createPolygonGlyph(int x0, int y0, int[] xs, int[] ys, int np) {
            DrawingGlyph thickGlyph = this.lineShape_.createPolygonGlyph(x0, y0, xs, ys, np).toThicker(this.kernel_, this.strokeKit_);
            return this.isClip_ ? new ClipGlyph(thickGlyph, xs, ys, np) : thickGlyph;
        }

        @Override
        public PolygonShape toThicker(int nthick) {
            return this;
        }

        public int hashCode() {
            int code = -558294;
            code = 23 * code + this.lineShape_.hashCode();
            code = 23 * code + this.nthick_;
            code = 23 * code + (this.isClip_ ? 11 : 17);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof FatShape) {
                FatShape other = (FatShape)o;
                return this.lineShape_.equals(other.lineShape_) && this.nthick_ == other.nthick_ && this.isClip_ == other.isClip_;
            }
            return false;
        }
    }

    private static abstract class LineShape
    extends PolygonShape {
        private final boolean isClip_;

        LineShape(String name, String description, boolean isClip) {
            super(name, description);
            this.isClip_ = isClip;
        }

        @Override
        public abstract LineGlyph createPolygonGlyph(int var1, int var2, int[] var3, int[] var4, int var5);

        @Override
        public FatShape toThicker(int nthick) {
            return new FatShape(this, nthick, this.isClip_);
        }
    }
}

