/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.geom.GPoint3D;
import uk.ac.starlink.ttools.plot2.layer.FloatingCoordAuxReader;
import uk.ac.starlink.ttools.plot2.layer.MarkForm;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.PixOutliner;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapePainter;
import uk.ac.starlink.ttools.plot2.layer.ShapeStyle;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;

public class SizeForm
implements ShapeForm {
    private static final FloatingCoord SIZE_COORD = FloatingCoord.createCoord(new InputMeta("size", "Size").setShortDescription("Marker size (pixels or auto)").setXmlDescription(new String[]{"<p>Size to draw each sized marker.", "Units are pixels unless auto-scaling is in effect,", "in which case units are arbitrary.", "The plotted size is also affected by the", "<code>" + StyleKeys.SCALE_PIX.getMeta().getShortName() + "</code>", "value.", "</p>"}), false);
    private static final AuxScale SIZE_SCALE = new AuxScale("globalsize");
    private static final SizeForm instance_ = new SizeForm();

    private SizeForm() {
    }

    @Override
    public int getBasicPositionCount() {
        return 1;
    }

    @Override
    public String getFormName() {
        return "Size";
    }

    @Override
    public Icon getFormIcon() {
        return ResourceIcon.FORM_SIZE;
    }

    @Override
    public String getFormDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots a marker of fixed shape but variable size", "at each position.", "The size is determined by an additional input data value.", "</p>", "<p>The actual size of the markers depends on the setting of the", "<code>" + StyleKeys.AUTOSCALE_PIX.getMeta().getShortName() + "</code>", "parameter.", "If autoscaling is off, then the basic size of each marker", "is the input data value in units of pixels.", "If autoscaling is on, then the data values are gathered", "for all the currently visible points, and a scaling factor", "is applied so that the largest ones will be a sensible size", "(a few tens of pixels).", "This basic size can be further adjusted with the", "<code>" + StyleKeys.SCALE_PIX.getMeta().getShortName() + "</code> factor.", "</p>", "<p>Currently data values of zero always correspond to", "marker size of zero, negative data values are not represented,", "and the mapping is linear.", "An absolute maximum of", Integer.toString(100), "pixels is also imposed on marker sizes.", "Other options may be introduced in future.", "</p>", "<p>Note: for marker sizes that correspond to data values", "in data coordinates,", "you may find Error plotting more appropriate.", "</p>"});
    }

    @Override
    public Coord[] getExtraCoords() {
        return new Coord[]{SIZE_COORD};
    }

    @Override
    public int getExtraPositionCount() {
        return 0;
    }

    @Override
    public DataGeom adjustGeom(DataGeom geom, DataSpec dataSpec, ShapeStyle style) {
        return geom;
    }

    @Override
    public ConfigKey<?>[] getConfigKeys() {
        return new ConfigKey[]{StyleKeys.MARKER_SHAPE, StyleKeys.SCALE_PIX, StyleKeys.AUTOSCALE_PIX};
    }

    @Override
    public Outliner createOutliner(ConfigMap config) {
        MarkerShape shape = config.get(StyleKeys.MARKER_SHAPE);
        boolean isAutoscale = config.get(StyleKeys.AUTOSCALE_PIX);
        double scale = config.get(StyleKeys.SCALE_PIX) * (double)(isAutoscale ? 20 : 1);
        boolean isGlobal = true;
        AuxScale autoscale = isAutoscale ? (isGlobal ? SIZE_SCALE : new AuxScale("size1")) : null;
        return new SizeOutliner(shape, scale, autoscale, 100);
    }

    public static SizeForm getInstance() {
        return instance_;
    }

    private static int getSizeCoordIndex(DataGeom geom) {
        return geom.getPosCoords().length;
    }

    public static class SizeOutliner
    extends PixOutliner {
        private final MarkerShape shape_;
        private final AuxScale autoscale_;
        private final double scale_;
        private final int sizeLimit_;
        private final Icon icon_;
        private final Map<Integer, Glyph> glyphMap_;

        public SizeOutliner(MarkerShape shape, double scale, AuxScale autoscale, int sizeLimit) {
            this.shape_ = shape;
            this.scale_ = scale;
            this.autoscale_ = autoscale;
            this.sizeLimit_ = sizeLimit;
            this.icon_ = MarkForm.createLegendIcon(shape, 4);
            this.glyphMap_ = new HashMap<Integer, Glyph>();
        }

        @Override
        public Icon getLegendIcon() {
            return this.icon_;
        }

        @Override
        public Map<AuxScale, AuxReader> getAuxRangers(DataGeom geom) {
            HashMap<AuxScale, AuxReader> map = new HashMap<AuxScale, AuxReader>();
            if (this.autoscale_ != null) {
                FloatingCoordAuxReader sizeReader = new FloatingCoordAuxReader(SIZE_COORD, SizeForm.getSizeCoordIndex(geom), geom, true, null);
                map.put(this.autoscale_, sizeReader);
            }
            return map;
        }

        @Override
        public boolean canPaint(DataSpec dataSpec) {
            return true;
        }

        @Override
        public ShapePainter create2DPainter(final Surface surface, final DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, final PaperType2D paperType) {
            final double[] dpos = new double[surface.getDataDimCount()];
            final Point2D.Double gpos = new Point2D.Double();
            final int icSize = SizeForm.getSizeCoordIndex(geom);
            final double scale = this.scale_ * this.getBaseScale(surface, auxSpans);
            return new ShapePainter(){

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    double size;
                    if (geom.readDataPos(tuple, 0, dpos) && surface.dataToGraphics(dpos, true, gpos) && PlotUtil.isFinite(size = SIZE_COORD.readDoubleCoord(tuple, icSize))) {
                        int isize = (int)Math.round(size * scale);
                        Glyph glyph = this.getGlyph(isize);
                        paperType.placeGlyph(paper, gpos.x, gpos.y, glyph, color);
                    }
                }
            };
        }

        @Override
        public ShapePainter create3DPainter(final CubeSurface surface, final DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, final PaperType3D paperType) {
            final double[] dpos = new double[surface.getDataDimCount()];
            final GPoint3D gpos = new GPoint3D();
            final int icSize = SizeForm.getSizeCoordIndex(geom);
            final double scale = this.scale_ * this.getBaseScale(surface, auxSpans);
            return new ShapePainter(){

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    double size;
                    if (geom.readDataPos(tuple, 0, dpos) && surface.dataToGraphicZ(dpos, true, gpos) && PlotUtil.isFinite(size = SIZE_COORD.readDoubleCoord(tuple, icSize))) {
                        int isize = (int)Math.round(size * scale);
                        Glyph glyph = this.getGlyph(isize);
                        paperType.placeGlyph(paper, gpos.x, gpos.y, gpos.z, glyph, color);
                    }
                }
            };
        }

        public boolean equals(Object o) {
            if (o instanceof SizeOutliner) {
                SizeOutliner other = (SizeOutliner)o;
                return this.shape_.equals(other.shape_) && this.scale_ == other.scale_ && PlotUtil.equals(this.autoscale_, other.autoscale_) && this.sizeLimit_ == other.sizeLimit_;
            }
            return false;
        }

        public int hashCode() {
            int code = 4451;
            code = 23 * code + this.shape_.hashCode();
            code = 23 * code + Float.floatToIntBits((float)this.scale_);
            code = 23 * code + PlotUtil.hashCode(this.autoscale_);
            code = 23 * code + this.sizeLimit_;
            return code;
        }

        private Glyph getGlyph(int isize) {
            Glyph glyph = this.glyphMap_.get(isize = Math.min(this.sizeLimit_, Math.max(0, isize)));
            if (glyph == null) {
                glyph = MarkForm.createMarkGlyph(this.shape_, isize, true);
                this.glyphMap_.put(isize, glyph);
            }
            return glyph;
        }

        private double getBaseScale(Surface surface, Map<AuxScale, Span> spanMap) {
            if (this.autoscale_ != null) {
                Span span = spanMap.get(this.autoscale_);
                double[] bounds = span.getFiniteBounds(true);
                return 1.0 / bounds[1];
            }
            return 1.0;
        }
    }
}

