/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.paper;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.paper.Compositor;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.RgbImage;
import uk.ac.starlink.ttools.plot2.paper.RgbPaperType2D;

public class CompositePaperType2D
extends RgbPaperType2D {
    private final Compositor compositor_;

    public CompositePaperType2D(Compositor compositor) {
        super("PixelComposite", false);
        this.compositor_ = compositor;
    }

    @Override
    protected RgbPaperType2D.RgbPaper2D createPaper2D(Rectangle bounds) {
        return new CompositePaper(this, bounds);
    }

    private static class CompositePaper
    extends RgbPaperType2D.RgbPaper2D {
        private final float[] frgba_ = new float[4];
        private final Compositor.Buffer composBuf_;
        private Color lastColor_;
        private float lastAlpha_;
        private float lastR_;
        private float lastG_;
        private float lastB_;

        CompositePaper(CompositePaperType2D paperType, Rectangle bounds) {
            super(paperType, bounds);
            this.composBuf_ = paperType.compositor_.createBuffer(bounds.width * bounds.height);
        }

        @Override
        public boolean canMerge() {
            return false;
        }

        @Override
        public Paper createSheet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void mergeSheet(Paper other) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void placeDecal(Decal decal) {
            Rectangle bounds = this.getBounds();
            boolean hasAlpha = !decal.isOpaque();
            int bg = 0;
            RgbImage rgbim = RgbImage.createRgbImage(bounds.width, bounds.height, hasAlpha, bg);
            int[] rgbBuf = rgbim.getBuffer();
            Graphics2D g = rgbim.getImage().createGraphics();
            ((Graphics)g).translate(-bounds.x, -bounds.y);
            decal.paintDecal(g);
            g.dispose();
            int npix = bounds.width * bounds.height;
            if (hasAlpha) {
                for (int i = 0; i < npix; ++i) {
                    int rgba = rgbBuf[i];
                    if (rgba == bg) continue;
                    this.composBuf_.addSample(i, rgba);
                }
            } else {
                for (int i = 0; i < npix; ++i) {
                    int rgb = rgbBuf[i];
                    if (rgb == bg) continue;
                    this.composBuf_.addSample(i, rgb, 1.0f);
                }
            }
        }

        @Override
        protected void placePixels(int xoff, int yoff, Pixer pixer, Color color) {
            if (color != this.lastColor_) {
                this.lastColor_ = color;
                color.getRGBComponents(this.frgba_);
                this.lastR_ = this.frgba_[0];
                this.lastG_ = this.frgba_[1];
                this.lastB_ = this.frgba_[2];
                this.lastAlpha_ = this.frgba_[3];
            }
            while (pixer.next()) {
                this.composBuf_.addSample(this.getPixelIndex(xoff, yoff, pixer), this.lastR_, this.lastG_, this.lastB_, this.lastAlpha_);
            }
        }

        @Override
        public void flush() {
            int[] rgbs = this.getRgbImage().getBuffer();
            int npix = rgbs.length;
            for (int i = 0; i < npix; ++i) {
                rgbs[i] = Compositor.srcOverOpaque(this.composBuf_.toRgbInt(i), rgbs[i]);
            }
        }
    }
}

