/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.paper;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import uk.ac.starlink.ttools.plot.PictureImageIcon;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Slow;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public abstract class PaintPaperType
implements PaperType {
    private final String name_;
    private final boolean upLayer_;
    private static final GraphicsConfiguration HEADLESS_GC = PaintPaperType.createHeadlessGraphicsConfig(1);
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.paper");

    protected PaintPaperType(String name, boolean upLayer) {
        this.name_ = name;
        this.upLayer_ = upLayer;
    }

    @Override
    public boolean isBitmap() {
        return false;
    }

    @Override
    public Icon createDataIcon(Surface surface, Drawing[] drawings, Object[] plans, DataStore dataStore, boolean cached) {
        PaintIcon icon = new PaintIcon(surface, drawings, plans, dataStore, this);
        if (cached) {
            BufferedImage image = PictureImageIcon.createImage(PlotUtil.toPicture(icon), HEADLESS_GC, Color.WHITE, null);
            return new ImageIcon(image);
        }
        return icon;
    }

    protected abstract Paper createPaper(Graphics var1, Rectangle var2);

    protected abstract void flushPaper(Paper var1);

    public String toString() {
        return this.name_;
    }

    public static GraphicsConfiguration createHeadlessGraphicsConfig(int imtype) {
        BufferedImage im = new BufferedImage(1, 1, imtype);
        Graphics2D g = im.createGraphics();
        GraphicsConfiguration gconf = g.getDeviceConfiguration();
        g.dispose();
        return gconf;
    }

    private static class PaintIcon
    implements Icon {
        private final Surface surface_;
        private final Drawing[] drawings_;
        private final Object[] plans_;
        private final DataStore dataStore_;
        private final PaintPaperType paperType_;
        private final Rectangle plotBounds_;

        PaintIcon(Surface surface, Drawing[] drawings, Object[] plans, DataStore dataStore, PaintPaperType paperType) {
            this.surface_ = surface;
            this.drawings_ = drawings;
            this.plans_ = plans;
            this.dataStore_ = dataStore;
            this.paperType_ = paperType;
            this.plotBounds_ = surface.getPlotBounds();
        }

        @Override
        public int getIconWidth() {
            return this.plotBounds_.width;
        }

        @Override
        public int getIconHeight() {
            return this.plotBounds_.height;
        }

        @Override
        @Slow
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(MarkerShape.OUTLINE_CIRCLE_HINT, this.paperType_.isBitmap());
            g2.translate(x - this.plotBounds_.x, y - this.plotBounds_.y);
            g2.clipRect(this.plotBounds_.x, this.plotBounds_.y, this.plotBounds_.width, this.plotBounds_.height);
            this.surface_.paintBackground(g2);
            Paper paper = this.paperType_.createPaper(g2, this.plotBounds_);
            int nlayer = this.drawings_.length;
            for (int il = 0; il < nlayer; ++il) {
                int jl = this.paperType_.upLayer_ ? il : nlayer - 1 - il;
                this.drawings_[jl].paintData(this.plans_[jl], paper, this.dataStore_);
            }
            long startFlush = System.currentTimeMillis();
            this.paperType_.flushPaper(paper);
            PlotUtil.logTimeFromStart(logger_, "Flush", startFlush);
        }
    }
}

