/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.paper;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.paper.PaintPaperType;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;

public abstract class PaintPaperType2D
extends PaintPaperType
implements PaperType2D {
    protected PaintPaperType2D() {
        super("Paint2D", true);
    }

    @Override
    protected Paper createPaper(Graphics g, Rectangle bounds) {
        return new Paper2D(this, (Graphics2D)g);
    }

    @Override
    protected void flushPaper(Paper paper) {
    }

    @Override
    public void placeDecal(Paper paper, Decal decal) {
        decal.paintDecal(((Paper2D)paper).graphics_);
    }

    public static PaintPaperType2D createPaperType(boolean quantise) {
        if (quantise) {
            return new PaintPaperType2D(){

                @Override
                public void placeGlyph(Paper paper, double dx, double dy, Glyph glyph, Color color) {
                    int gx = PlotUtil.ifloor(dx);
                    int gy = PlotUtil.ifloor(dy);
                    Graphics2D g = ((Paper2D)paper).graphics_;
                    Color color0 = g.getColor();
                    g.setColor(color);
                    ((Graphics)g).translate(gx, gy);
                    glyph.paintGlyph(g);
                    ((Graphics)g).translate(-gx, -gy);
                    g.setColor(color0);
                }
            };
        }
        return new PaintPaperType2D(){

            @Override
            public void placeGlyph(Paper paper, double dx, double dy, Glyph glyph, Color color) {
                Graphics2D g2 = ((Paper2D)paper).graphics_;
                Color color0 = g2.getColor();
                g2.setColor(color);
                g2.translate(dx, dy);
                glyph.paintGlyph(g2);
                g2.translate(-dx, -dy);
                g2.setColor(color0);
            }
        };
    }

    private static class Paper2D
    implements Paper {
        final PaperType paperType_;
        final Graphics2D graphics_;

        Paper2D(PaperType paperType, Graphics2D graphics) {
            this.paperType_ = paperType;
            this.graphics_ = graphics;
        }

        @Override
        public PaperType getPaperType() {
            return this.paperType_;
        }

        @Override
        public boolean canMerge() {
            return false;
        }

        @Override
        public Paper createSheet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void mergeSheet(Paper other) {
            throw new UnsupportedOperationException();
        }
    }
}

