/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotType;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.Input;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.task.ParameterFinder;

public abstract class PlotContext<P, A> {
    private final PlotType<P, A> plotType_;
    private final DataGeom[] exampleGeoms_;
    public static final String GEOM_PARAM_NAME = "geom";

    protected PlotContext(PlotType<P, A> plotType, DataGeom[] exampleGeoms) {
        this.plotType_ = plotType;
        this.exampleGeoms_ = exampleGeoms;
    }

    public PlotType<P, A> getPlotType() {
        return this.plotType_;
    }

    public DataGeom[] getExampleGeoms() {
        return this.exampleGeoms_;
    }

    public abstract Parameter<?> getGeomParameter(String var1);

    public abstract DataGeom getGeom(Environment var1, String var2) throws TaskException;

    public static <P, A> PlotContext<P, A> createStandardContext(PlotType<P, A> plotType) {
        final DataGeom[] geoms = plotType.getPointDataGeoms();
        return new PlotContext<P, A>(plotType, geoms){

            @Override
            public DataGeom getGeom(Environment env, String suffix) throws TaskException {
                return (DataGeom)new ParameterFinder<Parameter<DataGeom>>(){

                    @Override
                    public Parameter<DataGeom> createParameter(String sfix) {
                        return this.getGeomParameter(sfix);
                    }
                }.getParameter(env, suffix).objectValue(env);
            }

            @Override
            public Parameter<DataGeom> getGeomParameter(String suffix) {
                return new DataGeomParameter(PlotContext.GEOM_PARAM_NAME, suffix, geoms);
            }
        };
    }

    public static <P, A> PlotContext<P, A> createFixedContext(PlotType<P, A> plotType, final DataGeom geom) {
        return new PlotContext<P, A>(plotType, new DataGeom[]{geom}){

            @Override
            public Parameter<?> getGeomParameter(String suffix) {
                return null;
            }

            @Override
            public DataGeom getGeom(Environment env, String suffix) {
                return geom;
            }
        };
    }

    private static class DataGeomParameter
    extends ChoiceParameter<DataGeom> {
        public DataGeomParameter(String name, String suffix, DataGeom[] geoms) {
            super(name + suffix, (Object[])geoms);
            this.setDefaultOption(geoms[0]);
            this.setPrompt("Data geometry variant for layer " + suffix);
            StringBuffer sbuf = new StringBuffer();
            for (DataGeom geom : geoms) {
                sbuf.append("<li>").append("<code>").append(this.stringifyOption(geom)).append("</code>: ");
                int iin = 0;
                for (Coord coord : geom.getPosCoords()) {
                    for (Input input : coord.getInputs()) {
                        if (iin++ > 0) {
                            sbuf.append(", ");
                        }
                        InputMeta meta = input.getMeta();
                        sbuf.append("<code>").append(meta.getShortName()).append(suffix).append("</code>");
                        String desc = meta.getShortDescription();
                        if (desc == null) continue;
                        sbuf.append(" (").append(desc).append(")");
                    }
                }
                sbuf.append("</li>\n");
            }
            String optsTxt = sbuf.toString();
            this.setDescription(new String[]{"<p>Selects the geometry for coordinates of data in layer", "<code>" + suffix + "</code>.", "This determines what parameters must be supplied", "to specify coordinate data for that layer.", "</p>", "<p>Options, with the (suffixed) coordinate parameters", "they require, are:", "<ul>", optsTxt, "</ul>", "</p>"});
        }

        public String stringifyOption(DataGeom geom) {
            return geom.getVariantName().toLowerCase();
        }
    }
}

