/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.scheme;

import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import java.util.stream.Stream;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.scheme.AttractorFamily;

public class AttractorStarTable
extends AbstractStarTable {
    private final AttractorFamily.Attractor att_;
    private final long nrow_;
    private final int ndim_;
    private final ColumnInfo[] colInfos_;
    public static final ValueInfo ATTRACTOR_INFO = new DefaultValueInfo("Attractor", String.class);
    public static final ValueInfo FILL_INFO = new DefaultValueInfo("FillFactor", Double.class, "Proportion of space filled");

    public AttractorStarTable(AttractorFamily.Attractor att, long nrow) {
        this.att_ = att;
        this.nrow_ = nrow;
        this.ndim_ = att.getFamily().getDimCount();
        this.colInfos_ = new ColumnInfo[this.ndim_];
        for (int id = 0; id < this.ndim_; ++id) {
            char nchr = this.ndim_ <= 3 ? "xyz".charAt(id) : (char)(97 + id);
            this.colInfos_[id] = new ColumnInfo(Character.toString(nchr), Double.class, "Value of dimension #" + id);
            this.colInfos_[id].setUCD("pos.cartesian." + nchr);
        }
        this.setParameter(new DescribedValue(ATTRACTOR_INFO, (Object)att.toString()));
    }

    public int getColumnCount() {
        return this.ndim_;
    }

    public long getRowCount() {
        return this.nrow_;
    }

    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    public RowSequence getRowSequence() {
        Stream<double[]> stream = this.att_.pointStream().skip(100L);
        if (this.nrow_ >= 0L) {
            stream = stream.limit(this.nrow_);
        }
        final Iterator it = stream.iterator();
        return new RowSequence(){
            double[] point_;

            public boolean next() {
                if (it.hasNext()) {
                    this.point_ = (double[])it.next();
                    return true;
                }
                return false;
            }

            public Double getCell(int ic) {
                if (this.point_ != null) {
                    return this.point_[ic];
                }
                throw new IllegalStateException();
            }

            public Object[] getRow() {
                if (this.point_ != null) {
                    Object[] row = new Object[AttractorStarTable.this.ndim_];
                    for (int id = 0; id < AttractorStarTable.this.ndim_; ++id) {
                        row[id] = this.point_[id];
                    }
                    return row;
                }
                throw new IllegalStateException();
            }

            public void close() {
            }
        };
    }

    public static void writeFiles(AttractorFamily family, int nrow, int nfile) throws IOException {
        Random rnd = new Random(4429772L);
        StarTableOutput sto = new StarTableOutput();
        int ig = 0;
        while (ig < nfile) {
            AttractorFamily.Attractor attractor = family.createAttractor(rnd);
            double frac = AttractorFamily.getSpaceFraction(attractor, 100);
            if (frac > family.getFillThreshold()) {
                String loc = family.getName() + ++ig + ".fits";
                System.out.println("\n" + loc + "\t" + ig + "/" + nfile + "\t" + frac + "\t" + attractor);
                AttractorStarTable table = new AttractorStarTable(attractor, nrow);
                table.setParameter(new DescribedValue(FILL_INFO, (Object)frac));
                sto.writeStarTable((StarTable)table, loc, "fits");
                continue;
            }
            System.out.print(".");
        }
    }

    public static void main(String[] args) throws IOException {
        String usage = AttractorStarTable.class.getName() + " [nrow] [nfile]";
        int nrow = 10000000;
        int nfile = 8;
        try {
            nrow = (int)Double.parseDouble(args[0]);
            if (args.length > 1) {
                nfile = Integer.parseInt(args[1]);
            }
        }
        catch (RuntimeException e) {
            System.err.println(usage);
            System.exit(1);
        }
        Random rnd = new Random(456623L);
        for (AttractorFamily family : new AttractorFamily[]{AttractorFamily.CLIFFORD, AttractorFamily.RAMPE}) {
            AttractorStarTable.writeFiles(family, nrow, nfile);
        }
    }
}

