/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.server;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.plot.GraphicExporter;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.PlotCaching;
import uk.ac.starlink.ttools.plot2.PlotScene;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.DataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.DiskCache;
import uk.ac.starlink.ttools.plot2.task.PlotConfiguration;
import uk.ac.starlink.ttools.plot2.task.TypedPlot2Task;
import uk.ac.starlink.ttools.server.PlotService;
import uk.ac.starlink.ttools.server.PlotServletEnvironment;
import uk.ac.starlink.ttools.server.PlotSession;
import uk.ac.starlink.ttools.server.SoftCache;
import uk.ac.starlink.ttools.server.StiltsContext;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.util.LoadException;
import uk.ac.starlink.util.ObjectFactory;
import uk.ac.starlink.util.Pair;

public class PlotServlet
extends HttpServlet {
    private PlotCaching caching_;
    private ObjectFactory<TypedPlot2Task<?, ?>> taskFactory_;
    private Set<String> taskNameSet_;
    private Map<String, PlotService> serviceMap_;
    private StarTableFactory tableFactory_;
    private DataStoreFactory dataStoreFactory_;
    private DiskCache imgCache_;
    private StarTableOutput tableOutput_;
    private JDBCAuthenticator jdbcAuth_;
    private SoftCache<String, PlotSession<?, ?>> sessionCache_;
    private String servletId_;
    private String acao_;
    private Logger logger_;
    private static final String UTF8 = "UTF-8";
    private static final String EXAMPLE_HTML = "basic-plots.html";
    private static final String EXAMPLE_IPYNB = "basic-plots.ipynb";
    private static final String PYTHON_IPYNB = "plotserv.py";
    private static final String DFLT_ALLOWORIGINS = "*";
    private static final Map<String, String> MIME_TYPES = PlotServlet.mimeTypes();
    public static final String BASEURL_SUBST = "%PLOTSERV_URL%";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            PlotSession.init();
        }
        catch (IOException e) {
            throw new ServletException("Initialisation error: " + e, (Throwable)e);
        }
        this.caching_ = PlotCaching.createFullyCached();
        this.taskFactory_ = Stilts.getPlot2TaskFactory();
        this.taskNameSet_ = new HashSet<String>(Arrays.asList(this.taskFactory_.getNickNames()));
        this.serviceMap_ = PlotServlet.createServiceMap();
        this.jdbcAuth_ = null;
        ServletContext context = config.getServletContext();
        StiltsContext sContext = new StiltsContext(context);
        this.tableFactory_ = sContext.getTableFactory();
        this.dataStoreFactory_ = sContext.getDataStoreFactory();
        this.imgCache_ = sContext.getImageCache();
        this.tableOutput_ = new StarTableOutput();
        this.sessionCache_ = new SoftCache();
        this.servletId_ = PlotServlet.createId((Object)this);
        String acao = sContext.getAllowOrigins();
        this.acao_ = acao == null ? DFLT_ALLOWORIGINS : acao;
        this.logger_ = Logger.getLogger("uk.ac.starlink.ttools.server");
    }

    public void destroy() {
        this.sessionCache_.clear();
        super.destroy();
    }

    public String getServletInfo() {
        return "STILTS plot2 servlet " + Stilts.getVersion() + "; See https://www.starlink.ac.uk/stilts/";
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doProcess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doProcess(request, response);
    }

    private void doProcess(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.acao_ != null) {
            response.setHeader("Access-Control-Allow-Origin", this.acao_);
        }
        try {
            this.process(request, response);
        }
        catch (IOException | Error | RuntimeException | ServletException e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    private void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PlotSession<?, ?> session;
        String plotTxt;
        PlotService service;
        response.setHeader("X-STILTS-Version", Stilts.getVersion());
        String prefix = request.getContextPath() + request.getServletPath();
        String path = request.getRequestURI();
        assert (path.startsWith(prefix));
        String subPath = path.substring(prefix.length());
        if (subPath.indexOf(47) == 0 && subPath.length() > 1 && ((Object)((Object)this)).getClass().getResource(subPath.substring(1)) != null) {
            String resourceFile = subPath.substring(1);
            int idot = resourceFile.lastIndexOf(46);
            String extension = idot >= 0 ? resourceFile.substring(idot) : null;
            String contentType = MIME_TYPES.get(extension);
            if (contentType != null) {
                response.setContentType(contentType);
            } else {
                this.logger_.warning("Unknown MIME type for " + resourceFile);
            }
            response.setStatus(200);
            InputStream rIn = ((Object)((Object)this)).getClass().getResourceAsStream(resourceFile);
            if (".py".equals(extension) || ".ipynb".equals(extension) || ".html".equals(extension)) {
                String requestUrl = request.getRequestURL().toString();
                int islash = requestUrl.lastIndexOf(47);
                String baseUrl = requestUrl.substring(0, islash);
                BufferedReader rdr = new BufferedReader(new InputStreamReader(rIn, UTF8));
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), UTF8));
                String line = null;
                while ((line = rdr.readLine()) != null) {
                    writer.write(line.replaceAll(BASEURL_SUBST, baseUrl));
                    writer.newLine();
                }
                writer.flush();
            } else {
                IOUtils.copy((InputStream)rIn, (OutputStream)response.getOutputStream());
            }
            rIn.close();
            return;
        }
        Matcher matcher = Pattern.compile("/+([a-z]+)/+(.*)").matcher(subPath);
        if (matcher.matches()) {
            String requestMode = matcher.group(1);
            service = this.serviceMap_.get(requestMode);
            plotTxt = matcher.group(2);
        } else {
            plotTxt = null;
            service = null;
        }
        if (service == null) {
            response.setStatus(400);
            response.setContentType("text/html");
            response.getOutputStream().println(this.getHelpHtml(request));
            return;
        }
        String sessionId = PlotServlet.getSingleParameter(request, "sessionId");
        if (sessionId == null) {
            if (service.canCreateSession()) {
                sessionId = this.servletId_ + "-" + PlotServlet.createId(plotTxt);
            } else {
                response.sendError(400, "No sessionId");
                return;
            }
        }
        if ((session = this.sessionCache_.get(sessionId)) == null) {
            try {
                session = this.createSession(plotTxt, response);
            }
            catch (Throwable e) {
                this.replyError(response, 500, e);
                return;
            }
            if (session == null) {
                response.sendError(400, "Bad plot request");
                return;
            }
            this.sessionCache_.put(sessionId, session);
            this.sessionCache_.purge();
        }
        service.sessionRespond(session, request, response);
    }

    private PlotSession<?, ?> createSession(String plotTxt, HttpServletResponse response) throws IOException, InterruptedException, LoadException, TaskException {
        ArrayList<String> words = new ArrayList<String>(Arrays.asList(plotTxt.split("&")));
        String taskName = (String)words.remove(0);
        if (!this.taskNameSet_.contains(taskName)) {
            return null;
        }
        assert (this.taskFactory_.isRegistered(taskName));
        TypedPlot2Task task = (TypedPlot2Task)this.taskFactory_.createObject(taskName);
        ArrayList<Pair<String>> nvPairs = new ArrayList<Pair<String>>();
        for (String word : words) {
            int ieq = word.indexOf(61);
            if (ieq <= 0) {
                throw new TaskException("Word \"" + word + "\" not of form <name>=<value>");
            }
            String name = URLDecoder.decode(word.substring(0, ieq), UTF8);
            String value = URLDecoder.decode(word.substring(ieq + 1), UTF8);
            nvPairs.add((Pair<String>)new Pair((Object)name, (Object)value));
        }
        PlotServletEnvironment env = new PlotServletEnvironment(response, nvPairs, this.tableFactory_, this.tableOutput_, this.jdbcAuth_, this.dataStoreFactory_);
        Executable exec = task.createExecutable(env);
        exec.execute();
        PlotConfiguration<?, ?> plotConfig = env.getPlotConfiguration();
        GraphicExporter exporter = env.getGraphicExporter();
        return this.createPlotSession(plotTxt, plotConfig, exporter);
    }

    private <P, A> PlotSession<P, A> createPlotSession(String plotTxt, PlotConfiguration<P, A> plotConfig, GraphicExporter exporter) throws IOException, InterruptedException {
        DataStore dataStore = plotConfig.createDataStore(null);
        PlotScene<P, A> scene = plotConfig.createPlotScene(dataStore, this.caching_);
        Navigator<A> navigator = plotConfig.createNavigator();
        Dimension size = plotConfig.getPlotSize();
        return new PlotSession<P, A>(plotTxt, scene, navigator, exporter, dataStore, size, this.imgCache_);
    }

    private void replyPlain(HttpServletResponse response, int code, String text) throws IOException, ServletException {
        if (response.isCommitted()) {
            throw new ServletException("Error after response commit");
        }
        response.setStatus(code);
        response.setContentType("text/plain");
        PrintStream pout = new PrintStream((OutputStream)response.getOutputStream());
        pout.println(text);
        pout.flush();
    }

    private void replyError(HttpServletResponse response, int code, Throwable error) throws IOException, ServletException {
        if (response.isCommitted()) {
            throw new ServletException("Error after response commit", error);
        }
        response.setStatus(code);
        response.setContentType("text/plain");
        PrintStream pout = new PrintStream((OutputStream)response.getOutputStream());
        error.printStackTrace(pout);
        pout.flush();
    }

    private static String createId(Object object) {
        int value = 9901;
        value = 23 * value + (int)System.nanoTime();
        value = 23 * value + System.identityHashCode(object);
        return String.format("%08x", value);
    }

    private String getHelpHtml(HttpServletRequest request) {
        String hostPart = request.getRequestURL().toString().replaceFirst("([^/:])/.*", "$1");
        String prefix = request.getContextPath() + request.getServletPath();
        return String.join((CharSequence)"\n", "<html>", "<head>", "<meta charset='UTF-8'>", "<title>STILTS Plot server bad request</title>", "</head>", "<body>", "<h2>Malformed plot request</h2>", "<p>This is STILTS plot server version ", Stilts.getVersion() + ".", "</p>", "<p>The requested URL did not conform to the syntax requirements", "of this plot servlet.", "For documentation, please see below.", "</p>", "<h2>Plot Server Documentation</h2>", this.getHtmlDocumentation(hostPart, prefix), "</body>", "</html>", "");
    }

    private String getHtmlDocumentation(String hostPart, String prefix) {
        String baseUrl = hostPart + prefix;
        String standaloneExample = baseUrl + "/" + PlotSession.HTML_SERVICE.getServiceName() + "/plot2plane&amp;layer1=function&amp;fexpr1=0.5%2B0.4*x*sin(x*40)";
        String plotDocref = "<a href='http://www.starlink.ac.uk/stilts/sun256/plot2.html'>SUN/256</a>.";
        String jslibRef = "<a href='" + prefix + "/" + "plot2Lib.js" + "'>" + "plot2Lib.js" + "</a>";
        return String.join((CharSequence)"\n", "<h3>Usage and Examples</h3>", "<ul>", "<li>Basic standalone plot example: " + PlotServlet.alink(standaloneExample) + "</li>", "<li>Library for embedding interactive plots: " + jslibRef + "</li>", "<li>Examples using plot2Lib.js: " + PlotServlet.alink(EXAMPLE_HTML) + "</li>", "<li>Example Jupyter notebook (using " + PlotServlet.alink(PYTHON_IPYNB) + "): " + PlotServlet.alink(EXAMPLE_IPYNB) + "</li>", "</ul>", "<p>The easiest way to insert interactive plots", "in your web pages is by using", jslibRef, "as in the examples above,", "but you can also write your own JavaScript client using the API", "described below.", "</p>", "", PlotServlet.getHtmlSyntaxDocumentation(baseUrl, this.serviceMap_, plotDocref));
    }

    public static String getXmlSyntaxDocumentation() throws IOException, TransformerException {
        String plotDocref = "<ref id='plot2'/>";
        String helpHtml = PlotServlet.getHtmlSyntaxDocumentation("&lt;base-url&gt;", PlotServlet.createServiceMap(), plotDocref);
        return DocUtils.fromXhtml(helpHtml);
    }

    private static String getHtmlSyntaxDocumentation(String baseUrl, Map<String, PlotService> serviceMap, String plotDocref) {
        StringBuffer sbuf = new StringBuffer().append(String.join((CharSequence)"\n", "<h3>General URL Syntax</h3>", "<p>The plot service accepts URLs of the form", "<pre>", "   &lt;base-url&gt;/&lt;action-type&gt;/&lt;plot-spec&gt;[?&lt;session-id&gt;&amp;&lt;arg-list&gt;]", "</pre>", "</p>", "<p>These parts are expanded as follows:", "<dl>", ""));
        if (baseUrl.startsWith("http")) {
            sbuf.append(String.join((CharSequence)"\n", "<dt><code>&lt;base-url&gt;</code></dt>", "<dd>For this service, the base URL is <code><a href='" + baseUrl + "'>" + baseUrl + "</a></code>.", "    </dd>", ""));
        }
        sbuf.append(String.join((CharSequence)"\n", "<dt><code>&lt;action-type&gt;</code></dt>", "<dd>The action type string determines the kind of request,", "    and is one of the strings", serviceMap.keySet().stream().map(s -> "\"<code>" + s + "</code>\"").collect(Collectors.joining(", ")) + ";", "    see below for details.", "    </dd>", "<dt><code>&lt;plot-spec&gt;</code></dt>", "<dd>The plot specification is an ampersand-separated", "    STILTS plot command string; the form is \"<code>&lt;command-name&gt;&amp;&lt;arg-name&gt;=&lt;value&gt;&amp;&lt;arg-name&gt;=&lt;value&gt;...</code>\"", "    for instance \"<code>plot2sky&amp;layer1=mark&amp;in1=stars.vot&amp;lon1=ra&amp;lat1=dec</code>\".", "   See STILTS plotting documentation in", "   " + plotDocref, "   for command syntax.", "   Note that although this part contains", "   <code>&amp;</code>-separated <code>name=value</code> pairs", "   which are syntactically", "   <code>application/x-www-form-urlencoded</code>", "   it is part of the URI path and <em>not</em> a URI query string", "   since it does not come after a question mark", "   ('<code>?</code>')", "   and it <em>cannot</em> be supplied by POSTing parameters.", "   </dd>", "<dt><code>&lt;session-id&gt;</code></dt>", "<dd>The session identifier is of the form", "    \"<code>sessionId=&lt;unique-string&gt;</code>\"", "    and it serves to maintain the state of the plot", "    between requests (so that for instance a navigation action", "    starts from where the last one left off).", "    The <code>&lt;unique-string&gt;</code> string", "    is chosen by the client;", "    any string value is permitted, but it's up to the client", "    to pick something that is unlikely to be chosen", "    by other unrelated clients on the same or different machines.", "    Incorporating a high-resolution timestamp is a good bet.", "    In case of a collision, confusing results may ensue,", "    but it's probably not necessary to resort to", "    cryptographic-grade hashing.", "    This part is not necessary for the", "    <code>\"" + PlotSession.HTML_SERVICE.getServiceName() + "\"</code>", "    <code>&lt;action-type&gt;</code>.", "</dd>", "<dt><code>&lt;arg-list&gt;</code></dt>", "<dd>A list of zero or more ampersand-separated", "    \"<code>&lt;name&gt;=&lt;value&gt;</code>\" parameters,", "    specific to the <code>&lt;action-type&gt;</code>;", "    see below for details.", "    </dd>", "</dl>", "</p>", "<p>The <code>[?&lt;session-id&gt;&amp;&lt;arg-list&gt;]</code>", "part of the URL is an", "<code>application/x-www-form-urlencoded</code> query-string,", "and may be supplied as a POST body rather than", "as part of the GET query if preferred.", "Note that does <em>not</em> apply to the", "<code>&lt;plot-spec&gt;</code> part,", "which is in RFC3986 terms part of the <em>path</em>", "and not part of the <em>query</em>.", "</p>", "", "<h3>Available Action Types</h3>", "<p>The options for the various different values of the", "<code>&lt;action-type&gt;</code> string,", "with their associated parameters and response values,", "are as follows:", "<dl>", ""));
        for (PlotService service : serviceMap.values()) {
            sbuf.append("<dt><code>").append(service.getServiceName()).append("</code></dt>\n").append("<dd>").append(service.getXmlDescription());
            sbuf.append("</dd>\n");
        }
        sbuf.append(String.join((CharSequence)"\n", "</dl>", "</p>", ""));
        return sbuf.toString();
    }

    private static String getSingleParameter(HttpServletRequest request, String name) {
        Object value = request.getParameterMap().get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String[]) {
            String[] values = (String[])value;
            return values.length == 1 ? values[0] : null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    private static Map<String, String> mimeTypes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(".txt", "text/plain");
        map.put(".html", "text/html");
        map.put(".js", "text/javascript");
        map.put(".png", "image/png");
        map.put(".py", "text/x-python");
        map.put(".ipynb", "application/x-ipynb+json");
        map.put(".xml", "application/xml");
        return Collections.unmodifiableMap(map);
    }

    private static String alink(String url) {
        return new StringBuffer().append("<a href='").append(url).append("'>").append(url).append("</a>").toString();
    }

    private static Map<String, PlotService> createServiceMap() {
        LinkedHashMap<String, PlotService> map = new LinkedHashMap<String, PlotService>();
        for (PlotService service : PlotSession.SERVICES) {
            map.put(service.getServiceName(), service);
        }
        return Collections.unmodifiableMap(map);
    }
}

