/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.taplint.DatalinkCode;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.HoldReporter;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.VotLintTapRunner;
import uk.ac.starlink.ttools.votlint.VocabChecker;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.ContentType;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.DatalinkVersion;
import uk.ac.starlink.vo.Ivoid;
import uk.ac.starlink.vo.datalink.LinkColMap;
import uk.ac.starlink.vo.datalink.LinksDoc;
import uk.ac.starlink.vo.datalink.ServiceInvoker;
import uk.ac.starlink.votable.ParamElement;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOStarTable;
import uk.ac.starlink.votable.VOTableVersion;
import uk.ac.starlink.votable.datalink.ServiceDescriptor;
import uk.ac.starlink.votable.datalink.ServiceDescriptorFactory;
import uk.ac.starlink.votable.datalink.ServiceParam;

public class DatalinkValidator {
    private final Reporter reporter_;
    private final DatalinkVersion version_;
    private static final String CANONICAL_DL_CTYPE = "application/x-votable+xml;content=datalink";
    private static final Pattern FAULT_REGEX = Pattern.compile("(NotFound|Usage|Transient|Fatal|Default)Fault(:.*)?");
    private static final VocabChecker SEMANTICS_CHECKER = VocabChecker.DATALINK_CORE;
    private static final VocabChecker CONTENTQUALIFIER_CHECKER = VocabChecker.PRODUCT_TYPE;
    private static final String DATALINK_URI = "ivo://ivoa.net/std/DataLink";

    public DatalinkValidator(Reporter reporter, DatalinkVersion version) {
        this.reporter_ = reporter;
        this.version_ = version;
    }

    public void validateDatalink(URL url, boolean isLinksService, boolean mustSucceed) {
        VODocument vodoc;
        InputStream in;
        int httpCode;
        URLConnection conn;
        this.reporter_.report(DatalinkCode.I_GEDL, "Retrieving DataLink document from " + url);
        try {
            conn = AuthManager.getInstance().connect(url);
            httpCode = conn instanceof HttpURLConnection ? ((HttpURLConnection)conn).getResponseCode() : -1;
        }
        catch (IOException e) {
            String msg = new StringBuffer().append("DataLink invocation failed at ").append(url).append(" (").append(e).append(")").toString();
            this.reporter_.report(DatalinkCode.E_DCER, msg);
            int httpCode2 = -1;
            return;
        }
        HttpURLConnection hconn = conn instanceof HttpURLConnection ? (HttpURLConnection)conn : null;
        Compression compression = this.getCompression(conn);
        try {
            in = compression.decompress(conn.getInputStream());
        }
        catch (IOException e) {
            InputStream err;
            if (hconn != null && isLinksService && (err = hconn.getErrorStream()) != null) {
                this.checkErrorVOTable(err, url, hconn.getContentType());
            }
            String msg = new StringBuffer().append("DataLink invocation ").append(conn.getURL()).append(" failed").append(httpCode >= 0 ? " " + httpCode : "").append(" (").append(e).append(")").toString();
            this.reporter_.report(mustSucceed ? DatalinkCode.E_DCER : DatalinkCode.W_QERR, msg);
            return;
        }
        try {
            vodoc = this.readVODocument(in);
        }
        catch (IOException e) {
            String msg = new StringBuffer().append("Error reading data from ").append(url).append(": ").append(e).toString();
            this.reporter_.report(DatalinkCode.E_DCER, msg);
            return;
        }
        catch (SAXException e) {
            String msg = new StringBuffer().append("Badly-formed XML (not VOTable): ").append(url).append(" (").append(e).append(")").toString();
            this.reporter_.report(DatalinkCode.E_VTSX, msg);
            return;
        }
        DatalinkVersion version = this.getEffectiveVersion(vodoc);
        if (hconn != null) {
            this.checkVOTableContentType(hconn.getContentType(), url, isLinksService, version);
        }
        this.validateDatalink(vodoc, version);
    }

    public void validateDatalink(InputStream in) {
        VODocument vodoc;
        this.reporter_.report(DatalinkCode.I_GEDL, "Reading DataLink document from standard input");
        try {
            vodoc = this.readVODocument(in);
        }
        catch (IOException e) {
            String msg = new StringBuffer().append("Error reading data: ").append(e).toString();
            this.reporter_.report(DatalinkCode.E_DCER, msg);
            return;
        }
        catch (SAXException e) {
            String msg = new StringBuffer().append("Badly-formed XML (not VOTable): ").append(e).toString();
            this.reporter_.report(DatalinkCode.E_VTSX, msg);
            return;
        }
        DatalinkVersion version = this.getEffectiveVersion(vodoc);
        this.validateDatalink(vodoc, version);
    }

    public void validateDatalink(VODocument vodoc, DatalinkVersion version) {
        LinksDoc linksDoc = this.createLinksDoc(vodoc, version);
        if (linksDoc != null) {
            this.validateLinksDoc(linksDoc, version);
        }
    }

    public void validateLinksDoc(LinksDoc linksDoc, DatalinkVersion version) {
        Map<String, ServiceInvoker> invokerMap = this.createServiceInvokerMap(linksDoc);
        try {
            this.attemptValidateLinksDocRows(linksDoc, invokerMap, version);
        }
        catch (IOException e) {
            String msg = new StringBuffer().append("Unexpected read error for datalinks table: ").append(e).toString();
            this.reporter_.report(DatalinkCode.F_UNEX, msg);
        }
    }

    public LinksDoc createLinksDoc(VODocument vodoc, DatalinkVersion version) {
        VOStarTable resultTable;
        Map<String, List<VOElement>> resourceMap = this.getTypedResources(vodoc);
        if (resourceMap == null) {
            return null;
        }
        List<VOElement> resultsResources = resourceMap.get("results");
        int nres = resultsResources.size();
        if (nres != 1) {
            String msg = new StringBuffer().append(nres == 0 ? "No " : "Multiple (" + nres + ") ").append("<RESOURCE type='results'> elements ").append("in datalink VOTable").toString();
            this.reporter_.report(DatalinkCode.E_URES, msg);
            return null;
        }
        VOElement resultsResource = resultsResources.get(0);
        NodeList tableEls = resultsResource.getElementsByVOTagName("TABLE");
        int ntab = tableEls.getLength();
        if (ntab != 1) {
            String msg = new StringBuffer().append(ntab == 0 ? "No " : "Multiple (" + ntab + ") ").append("TABLEs in datalink <RESOURCE type='results'> ").append("element").toString();
            this.reporter_.report(DatalinkCode.E_UTAB, msg);
            return null;
        }
        if (version.is11()) {
            Object[] stdids = this.getDeclaredStandardIdStrings(resultsResource);
            Ivoid reqStdid = version.getStandardId();
            boolean hasDlid = Arrays.stream(stdids).anyMatch(s -> new Ivoid(s).equalsIvoid(reqStdid));
            if (!hasDlid) {
                StringBuffer sbuf = new StringBuffer().append("Missing DataLink standard identifier; ").append("<INFO name=\"standardID\" ").append("value=\"").append(reqStdid).append("\">").append(" should appear in results RESOURCE");
                if (stdids.length > 0) {
                    sbuf.append(". These standardIDs do appear: ").append(Arrays.toString(stdids));
                }
                this.reporter_.report(DatalinkCode.E_DSTD, sbuf.toString());
            }
        }
        TableElement tableEl = (TableElement)tableEls.item(0);
        try {
            resultTable = new VOStarTable(tableEl);
        }
        catch (IOException e) {
            this.reporter_.report(DatalinkCode.F_UNEX, "Unexpected error: " + e);
            return null;
        }
        VOElement dataEl = tableEl.getChildByName("DATA");
        if (dataEl != null) {
            for (VOElement dataChild : dataEl.getChildren()) {
                String dname = dataChild.getVOTagName();
                if (!"FITS".equals(dname) && !"BINARY".equals(dname) && !"BINARY2".equals(dname)) continue;
                String msg = new StringBuffer().append("Illegal serialization format ").append(dname).append("; must be TABLEDATA ").append("except by explicit request").toString();
                this.reporter_.report(DatalinkCode.E_TDSR, msg);
            }
        }
        LinkColMap colMap = this.createColMap((StarTable)resultTable);
        ArrayList<ServiceDescriptor> sdList = new ArrayList<ServiceDescriptor>();
        for (VOElement metaRes : resourceMap.get("meta")) {
            ServiceDescriptor sd;
            if (!"adhoc:service".equals(metaRes.getAttribute("utype"))) continue;
            if (metaRes.getElementsByVOTagName("TABLE").getLength() > 0) {
                this.reporter_.report(DatalinkCode.W_MTAB, "TABLE element(s) in adhoc:service RESOURCE?");
            }
            if ((sd = this.createServiceDescriptor(metaRes)) == null) continue;
            sdList.add(sd);
        }
        ServiceDescriptor[] servDescriptors = sdList.toArray(new ServiceDescriptor[0]);
        int nSd = servDescriptors.length;
        int nIdentified = 0;
        HashSet<String> nameSet = new HashSet<String>();
        HashSet<String> descriptionSet = new HashSet<String>();
        for (ServiceDescriptor sd : servDescriptors) {
            if (sd.getDescriptorId() != null) {
                ++nIdentified;
            }
            String name = sd.getName();
            String descrip = sd.getDescription();
            if (name != null && name.trim().length() > 0) {
                nameSet.add(name.trim());
            }
            if (descrip == null || descrip.trim().length() <= 0) continue;
            descriptionSet.add(descrip.trim());
        }
        String msg = new StringBuffer().append("Service descriptors defined: ").append(nIdentified).append(" referenceable, ").append(nSd - nIdentified).append(" anonymous").toString();
        this.reporter_.report(DatalinkCode.I_SDDF, msg);
        if (nSd > 1) {
            StringBuffer missBuf = new StringBuffer();
            if (nameSet.size() < nSd) {
                missBuf.append("name attributes");
            }
            if (descriptionSet.size() < nSd) {
                missBuf.append(missBuf.length() == 0 ? "" : " and ").append("DESCRIPTION children");
            }
            if (missBuf.length() > 0) {
                String ndMsg = new StringBuffer().append("Multiple service descriptors defined, ").append("but not all have unique ").append(missBuf).toString();
                this.reporter_.report(DatalinkCode.W_SDND, ndMsg);
            }
        }
        return LinksDoc.createLinksDoc((StarTable)resultTable, (LinkColMap)colMap, (ServiceDescriptor[])servDescriptors);
    }

    private VODocument readVODocument(InputStream in) throws IOException, SAXException {
        boolean doChecks = true;
        VOTableVersion minVotVersion = null;
        HoldReporter holder = new HoldReporter();
        VODocument vodoc = VotLintTapRunner.readResultDocument(holder, in, doChecks, minVotVersion);
        holder.dumpReports(this.reporter_);
        return vodoc;
    }

    private DatalinkVersion getEffectiveVersion(VODocument vodoc) {
        String vtype;
        DatalinkVersion version;
        DatalinkVersion requestedVersion = this.version_;
        if (requestedVersion != null) {
            version = requestedVersion;
            vtype = "requested";
        } else {
            DatalinkVersion declaredVersion = this.getDeclaredVersion(vodoc);
            if (declaredVersion != null) {
                version = declaredVersion;
                vtype = "declared";
            } else {
                version = DatalinkVersion.V10;
                vtype = "assumed";
            }
        }
        String msg = new StringBuffer().append("Using ").append(vtype).append(" DataLink version ").append(version.getNumber()).append(" (").append(version.getFullName()).append(")").append(" for validation").toString();
        this.reporter_.report(DatalinkCode.I_DLVR, msg);
        return version;
    }

    private DatalinkVersion getDeclaredVersion(VODocument vodoc) {
        VOElement voel = (VOElement)vodoc.getDocumentElement();
        Object[] declaredDlIvoids = (Ivoid[])Arrays.stream(this.getDeclaredStandardIdStrings(voel)).map(Ivoid::new).filter(ivoid -> ivoid.matchesRegistryPart(DATALINK_URI)).distinct().toArray(Ivoid[]::new);
        int nDecl = declaredDlIvoids.length;
        if (nDecl == 0) {
            return null;
        }
        if (nDecl == 1) {
            DatalinkVersion[] knownVersions;
            Ivoid stdid = declaredDlIvoids[0];
            for (DatalinkVersion dv2 : knownVersions = DatalinkVersion.values()) {
                if (!dv2.getStandardId().equalsIvoid(stdid)) continue;
                return dv2;
            }
            String msg = new StringBuffer().append("Declared standardID \"").append(stdid).append("\" does not match any of the known ").append("DataLink versions (").append(Arrays.stream(knownVersions).map(dv -> dv.getStandardId().toString()).collect(Collectors.joining(", "))).append(")").toString();
            this.reporter_.report(DatalinkCode.E_STDX, msg);
            return null;
        }
        assert (nDecl > 1);
        String msg = new StringBuffer().append("Multiple declared DataLink standardID values: ").append(Arrays.toString(declaredDlIvoids)).toString();
        this.reporter_.report(DatalinkCode.E_STD2, msg);
        return null;
    }

    private String[] getDeclaredStandardIdStrings(VOElement voel) {
        NodeList infoEls = voel.getElementsByVOTagName("INFO");
        int ninfo = infoEls.getLength();
        ArrayList<String> stdids = new ArrayList<String>();
        for (int ii = 0; ii < ninfo; ++ii) {
            Element infoEl;
            Node info = infoEls.item(ii);
            assert (info instanceof Element);
            if (!(info instanceof Element) || !"standardID".equals((infoEl = (Element)info).getAttribute("name")) || !infoEl.hasAttribute("value")) continue;
            stdids.add(infoEl.getAttribute("value"));
        }
        return stdids.toArray(new String[0]);
    }

    private LinkColMap createColMap(StarTable table) {
        HashMap<LinkColMap.ColDef, Integer> icolMap = new HashMap<LinkColMap.ColDef, Integer>();
        int ncol = table.getColumnCount();
        int nExtraCol = 0;
        for (int ic = 0; ic < ncol; ++ic) {
            ColumnInfo info = table.getColumnInfo(ic);
            String name = info.getName();
            LinkColMap.ColDef coldef = (LinkColMap.ColDef)LinkColMap.COLDEF_MAP.get(name);
            if (coldef != null) {
                Class clazz;
                Class reqClazz;
                String msg;
                String stdUcd = coldef.getUcd();
                String ucd = info.getUCD();
                if (ucd == null) {
                    if (stdUcd != null) {
                        msg = new StringBuffer().append("Missing UCD for column ").append(name).append("; should be ").append(stdUcd).toString();
                        this.reporter_.report(DatalinkCode.E_RUCD, msg);
                    }
                } else if (!ucd.equals(stdUcd)) {
                    msg = new StringBuffer().append("Wrong UCD for column ").append(name).append("; ").append(ucd).append(" != ").append(stdUcd).toString();
                    this.reporter_.report(DatalinkCode.E_RUCD, msg);
                }
                if (!(reqClazz = coldef == LinkColMap.COL_CONTENTLENGTH ? Long.class : coldef.getContentClass()).isAssignableFrom(clazz = info.getContentClass())) {
                    String datatype = (String)info.getAuxDatumValue(VOStarTable.DATATYPE_INFO, String.class);
                    String msg2 = new StringBuffer().append("Wrong datatype '").append(datatype).append("' for column ").append(name).append(", should be ").append(reqClazz.getSimpleName().toLowerCase()).toString();
                    this.reporter_.report(DatalinkCode.E_RTYP, msg2);
                }
                if (LinkColMap.COL_CONTENTLENGTH == coldef && !"byte".equals(info.getUnitString())) {
                    String msg3 = new StringBuffer().append("Wrong units (").append(info.getUnitString()).append(") for column ").append(name).append(" - should be 'byte'").toString();
                    this.reporter_.report(DatalinkCode.E_RUNI, msg3);
                }
                if (icolMap.containsKey(coldef)) {
                    this.reporter_.report(DatalinkCode.E_RCOL, "Multiple columns named " + name);
                    continue;
                }
                if (!coldef.getContentClass().isAssignableFrom(clazz)) continue;
                icolMap.put(coldef, ic);
                continue;
            }
            ++nExtraCol;
        }
        if (nExtraCol > 0) {
            this.reporter_.report(DatalinkCode.I_EXCL, "Non-standard columns in results table: " + nExtraCol);
        }
        StringBuffer missingBuf = new StringBuffer();
        for (LinkColMap.ColDef coldef : LinkColMap.COLDEF_MAP.values()) {
            if (!coldef.isRequired() || icolMap.containsKey(coldef)) continue;
            if (missingBuf.length() > 0) {
                missingBuf.append(", ");
            }
            missingBuf.append(coldef.getName());
        }
        if (missingBuf.length() > 0) {
            this.reporter_.report(DatalinkCode.E_RCOL, "Missing/unusable required DataLink columns: " + missingBuf);
        }
        return new LinkColMap(icolMap){};
    }

    /*
     * WARNING - void declaration
     */
    private ServiceDescriptor createServiceDescriptor(VOElement resourceEl) {
        String name;
        void var9_26;
        String msg;
        void var8_16;
        void var8_14;
        ServiceDescriptor sd = new ServiceDescriptorFactory().createServiceDescriptor(resourceEl);
        String sdName = sd.getDescriptorId();
        sdName = sdName == null ? "<unnamed>" : sdName;
        String msg0 = new StringBuffer().append("Service descriptor ").append(sdName).append(", ").append(sd.getInputParams().length).append(" input params").toString();
        this.reporter_.report(DatalinkCode.I_SDDO, msg0);
        LinkedHashMap inParamsMap = new LinkedHashMap();
        Object object = ParamType.values();
        int n = ((ParamType[])object).length;
        boolean bl = false;
        while (var8_14 < n) {
            ParamType paramType = object[var8_14];
            inParamsMap.put(paramType, new ArrayList());
            ++var8_14;
        }
        object = sd.getInputParams();
        int n2 = ((ParamType[])object).length;
        boolean bl2 = false;
        while (var8_16 < n2) {
            ParamType paramType = object[var8_16];
            String value = paramType.getValue();
            ParamType ptype = paramType.getRef() != null ? ParamType.ROW : (value != null && value.length() > 0 ? ParamType.FIXED : ParamType.USER);
            ((List)inParamsMap.get((Object)ptype)).add(paramType.getName());
            ++var8_16;
        }
        for (Map.Entry entry : inParamsMap.entrySet()) {
            List list = (List)entry.getValue();
            int n3 = list.size();
            msg = new StringBuffer().append(entry.getKey()).append(" parameter count ").append(n3).append(n3 > 0 ? " " + list : "").toString();
            this.reporter_.report(DatalinkCode.I_SDPR, msg);
        }
        HashMap<String, Integer> paramCounts = new HashMap<String, Integer>();
        paramCounts.put("accessURL", 0);
        paramCounts.put("standardID", 0);
        paramCounts.put("resourceIdentifier", 0);
        paramCounts.put("contentType", 0);
        VOElement[] vOElementArray = resourceEl.getChildrenByName("PARAM");
        int n4 = vOElementArray.length;
        boolean bl3 = false;
        while (var9_26 < n4) {
            VOElement pEl = vOElementArray[var9_26];
            ParamElement paramEl = (ParamElement)pEl;
            name = paramEl.getName();
            Integer count = (Integer)paramCounts.get(name);
            if (count != null) {
                String value = paramEl.getValue();
                String datatype = paramEl.getDatatype();
                long[] arraysize = paramEl.getArraysize();
                if (!"char".equals(datatype) && !"unicodeChar".equals(datatype) || arraysize.length != 1 || arraysize[0] == 0L || arraysize[0] == 1L) {
                    String msg2 = new StringBuffer().append("Non-string service descriptor param ").append(name).append(": ").append("datatype='").append(datatype).append("', ").append("arraysize='").append(paramEl.getAttribute("arraysize")).append("'").toString();
                    this.reporter_.report(DatalinkCode.E_PSNS, msg2);
                }
                paramCounts.put(name, count + 1);
            }
            ++var9_26;
        }
        for (Map.Entry entry : paramCounts.entrySet()) {
            int n5 = (Integer)entry.getValue();
            if (n5 <= 1) continue;
            msg = new StringBuffer().append("Duplicated service PARAM ").append((String)entry.getKey()).append(" (").append(n5).append(" copies)").toString();
            this.reporter_.report(DatalinkCode.W_PSDU, msg);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (ServiceParam inParam : sd.getInputParams()) {
            name = inParam.getName();
            if (hashSet.add(name)) continue;
            String msg3 = new StringBuffer().append("Duplicated input parameter ").append(name).append(" in service descriptor ").append(sdName).toString();
            this.reporter_.report(DatalinkCode.W_PIDU, msg3);
        }
        return sd;
    }

    private Map<String, List<VOElement>> getTypedResources(VODocument vodoc) {
        VOElement voEl = (VOElement)vodoc.getDocumentElement();
        if (!"VOTABLE".equals(voEl.getVOTagName())) {
            String msg = new StringBuffer().append("Top-level element of result document is ").append(voEl.getTagName()).append(" not VOTABLE").toString();
            this.reporter_.report(DatalinkCode.E_BVOT, msg);
            return null;
        }
        LinkedHashMap<String, List<VOElement>> resourceMap = new LinkedHashMap<String, List<VOElement>>();
        resourceMap.put("results", new ArrayList());
        resourceMap.put("meta", new ArrayList());
        NodeList resList = voEl.getElementsByVOTagName("RESOURCE");
        int nUntyped = 0;
        for (int i = 0; i < resList.getLength(); ++i) {
            String type;
            VOElement resEl = (VOElement)resList.item(i);
            String string = type = resEl.hasAttribute("type") ? resEl.getAttribute("type") : null;
            if (type == null) {
                ++nUntyped;
                continue;
            }
            if (!"results".equals(type) && !"meta".equals(type)) continue;
            ((List)resourceMap.get(type)).add(resEl);
        }
        if (nUntyped > 0) {
            String msg = new StringBuffer().append(nUntyped).append(" RESOURCE elements without type attribute").toString();
            this.reporter_.report(DatalinkCode.I_RNTY, msg);
        }
        return resourceMap;
    }

    private Map<String, ServiceInvoker> createServiceInvokerMap(LinksDoc linksDoc) {
        HashSet<String> fieldIds = new HashSet<String>();
        StarTable resultTable = linksDoc.getResultTable();
        int ncol = resultTable.getColumnCount();
        for (int ic = 0; ic < ncol; ++ic) {
            String ref = (String)resultTable.getColumnInfo(ic).getAuxDatumValue(VOStarTable.ID_INFO, String.class);
            if (ref == null || ref.trim().length() <= 0) continue;
            fieldIds.add(ref.trim());
        }
        LinkedHashMap<String, ServiceInvoker> invokerMap = new LinkedHashMap<String, ServiceInvoker>();
        for (ServiceDescriptor sd : linksDoc.getServiceDescriptors()) {
            ServiceInvoker invoker;
            ServiceParam[] mimeType;
            String contentType;
            String standardId;
            boolean canInvoke = true;
            String sdId = sd.getDescriptorId();
            String sdName = sdId == null ? "<unnamed>" : sdId;
            String accessUrl = sd.getAccessUrl();
            if (accessUrl == null) {
                String msg = new StringBuffer().append("Missing accessURL PARAM for service descriptor ").append(sdName).toString();
                this.reporter_.report(DatalinkCode.E_SAC0, msg);
                canInvoke = false;
            } else {
                try {
                    URLUtils.newURL((String)accessUrl);
                }
                catch (MalformedURLException e) {
                    String msg = new StringBuffer().append("Bad accessURL PARAM for service descriptor ").append(sdName).toString();
                    this.reporter_.report(DatalinkCode.E_SACB, msg);
                    canInvoke = false;
                }
            }
            String ivoid = sd.getResourceIdentifier();
            if (ivoid != null) {
                // empty if block
            }
            if ((standardId = sd.getStandardId()) != null) {
                // empty if block
            }
            if ((contentType = sd.getContentType()) != null && (mimeType = ContentType.parseContentType((String)contentType)) == null) {
                String msg = new StringBuffer().append("Bad MIME type syntax for contentType PARAM ").append("in service descriptor ").append(sdName).append(": ").append(contentType).toString();
                this.reporter_.report(DatalinkCode.E_DRCT, msg);
            }
            mimeType = sd.getInputParams();
            int msg = mimeType.length;
            for (int i = 0; i < msg; ++i) {
                String msg2;
                ServiceParam sp = mimeType[i];
                String ref = sp.getRef();
                if (ref == null) continue;
                if (!fieldIds.contains(ref)) {
                    msg2 = new StringBuffer().append("No FIELD with ID='").append(ref).append("' required by inputParam ").append(sp.getName()).toString();
                    this.reporter_.report(DatalinkCode.E_SARF, msg2);
                    canInvoke = false;
                }
                if (sp.getValue() == null && sp.getMinMax() == null && sp.getOptions() == null) continue;
                msg2 = new StringBuffer().append("VALUES or @value are present ").append("alongside @ref in inputParam ").append(sp.getName()).toString();
                this.reporter_.report(DatalinkCode.W_SAVV, msg2);
            }
            try {
                invoker = new ServiceInvoker(sd, resultTable);
            }
            catch (IOException e) {
                invoker = null;
            }
            assert (canInvoke == (invoker != null));
            if (sdId == null) continue;
            invokerMap.put(sdId, invoker);
        }
        return invokerMap;
    }

    private void attemptValidateLinksDocRows(LinksDoc linksDoc, Map<String, ServiceInvoker> invokerMap, DatalinkVersion version) throws IOException {
        LinkColMap colMap = linksDoc.getColumnMap();
        HashMap noParams = new HashMap();
        HashSet<String> idSet = new HashSet<String>();
        String lastId = null;
        int jrow = 0;
        RowSequence rseq = linksDoc.getResultTable().getRowSequence();
        while (rseq.next()) {
            String linkAuth;
            String cqual;
            String msg;
            String semantics;
            String msg2;
            String msg3;
            ++jrow;
            Object[] row = rseq.getRow();
            String id = colMap.getId(row);
            if (id == null) {
                this.reporter_.report(DatalinkCode.E_DRID, "Missing ID for row " + jrow);
            } else if (version.is11()) {
                if (!id.equals(lastId) && idSet.contains(id)) {
                    String msg4 = new StringBuffer().append("Non-contiguous results for ID \"").append(id).append("\" in output").toString();
                    this.reporter_.report(DatalinkCode.E_IDSQ, msg4);
                }
                idSet.add(id);
                lastId = id;
            }
            String accessUrl = colMap.getAccessUrl(row);
            String serviceDef = colMap.getServiceDef(row);
            String errorMsg = colMap.getErrorMessage(row);
            int nrcol = (accessUrl == null ? 0 : 1) + (serviceDef == null ? 0 : 1) + (errorMsg == null ? 0 : 1);
            if (nrcol != 1) {
                msg3 = new StringBuffer().append("Not exactly one non-null of ").append("access_url (").append(accessUrl).append("), ").append("service_def (").append(serviceDef).append("), ").append("error_message (").append(errorMsg).append(")").append(" at row ").append(jrow).toString();
                this.reporter_.report(DatalinkCode.E_DRR1, msg3);
            }
            if (accessUrl != null) {
                try {
                    URL url = URLUtils.newURL((String)accessUrl);
                    msg2 = new StringBuffer().append("Row ").append(jrow).append(": access URL ").append(url).toString();
                    this.reporter_.report(DatalinkCode.I_IKAC, msg2);
                }
                catch (MalformedURLException e) {
                    msg2 = new StringBuffer().append("Bad access URL at row ").append(jrow).append(": ").append(accessUrl).append(" (").append(e).append(")").toString();
                    this.reporter_.report(DatalinkCode.E_DRUR, msg2);
                }
            }
            if (errorMsg != null) {
                if (!FAULT_REGEX.matcher(errorMsg.trim()).matches()) {
                    msg3 = new StringBuffer().append("Bad error message syntax at row ").append(jrow).append(": ").append(errorMsg).toString();
                    this.reporter_.report(DatalinkCode.E_DRER, msg3);
                }
                msg3 = new StringBuffer().append("Row ").append(jrow).append(": ").append("error message \"").append(errorMsg).append("\"").toString();
                this.reporter_.report(DatalinkCode.I_IKER, msg3);
            }
            if (serviceDef != null) {
                ServiceInvoker invoker;
                if (!invokerMap.containsKey(serviceDef)) {
                    msg3 = new StringBuffer().append("No service descriptor resource with ID='").append(serviceDef).append("' at row ").append(jrow).toString();
                    this.reporter_.report(DatalinkCode.E_DRSI, msg3);
                }
                if ((invoker = invokerMap.get(serviceDef)) != null) {
                    URL url = invoker.getUrl(row, noParams);
                    String msg5 = new StringBuffer().append("Row ").append(jrow).append(": ").append("service ").append(serviceDef).append(" invocation ").append(invoker.getUserParams().length == 0 ? "(full) " : "(partial) ").append(url).toString();
                    this.reporter_.report(DatalinkCode.I_IKSD, msg5);
                }
            }
            if ((semantics = colMap.getSemantics(row)) == null) {
                this.reporter_.report(DatalinkCode.E_DRS0, "Null semantics entry for row " + jrow);
            } else if (semantics.startsWith("#") || semantics.startsWith(SEMANTICS_CHECKER.getVocabularyUri() + "#")) {
                String frag = semantics.substring(semantics.indexOf(35) + 1);
                this.checkVocab(SEMANTICS_CHECKER, frag, "semantics", jrow, DatalinkCode.W_SMCO, DatalinkCode.E_SMCO);
            } else {
                msg2 = new StringBuffer().append("Non-core semantics term at row ").append(jrow).append(": ").append(semantics).toString();
                this.reporter_.report(DatalinkCode.I_SMCU, msg2);
            }
            String contentType = colMap.getContentType(row);
            if (contentType != null) {
                ContentType mimeType = ContentType.parseContentType((String)contentType);
                if (mimeType == null) {
                    msg = new StringBuffer().append("Bad MIME type syntax for content_type").append(" at row ").append(jrow).append(": ").append(contentType).toString();
                    this.reporter_.report(DatalinkCode.E_DRCT, msg);
                } else if (contentType.toLowerCase().indexOf("datalink") >= 0 && !CANONICAL_DL_CTYPE.equals(contentType)) {
                    msg = new StringBuffer().append("content_type '").append(contentType).append("' contains 'datalink' but is not ").append(CANONICAL_DL_CTYPE).append(" at row ").append(jrow).toString();
                    this.reporter_.report(DatalinkCode.W_DRCT, msg);
                }
            }
            if (version.is11() && (cqual = colMap.getContentQualifier(row)) != null) {
                if (cqual.startsWith("#") || cqual.startsWith(CONTENTQUALIFIER_CHECKER.getVocabularyUri() + "#")) {
                    String frag = cqual.substring(cqual.indexOf(35) + 1);
                    this.checkVocab(CONTENTQUALIFIER_CHECKER, frag, "content_qualifier", jrow, DatalinkCode.W_CQCO, DatalinkCode.E_CQCO);
                } else {
                    msg = new StringBuffer().append("Content qualifier from").append(" non-standard vocabulary").append(" at row ").append(jrow).append(": ").append(cqual).toString();
                    this.reporter_.report(DatalinkCode.I_CQCU, msg);
                }
            }
            if (!version.is11() || (linkAuth = colMap.getLinkAuth(row)) == null || "false".equals(linkAuth) || "true".equals(linkAuth) || "optional".equals(linkAuth)) continue;
            msg = new StringBuffer().append("Bad link_auth value \"").append(linkAuth).append("\", should be ").append("\"false\", \"true\", \"optional\"").append(" or null").toString();
            this.reporter_.report(DatalinkCode.E_LKAZ, msg);
        }
        rseq.close();
        this.reporter_.report(DatalinkCode.I_DLNR, "Datalink table rows checked: " + jrow);
    }

    private void checkVocab(VocabChecker checker, String term, final String colName, final int jrow, final DatalinkCode warnCode, final DatalinkCode errCode) {
        checker.checkTerm(term, new VocabChecker.TermReporter(){

            @Override
            public void termFound() {
            }

            @Override
            public void termPreliminary(String msg) {
                DatalinkValidator.this.reporter_.report(warnCode, this.message("Preliminary", msg));
            }

            @Override
            public void termDeprecated(String msg) {
                DatalinkValidator.this.reporter_.report(warnCode, this.message("Deprecated", msg));
            }

            @Override
            public void termUnknown(String msg) {
                DatalinkValidator.this.reporter_.report(errCode, this.message("Unknown", msg));
            }

            private String message(String type, String msg) {
                return new StringBuffer().append(type).append(' ').append(colName).append(" term at row ").append(jrow).append(": ").append(msg).toString();
            }
        });
    }

    private void checkErrorVOTable(InputStream in, URL url, String contentType) {
        String statusText;
        String value;
        VODocument vodoc;
        try {
            vodoc = this.readVODocument(in);
        }
        catch (IOException e) {
            String msg = new StringBuffer().append("Error reading error VOTable response at ").append(url).append(" (").append(e).append(")").toString();
            this.reporter_.report(DatalinkCode.E_DCER, msg);
            return;
        }
        catch (SAXException e) {
            String msg = new StringBuffer().append("Badly-formed XML (not VOTable) at ").append(url).append(" (").append(e).append(")").toString();
            this.reporter_.report(DatalinkCode.E_ENVO, msg);
            return;
        }
        this.checkVOTableContentType(contentType, url, false, this.version_);
        Map<String, List<VOElement>> resourceMap = this.getTypedResources(vodoc);
        if (resourceMap == null) {
            return;
        }
        List<VOElement> resultsResources = resourceMap.get("results");
        int nres = resultsResources.size();
        if (nres != 1) {
            String msg = new StringBuffer().append(nres == 0 ? "No " : "Multiple (" + nres + ") ").append("<RESOURCE type='results'> elements ").append("in error VOTable").toString();
            this.reporter_.report(DatalinkCode.E_URES, msg);
            return;
        }
        VOElement resultsEl = resultsResources.get(0);
        ArrayList<VOElement> statusEls = new ArrayList<VOElement>();
        NodeList infoEls = resultsEl.getElementsByVOTagName("INFO");
        for (int i = 0; i < infoEls.getLength(); ++i) {
            VOElement infoEl = (VOElement)infoEls.item(i);
            if (!"QUERY_STATUS".equals(infoEl.getName())) continue;
            statusEls.add(infoEl);
        }
        int nstat = statusEls.size();
        if (nstat != 1) {
            String msg = new StringBuffer().append(nstat == 0 ? "No " : "Multiple (" + nstat + ")").append("<INFO name='QUERY_STATUS'> elements ").append("in error VOTable").toString();
            this.reporter_.report(DatalinkCode.E_ERDC, msg);
            return;
        }
        VOElement statusEl = (VOElement)statusEls.get(0);
        String string = value = statusEl.hasAttribute("value") ? statusEl.getAttribute("value") : null;
        if (!"ERROR".equals(value)) {
            String msg = new StringBuffer().append("Element <INFO name='QUERY_STATUS'> ").append("in error document ").append("has non-ERROR value ").append(value).toString();
            this.reporter_.report(DatalinkCode.E_ERDC, msg);
        }
        if ((statusText = DOMUtils.getTextContent((Element)statusEl)) == null || statusText.trim().length() == 0) {
            String msg = new StringBuffer().append("Missing error message in ").append("<INFO name='QUERY_STATUS' value='ERROR'> element").toString();
            this.reporter_.report(DatalinkCode.E_ERDC, msg);
        } else if (!FAULT_REGEX.matcher(statusText.trim()).matches()) {
            String msg = new StringBuffer().append("Bad fault message syntax in ").append("<INFO name='QUERY_STATUS' value='ERROR'> element").toString();
            this.reporter_.report(DatalinkCode.E_ERDC, msg);
        }
    }

    private void checkVOTableContentType(String ctypeTxt, URL url, boolean isLinksResult, DatalinkVersion version) {
        String msg;
        if (ctypeTxt == null || ctypeTxt.trim().length() == 0) {
            this.reporter_.report(DatalinkCode.W_NOCT, "No Content-Type header for " + url);
            return;
        }
        ContentType ctype = ContentType.parseContentType((String)ctypeTxt);
        if (ctype == null) {
            this.reporter_.report(DatalinkCode.E_DRCT, "Invalid Content-Type header " + ctypeTxt + " for " + url);
            return;
        }
        assert (ctype != null);
        if (!ctype.matches("text", "xml") && !ctype.matches("application", "x-votable+xml")) {
            msg = "Bad content type " + ctype + " for HTTP response which should contain " + "VOTable result or error document" + " (" + url + ")";
            this.reporter_.report(DatalinkCode.E_VTCT, msg);
        }
        if (isLinksResult) {
            if (!ctype.matches("application", "x-votable+xml") || !"datalink".equals(ctype.getParameter("content"))) {
                msg = new StringBuffer().append("Content-Type ").append(ctypeTxt).append("does not match canonical form ").append(CANONICAL_DL_CTYPE).append(" for DataLink service ").append(url).toString();
                DatalinkCode code = version == null || version.is11() ? DatalinkCode.W_DLCT : DatalinkCode.E_DLCT;
                this.reporter_.report(code, msg);
            } else if (!CANONICAL_DL_CTYPE.equals(ctypeTxt)) {
                msg = new StringBuffer().append("Content-Type ").append(ctypeTxt).append(" does not exactly match canonical form ").append(CANONICAL_DL_CTYPE).append(" for DataLink service ").append(url).toString();
                this.reporter_.report(DatalinkCode.W_DLCT, msg);
            }
        }
    }

    private Compression getCompression(URLConnection conn) {
        Compression compression;
        String cCoding = conn.getContentEncoding();
        if (cCoding == null || cCoding.trim().length() == 0 || "identity".equals(cCoding)) {
            compression = Compression.NONE;
        } else if ("gzip".equals(cCoding) || "x-gzip".equals(cCoding)) {
            compression = Compression.GZIP;
        } else if ("compress".equals(cCoding) || "x-compress".equals(cCoding)) {
            compression = Compression.COMPRESS;
        } else {
            this.reporter_.report(FixedCode.W_CEUK, "Unknown Content-Encoding " + cCoding + " for " + conn.getURL());
            compression = Compression.NONE;
        }
        if (compression != Compression.NONE) {
            this.reporter_.report(FixedCode.W_CEZZ, "Compression with Content-Encoding " + cCoding + " for " + conn.getURL());
        }
        return compression;
    }

    private static enum ParamType {
        FIXED,
        ROW,
        USER;

    }
}

